/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.android;

import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.android.IBionicStat;
import matteroverdrive.client.data.Color;
import matteroverdrive.entity.player.AndroidPlayer;
import matteroverdrive.gui.android.AndroidHudElement;
import matteroverdrive.gui.android.AndroidHudPosition;
import matteroverdrive.gui.android.AndroidHudStats;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class AndroidHudBionicStats
extends AndroidHudElement {
    public static final int STATS_PER_ROW = 6;
    private int lastHeightCount = 0;

    public AndroidHudBionicStats(AndroidHudPosition position, String name) {
        super(position, name, 174, 0);
    }

    @Override
    public boolean isVisible(AndroidPlayer android) {
        return true;
    }

    @Override
    public void drawElement(AndroidPlayer android, int mouseX, int mouseY, ScaledResolution resolution, float ticks) {
        int count = 0;
        for (int i = 0; i < android.func_70302_i_(); ++i) {
            if (android.func_70301_a(i) == null) continue;
            this.drawAndroidPart(android.func_70301_a(i), this.baseColor, this.getX(count, resolution, android), this.getY(count, resolution, android));
            ++count;
        }
        for (Object object : android.getUnlocked().func_150296_c()) {
            int level;
            IBionicStat stat = MatterOverdrive.statRegistry.getStat(object.toString());
            if (stat == null || !stat.showOnHud(android, level = android.getUnlockedLevel(stat))) continue;
            if (!stat.isEnabled(android, level)) {
                this.drawBioticStat(stat, android, level, Reference.COLOR_HOLO_RED, this.getX(count, resolution, android), this.getY(count, resolution, android));
            } else {
                this.drawBioticStat(stat, android, level, this.baseColor, this.getX(count, resolution, android), this.getY(count, resolution, android));
            }
            ++count;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        if (this.getPosition().y == 1.0f) {
            this.mc.field_71446_o.func_110577_a(AndroidHudStats.top_element_bg);
            RenderUtils.drawPlane(12.0f - 24.0f * this.getPosition().x, Math.ceil((double)count / 6.0) * 24.0 + 4.0, 0.0, 174.0, 11.0);
        } else if ((double)this.getPosition().y == 0.5) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(22.0f + (float)(this.getWidth(resolution, android) - 24) * this.getPosition().x), (double)0.0, (double)0.0);
            GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
            this.mc.field_71446_o.func_110577_a(AndroidHudStats.top_element_bg);
            RenderUtils.drawPlane(0.0, 0.0, 0.0, 174.0, 11.0);
            GL11.glPopMatrix();
        } else {
            this.mc.field_71446_o.func_110577_a(AndroidHudStats.top_element_bg);
            RenderUtils.drawPlane(12.0f - 24.0f * this.getPosition().x, 10.0, 0.0, 174.0, 11.0);
        }
        this.lastHeightCount = count;
    }

    private int getTotalElementCount(AndroidPlayer android) {
        int count = 0;
        for (int i = 0; i < android.func_70302_i_(); ++i) {
            if (android.func_70301_a(i) == null) continue;
            ++count;
        }
        for (Object object : android.getUnlocked().func_150296_c()) {
            int level;
            IBionicStat stat = MatterOverdrive.statRegistry.getStat(object.toString());
            if (stat == null || !stat.showOnHud(android, level = android.getUnlockedLevel(stat))) continue;
            ++count;
        }
        return count;
    }

    private void drawAndroidPart(ItemStack stack, Color color, int x, int y) {
        this.drawNormalBG(color, x, y);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glBlendFunc((int)770, (int)1);
        RenderUtils.renderStack(x + 3, y + 3, stack);
        GL11.glDisable((int)3042);
    }

    private void drawBioticStat(IBionicStat stat, AndroidPlayer androidPlayer, int level, Color color, int x, int y) {
        if (stat.isActive(androidPlayer, level)) {
            this.drawActiveBG(color, x, y);
        } else {
            this.drawNormalBG(color, x, y);
        }
        GL11.glEnable((int)3042);
        ClientProxy.holoIcons.renderIcon(stat.getIcon(level), (double)(x + 2), (double)(y + 2), 18, 18);
        if (stat.getDelay(androidPlayer, level) > 0) {
            String delay = MOStringHelper.formatRemainingTime((float)stat.getDelay(androidPlayer, level) / 20.0f, true);
            int delayWidth = this.mc.field_71466_p.func_78256_a(delay);
            this.mc.field_71466_p.func_78276_b(delay, x + 22 - delayWidth, y + 22 - this.mc.field_71466_p.field_78288_b - 1, Reference.COLOR_HOLO.getColor());
        }
        GL11.glDisable((int)3042);
    }

    private void drawNormalBG(Color color, int x, int y) {
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)this.backgroundAlpha);
        ClientProxy.holoIcons.renderIcon("android_feature_icon_bg_black", (double)x, (double)y, 22, 22);
        GL11.glBlendFunc((int)770, (int)1);
        RenderUtils.applyColorWithAlpha(color);
        ClientProxy.holoIcons.renderIcon("android_feature_icon_bg", (double)x, (double)y, 22, 22);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
    }

    private void drawActiveBG(Color color, int x, int y) {
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)this.backgroundAlpha);
        ClientProxy.holoIcons.renderIcon("android_feature_icon_bg_black", (double)x, (double)y, 22, 22);
        GL11.glBlendFunc((int)770, (int)1);
        RenderUtils.applyColorWithAlpha(color);
        ClientProxy.holoIcons.renderIcon("android_feature_icon_bg_active", (double)x, (double)y, 22, 22);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
    }

    private int getX(int count, ScaledResolution resolution, AndroidPlayer androidPlayer) {
        if ((double)this.getPosition().y == 0.5) {
            return Math.floorDiv(count, this.getHeight(resolution, androidPlayer) / 24) * 24 + 22 - (int)(44.0f * this.getPosition().x);
        }
        return 24 * (count % (this.getWidth(resolution, androidPlayer) / 24)) + 12 - (int)(22.0f * this.getPosition().x);
    }

    private int getY(int count, ScaledResolution resolution, AndroidPlayer androidPlayer) {
        if ((double)this.getPosition().y == 0.5) {
            return 24 * (count % (this.getHeight(resolution, androidPlayer) / 24));
        }
        return Math.floorDiv(count, this.getWidth(resolution, androidPlayer) / 24) * 24 + 22 - (int)(22.0f * this.getPosition().y);
    }

    @Override
    public int getHeight(ScaledResolution resolution, AndroidPlayer androidPlayer) {
        if ((double)this.getPosition().y == 0.5) {
            return this.width;
        }
        int count = this.getTotalElementCount(androidPlayer);
        return (int)Math.ceil((double)count * 24.0 / (double)this.width) * 24 + (int)(24.0f * this.getPosition().y);
    }

    @Override
    public int getWidth(ScaledResolution resolution, AndroidPlayer androidPlayer) {
        if ((double)this.getPosition().y == 0.5) {
            int count = this.getTotalElementCount(androidPlayer);
            return (int)Math.ceil((double)count * 24.0 / (double)this.width) * 24;
        }
        return this.width;
    }
}

