/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.events.IListHandler;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.util.MathHelper;

public class ElementGroupList
extends ElementBaseGroup {
    int selectedIndex;
    int scroll;
    int smoothScroll;
    float smoothScrollMultiply = 0.1f;
    int padding = 6;
    IListHandler listHandler;

    public ElementGroupList(MOGuiBase gui, IListHandler listHandler, int posX, int posY, int width, int height) {
        super(gui, posX, posY, width, height);
        this.listHandler = listHandler;
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void update(int mouseX, int mouseY) {
        super.update(mouseX, mouseY);
        int heightCount = 0;
        int elementsHeight = -(this.getElementsHeight() - this.sizeY);
        for (int i = 0; i < this.elements.size(); ++i) {
            ((MOElementBase)this.elements.get(i)).setPosition(0, heightCount + this.smoothScroll);
            if (this.smoothScroll + (heightCount += ((MOElementBase)this.elements.get(i)).getHeight() + this.padding) >= 0 && heightCount + this.smoothScroll - ((MOElementBase)this.elements.get(i)).getHeight() < this.sizeY) {
                ((MOElementBase)this.elements.get(i)).setVisible(true);
                continue;
            }
            ((MOElementBase)this.elements.get(i)).setVisible(false);
        }
        this.smoothScroll = (int)MOMathHelper.Lerp(this.smoothScroll, this.scroll, this.smoothScrollMultiply);
        this.selectedIndex = MathHelper.func_76125_a((int)this.selectedIndex, (int)0, (int)(this.elements.size() - 1));
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        RenderUtils.beginStencil();
        this.drawStencil(this.posX, this.posY, this.posX + this.sizeX, this.posY + this.sizeY, 1);
        super.drawBackground(mouseX, mouseY, gameTicks);
        RenderUtils.endStencil();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        RenderUtils.beginStencil();
        this.drawStencil(this.posX, this.posY, this.posX + this.sizeX, this.posY + this.sizeY, 1);
        super.drawForeground(mouseX, mouseY);
        RenderUtils.endStencil();
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        mouseX -= this.getGlobalX();
        mouseY -= this.getGlobalY();
        int i = this.getElements().size();
        while (i-- > 0) {
            MOElementBase c = this.getElements().get(i);
            if (!c.isVisible() || !c.isEnabled() || !c.intersectsWith(mouseX, mouseY) || !c.onMousePressed(mouseX, mouseY, mouseButton)) continue;
            this.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        boolean didScroll = super.onMouseWheel(mouseX, mouseY, movement);
        this.scroll = (int)((double)this.scroll + (double)movement * 0.2);
        this.limitScroll();
        return didScroll;
    }

    public void limitScroll() {
        int elementsHeight = -(this.getElementsHeight() - this.sizeY + 32);
        this.scroll = Math.min(0, this.scroll);
        this.scroll = Math.max(elementsHeight, this.scroll);
    }

    public int getElementsHeight() {
        int height = 0;
        for (int i = 0; i < this.elements.size(); ++i) {
            height += ((MOElementBase)this.elements.get(i)).getHeight() + this.padding;
        }
        return height;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        int newSelectedIndex = MathHelper.func_76125_a((int)selectedIndex, (int)0, (int)(this.elements.size() - 1));
        if (newSelectedIndex != this.selectedIndex) {
            this.selectedIndex = newSelectedIndex;
            this.listHandler.ListSelectionChange(this.getName(), selectedIndex);
        } else {
            this.selectedIndex = newSelectedIndex;
        }
    }

    public boolean isSelected(MOElementBase elementBase) {
        if (this.selectedIndex < this.elements.size()) {
            return ((MOElementBase)this.elements.get(this.selectedIndex)).equals(elementBase);
        }
        return false;
    }

    public void setScroll(int scroll) {
        this.scroll = scroll;
    }

    public void resetSmoothScroll() {
        this.smoothScroll = this.scroll;
    }

    public int getScroll() {
        return this.scroll;
    }
}

