/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import java.util.List;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ElementSlot
extends MOElementBase {
    protected HoloIcon icon;
    protected String type = "small";
    protected int iconOffsetX = (this.sizeX - 16) / 2;
    protected int iconOffsetY = (this.sizeY - 16) / 2;
    protected String info = "";

    public ElementSlot(MOGuiBase gui, int posX, int posY, int width, int height, String type, HoloIcon icon) {
        super(gui, posX, posY, width, height);
        this.type = type;
        this.icon = icon;
    }

    public ElementSlot(MOGuiBase gui, int posX, int posY, int width, int height, String type) {
        this(gui, posX, posY, width, height, type, null);
    }

    @Override
    public void addTooltip(List<String> list, int mouseX, int mouseY) {
        if (!this.info.isEmpty()) {
            list.add(MOStringHelper.translateToLocal(this.info));
        }
    }

    @Override
    public void updateInfo() {
    }

    @Override
    public void init() {
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        this.ApplyColor();
        this.gui.bindTexture(ElementSlot.getTexture(this.type));
        this.gui.drawSizedTexturedModalRect(this.posX, this.posY, 0, 0, this.sizeX, this.sizeY, this.sizeX, this.sizeY);
        this.drawSlotIcon(this.icon, this.posX + this.iconOffsetX, this.posY + this.iconOffsetY);
        this.ResetColor();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
    }

    public void drawSlotIcon(HoloIcon icon, int x, int y) {
        if (icon != null && this.canDrawIcon(icon)) {
            GL11.glEnable((int)3042);
            this.ApplyColor();
            GL11.glBlendFunc((int)770, (int)771);
            ClientProxy.holoIcons.bindSheet();
            ClientProxy.holoIcons.renderIcon(icon, (double)x, (double)y);
            GL11.glDisable((int)3042);
            this.ResetColor();
        }
    }

    protected boolean canDrawIcon(HoloIcon icon) {
        return true;
    }

    public void setItemOffset(int x, int y) {
        this.iconOffsetX = x;
        this.iconOffsetY = y;
    }

    public static ResourceLocation getTexture(String type) {
        return new ResourceLocation("mo:textures/gui/elements/slot_" + type + ".png");
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public HoloIcon getIcon() {
        return this.icon;
    }

    public void setIcon(HoloIcon icon) {
        this.icon = icon;
    }

    public void setType(String type) {
        this.type = type;
    }
}

