/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element.starmap;

import java.util.List;
import java.util.Map;
import matteroverdrive.Reference;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.GuiStarMap;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementGroupList;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class ElementAbstractStarMapEntry<T extends SpaceBody>
extends MOElementButton {
    public static ScaleTexture BG = new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/holo_list_entry.png"), 32, 32).setOffsets(18, 12, 15, 15);
    public static ScaleTexture BG_FLIPPED = new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/holo_list_entry_flipped.png"), 32, 32).setOffsets(12, 18, 15, 15);
    public static ScaleTexture BG_MIDDLE_NORMAL = new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/holo_list_entry_middle.png"), 32, 32).setOffsets(15, 15, 15, 15).setTextureSize(96, 32);
    public static ScaleTexture BG_MIDDLE_OVER = new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/holo_list_entry_middle.png"), 32, 32).setOffsets(15, 15, 15, 15).setTextureSize(96, 32).setUV(32, 0);
    public static ScaleTexture BG_MIDDLE_DOWN = new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/holo_list_entry_middle.png"), 32, 32).setOffsets(15, 15, 15, 15).setTextureSize(96, 32).setUV(64, 0);
    public static ScaleTexture BG_CIRCLE = new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/holo_list_entry_circle.png"), 32, 32).setOffsets(15, 15, 15, 15);
    protected T spaceBody;
    protected ElementGroupList groupList;
    protected HoloIcon travelIcon;
    protected HoloIcon searchIcon;

    public ElementAbstractStarMapEntry(GuiStarMap gui, ElementGroupList groupList, int width, int height, T spaceBody) {
        super(gui, groupList, 0, 0, ((SpaceBody)spaceBody).getName(), 0, 0, 0, 0, width, height, "");
        this.spaceBody = spaceBody;
        this.groupList = groupList;
        this.travelIcon = ClientProxy.holoIcons.getIcon("travel_icon");
        this.searchIcon = ClientProxy.holoIcons.getIcon("icon_search");
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        float multiply = this.getMultiply(this.spaceBody);
        RenderUtils.applyColorWithMultipy(this.getSpaceBodyColor(this.spaceBody), multiply);
        if (this.isSelected(this.spaceBody)) {
            this.getBG(this.spaceBody).render(this.posX, this.posY, this.sizeX - 64, this.sizeY);
            if (this.canView(this.spaceBody, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                BG_MIDDLE_NORMAL.render(this.posX + this.sizeX - 64, this.posY, 32, this.sizeY);
            }
            if (this.canTravelTo(this.spaceBody, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                BG_FLIPPED.render(this.posX + this.sizeX - 32, this.posY, 32, this.sizeY);
            }
            RenderUtils.applyColorWithMultipy(this.getSpaceBodyColor(this.spaceBody), multiply * 0.75f);
        } else if (this.intersectsWith(mouseX, mouseY)) {
            this.getBG(this.spaceBody).render(this.posX, this.posY, this.sizeX - 64, this.sizeY);
        } else {
            this.getBG(this.spaceBody).render(this.posX, this.posY, this.sizeX - 64, this.sizeY);
        }
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    protected ScaleTexture getBG(T spaceBody) {
        return BG;
    }

    float getMultiply(T spaceBody) {
        return 0.1f;
    }

    boolean isSelected(T spaceBody) {
        return this.groupList.isSelected(this);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        block10: {
            block9: {
                if (!this.isSelected(this.spaceBody)) break block9;
                float multiply = 1.0f;
                Color color = this.getSpaceBodyColor(this.spaceBody);
                this.drawElementName(this.spaceBody, color, multiply);
                int iconsX = 0;
                if (this.canTravelTo(this.spaceBody, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                    multiply = 0.5f;
                    if (this.intersectsWith(mouseX, mouseY) && mouseX > this.sizeX - 32 && mouseX < this.sizeX) {
                        multiply = 1.0f;
                    }
                    RenderUtils.applyColorWithMultipy(color, multiply);
                    ClientProxy.holoIcons.bindSheet();
                    ClientProxy.holoIcons.renderIcon(this.travelIcon, (double)(this.posX + this.sizeX - 32 + 6), (double)(this.posY + 5));
                    iconsX += 32;
                }
                if (this.canView(this.spaceBody, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                    multiply = 0.5f;
                    if (this.intersectsWith(mouseX, mouseY) && mouseX > this.sizeX - 64 && mouseX < this.sizeX - 32) {
                        multiply = 1.0f;
                    }
                    RenderUtils.applyColorWithMultipy(color, multiply);
                    ClientProxy.holoIcons.bindSheet();
                    ClientProxy.holoIcons.renderIcon(this.searchIcon, (double)(this.posX + this.sizeX - 64 + this.searchIcon.getOriginalWidth() / 2), (double)(this.posY + this.searchIcon.getOriginalHeight() / 2));
                    iconsX += 32;
                }
                multiply = 0.8f;
                Map<HoloIcon, Integer> icons = this.getIcons(this.spaceBody);
                if (icons == null) break block10;
                for (Map.Entry<HoloIcon, Integer> entry : icons.entrySet()) {
                    if (entry.getValue() == 0) continue;
                    GL11.glEnable((int)3042);
                    RenderUtils.applyColorWithMultipy(this.getSpaceBodyColor(this.spaceBody), multiply);
                    BG_CIRCLE.render(this.posX + 128 + iconsX, this.posY, 32, 32);
                    ClientProxy.holoIcons.renderIcon(entry.getKey(), (double)(this.posX + iconsX + 128 + 16 - entry.getKey().getOriginalWidth() / 2), (double)(this.posY + 16 - entry.getKey().getOriginalHeight() / 2));
                    if (entry.getValue() > 0) {
                        RenderUtils.drawString(String.valueOf(entry.getValue()), this.posX + iconsX + 128 + 16 + 3, this.posY + 16 + 3, Reference.COLOR_HOLO, 1.0f);
                    }
                    iconsX += 32;
                }
                break block10;
            }
            this.drawElementName(this.spaceBody, this.getSpaceBodyColor(this.spaceBody), 0.3f);
            int x = 0;
            Map<HoloIcon, Integer> icons = this.getIcons(this.spaceBody);
            if (icons != null) {
                for (Map.Entry<HoloIcon, Integer> entry : icons.entrySet()) {
                    if (entry.getValue() == 0) continue;
                    GL11.glEnable((int)3042);
                    RenderUtils.applyColorWithMultipy(this.getSpaceBodyColor(this.spaceBody), 0.3f);
                    BG_CIRCLE.render(this.posX + 128 + x, this.posY, 32, 32);
                    ClientProxy.holoIcons.renderIcon(entry.getKey(), (double)(this.posX + x + 128 + 16 - entry.getKey().getOriginalWidth() / 2), (double)(this.posY + 16 - entry.getKey().getOriginalHeight() / 2));
                    if (entry.getValue() > 0) {
                        RenderUtils.drawString(String.valueOf(entry.getValue()), this.posX + x + 128 + 16 + 3, this.posY + 16 + 3, this.getSpaceBodyColor(this.spaceBody), 0.6f);
                    }
                    x += 32;
                }
            }
        }
    }

    protected abstract void drawElementName(T var1, Color var2, float var3);

    protected abstract Map<HoloIcon, Integer> getIcons(T var1);

    @Override
    public void addTooltip(List<String> var1, int mouseX, int mouseY) {
        if (this.isSelected(this.spaceBody)) {
            if (this.canTravelTo(this.spaceBody, (EntityPlayer)Minecraft.func_71410_x().field_71439_g) && mouseX > this.sizeX - 32 && mouseX < this.sizeX) {
                var1.add("Travel To");
            } else if (this.canView(this.spaceBody, (EntityPlayer)Minecraft.func_71410_x().field_71439_g) && mouseX > this.sizeX - 64 && mouseX < this.sizeX - 32) {
                var1.add("Enter");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        if (this.isSelected(this.spaceBody)) {
            if (mouseX > this.sizeX - 32 && mouseX < this.sizeX) {
                if (!this.canTravelTo(this.spaceBody, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) return false;
                this.onTravelPress();
            } else if (mouseX > this.sizeX - 64 && mouseX < this.sizeX - 32 && this.canView(this.spaceBody, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                this.onViewPress();
            }
            this.playSound();
            return false;
        } else {
            if (mouseX >= this.sizeX - 64) return false;
            this.playSound();
            this.onSelectPress();
            return true;
        }
    }

    protected abstract boolean canTravelTo(T var1, EntityPlayer var2);

    protected abstract boolean canView(T var1, EntityPlayer var2);

    protected void playSound() {
        String sound = this.getSound();
        if (sound != null && !sound.isEmpty()) {
            MOGuiBase.playSound("mo:gui." + sound, this.getSoundVolume(), 0.9f + rand.nextFloat() * 0.2f);
        }
    }

    protected abstract void onViewPress();

    protected abstract void onTravelPress();

    protected abstract void onSelectPress();

    protected Color getSpaceBodyColor(T spaceBody) {
        return Reference.COLOR_HOLO;
    }

    public T getSpaceBody() {
        return this.spaceBody;
    }
}

