/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.guide;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class MOGuideEntry {
    private MOGuideEntry parent;
    private ItemStack[] stackIcons;
    public String name;
    @SideOnly(value=Side.CLIENT)
    private int guiPosX;
    @SideOnly(value=Side.CLIENT)
    private int guiPosY;
    private List<MOGuideEntry> children;
    private int id;
    private String group;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation styleLocation;

    public MOGuideEntry(String name, ItemStack ... stackIcons) {
        this.stackIcons = stackIcons;
        this.name = name;
        this.init();
    }

    public MOGuideEntry(int id, String name, ItemStack ... stackIcons) {
        this.stackIcons = stackIcons;
        this.name = name;
        this.id = id;
        this.init();
    }

    private void init() {
        this.children = new ArrayList<MOGuideEntry>();
    }

    public MOGuideEntry setStackIcons(ItemStack ... stackIcons) {
        this.stackIcons = stackIcons;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public MOGuideEntry setStackIcons(Item item) {
        ArrayList stacks = new ArrayList();
        item.func_150895_a(item, null, stacks);
        if (stacks.size() > 0) {
            this.stackIcons = new ItemStack[stacks.size()];
            this.stackIcons = stacks.toArray(this.stackIcons);
        } else {
            this.stackIcons = new ItemStack[]{new ItemStack(item)};
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public MOGuideEntry setStackIcons(Block block) {
        ArrayList stacks = new ArrayList();
        block.func_149666_a(Item.func_150898_a((Block)block), null, stacks);
        if (stacks.size() > 0) {
            this.stackIcons = new ItemStack[stacks.size()];
            this.stackIcons = stacks.toArray(this.stackIcons);
        } else {
            this.stackIcons = new ItemStack[]{new ItemStack(block)};
        }
        return this;
    }

    public String getDisplayName() {
        return MOStringHelper.translateToLocal(String.format("guide.entry.%s.name", this.name));
    }

    public MOGuideEntry setGuiPos(int x, int y) {
        this.guiPosX = x;
        this.guiPosY = y;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public int getGuiPosX() {
        return this.guiPosX;
    }

    @SideOnly(value=Side.CLIENT)
    public int getGuiPosY() {
        return this.guiPosY;
    }

    public MOGuideEntry setParent(MOGuideEntry parent) {
        this.parent = parent;
        return this;
    }

    public MOGuideEntry getParent() {
        return this.parent;
    }

    public void addChild(MOGuideEntry child) {
        child.setParent(this);
        this.children.add(child);
    }

    public ItemStack[] getStackIcons() {
        return this.stackIcons;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDescription() {
        String info;
        StringWriter writer = new StringWriter();
        try {
            InputStream stream = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(this.getDescriptionPath(Minecraft.func_71410_x().field_71474_y.field_74363_ab))).func_110527_b();
            info = IOUtils.toString((InputStream)stream, (String)"UTF-8");
            writer.close();
            stream.close();
        }
        catch (IOException e) {
            MOLog.warn("Language text %s for entry %s not found.", Minecraft.func_71410_x().field_71474_y.field_74363_ab, this.name);
            try {
                InputStream stream = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(this.getDescriptionPath("en_US"))).func_110527_b();
                info = IOUtils.toString((InputStream)stream, (String)"UTF-8");
                writer.close();
                stream.close();
            }
            catch (IOException e1) {
                info = "There is no default text entry for " + this.name;
            }
        }
        return info;
    }

    @SideOnly(value=Side.CLIENT)
    public InputStream getDescriptionStream() {
        InputStream stream = null;
        try {
            return Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(this.getDescriptionPath(Minecraft.func_71410_x().field_71474_y.field_74363_ab))).func_110527_b();
        }
        catch (IOException e) {
            MOLog.warn("Language text %s for entry %s not found.", Minecraft.func_71410_x().field_71474_y.field_74363_ab, this.name);
            try {
                return Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(this.getDescriptionPath("en_US"))).func_110527_b();
            }
            catch (IOException e1) {
                MOLog.warn("Default language entry for %s not found", this.name);
                return stream;
            }
        }
    }

    public String getDescriptionPath(String language) {
        return String.format("%s%s/%s.xml", "mo:info/", language, this.name);
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public MOGuideEntry setGroup(String group) {
        this.group = group;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void setStyleLocation(ResourceLocation location) {
        this.styleLocation = location;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getStyleLocation() {
        return this.styleLocation;
    }
}

