/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import cpw.mods.fml.client.config.IConfigElement;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import matteroverdrive.init.MatterOverdriveBlocks;
import matteroverdrive.util.IConfigSubscriber;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigurationHandler {
    private Set<IConfigSubscriber> subscribers;
    public Configuration config;
    public static final String CATEGORY_MATTER = "matter registry";
    public static final String CATEGORY_WORLD_GEN = "world gen";
    public static final String CATEGORY_MATTER_NETWORK = "matter network";
    public static final String CATEGORY_MACHINES = "machine options";
    public static final String CATEGORY_OVERRIDE_MATTER = "matter registry.item overrides";
    public static final String CATEGORY_NEW_ITEMS = "matter registry.new items";
    public static final String CATEGORY_WORLD_SPAWN_ORES = "spawn ores";
    public static final String CATEGORY_WORLD_SPAWN_OTHER = "spawn other";
    public static final String CATEGORY_WORLD_SPAWN = "spawn";
    public static final String CATEGORY_ABILITIES = "abilities";
    public static final String CATEGORY_CLIENT = "client";
    public static final String CATEGORY_ANDROID_HUD = "client.android_hud";
    public static final String CATEGORY_STARMAP = "starmap";
    public static final String CATEGORY_SERVER = "server";
    public static final String CATEGORY_ENCHANTMENTS = "enchantments";
    public static final String CATEGORY_ENTITIES = "entities";
    public static final String CATEGORY_ANDROID_PLAYER = "entities.android_player";
    public static final String CATEGORY_COMPATIBILITY = "compatibility";
    public static final String CATEGORY_DEBUG = "debug";
    public static final String KEY_AUTOMATIC_RECIPE_CALCULATION = "automatic matter calculation from recipe";
    public static final String KEY_AUTOMATIC_FURNACE_CALCULATION = "automatic matter calculation from furnace";
    public static final String KEY_MAX_BROADCASTS = "max broadcasts per tick";
    public static final String KEY_MBLACKLIST = "blacklist";
    public static final String KEY_BLACKLIST_MODS = "mod_blacklist";
    public static final String KEY_VERSION_CHECK = "version_check";
    public static final String KEY_GRAVITATIONAL_ANOMALY_FALLING_BLOCKS = "gravitational anomaly falling blocks";
    public static final String KEY_GRAVITATIONAL_ANOMALY_BLOCK_ENTITIES = "gravitational anomaly block entities";
    public static final String KEY_GRAVITATIONAL_ANOMALY_SPAWN_CHANCE = "gravitational anomaly spawn chance";
    public static final String KEY_GRAVITATIONAL_ANOMALY_VANILLA_FLUIDS = "gravitational anomaly vanilla fluids";
    public static final String KEY_GRAVITATIONAL_ANOMALY_FORGE_FLUIDS = "gravitational anomaly forge fluids";
    public static final String KEY_ANDROID_ENERGY_WATCH_ID = "android energy watch id";
    public static final String KEY_MATTER_REGISTRATION_DEBUG = "matter registation";
    public static final String KEY_MATTER_CALCULATION_DEBUG = "matter calculation";

    public ConfigurationHandler(File file) {
        this.config = new Configuration(file, "0.4.2");
        this.subscribers = new HashSet<IConfigSubscriber>();
    }

    public void init() {
        this.config.load();
        ConfigCategory category = this.config.getCategory(CATEGORY_MATTER);
        category.setComment("Configuration for the Matter ");
        this.updateCategoryLang(category);
        this.config.get((String)CATEGORY_MATTER, (String)KEY_MBLACKLIST, (String[])new String[0]).comment = "Blacklist for items in the matter registry. Automatic Recipe calculation will ignore recipes with these items. Just add the unlocalized name or the ore dictionary name in the list.";
        this.config.get((String)CATEGORY_MATTER, (String)KEY_BLACKLIST_MODS, (String[])new String[0]).comment = "Blacklist for mods (mod ID). Automatic Recipe calculation will ignore recipes with items from this mod";
        category = this.config.getCategory(CATEGORY_NEW_ITEMS);
        category.setComment("Registration of new items and the amount of matter they contain. Add them like so: I:[registered name or ore Dictionary name](meta)=[matter amount]. () - optional parameter. Example I:dye2=10 I:egg=29");
        this.updateCategoryLang(category);
        category = this.config.getCategory(CATEGORY_OVERRIDE_MATTER);
        category.setComment("Overriding of existing items and the amount of matter they contain. Add them like so: I:[registered name or ore Dictionary name](meta)=[matter amount] () - optional parameter. Example I:dye2=10 I:egg=29");
        this.updateCategoryLang(category);
        category = this.config.getCategory(CATEGORY_CLIENT);
        this.updateCategoryLang(category);
        category.setComment("Options for the Matter overdrive client");
        category = this.config.getCategory(CATEGORY_SERVER);
        this.updateCategoryLang(category);
        category.setComment("Options form the Matter Overdrive server");
        category = this.config.getCategory(CATEGORY_ENTITIES);
        this.updateCategoryLang(category);
        category.setComment("Options for Matter Overdrive Entities. Such as their Entity IDs.");
        category = this.config.getCategory(CATEGORY_DEBUG);
        this.updateCategoryLang(category);
        category.setComment("Debug Options. Such as Debug Log for Matter Recipe Calculation");
        category = this.config.getCategory(CATEGORY_ANDROID_HUD);
        this.updateCategoryLang(category);
        category.setComment("Positioning and colors of Android HUD elements");
        category = this.config.getCategory(CATEGORY_MACHINES);
        category.setComment("Machine Options.");
        this.updateCategoryLang(category);
        category = this.config.getCategory(CATEGORY_MATTER_NETWORK);
        category.setComment("Matter Network Options.");
        this.updateCategoryLang(category);
        category = this.config.getCategory(CATEGORY_WORLD_GEN);
        category.setComment("World Generation options.");
        this.updateCategoryLang(category);
        category = this.config.getCategory(CATEGORY_STARMAP);
        category.setComment("Star Map Galaxy Options");
        this.updateCategoryLang(category);
        category = this.config.getCategory(CATEGORY_ABILITIES);
        category.setComment("Android Player Abilities");
        this.updateCategoryLang(category);
        category = this.config.getCategory(CATEGORY_COMPATIBILITY);
        category.setComment("Option for other mods");
        this.updateCategoryLang(category);
        this.config.get(CATEGORY_WORLD_GEN, CATEGORY_WORLD_SPAWN_ORES, true, "Should ores such as dilithium and tritanium ore spawn in the world. This applies for all ores !").setLanguageKey("config." + CATEGORY_WORLD_SPAWN_ORES.replace(' ', '_') + ".name");
        this.config.get(CATEGORY_WORLD_GEN, "spawn." + MatterOverdriveBlocks.dilithium_ore.func_149739_a(), true).setLanguageKey(MatterOverdriveBlocks.dilithium_ore.func_149739_a() + ".name");
        this.config.get(CATEGORY_WORLD_GEN, "spawn." + MatterOverdriveBlocks.tritaniumOre.func_149739_a(), true).setLanguageKey(MatterOverdriveBlocks.tritaniumOre.func_149739_a() + ".name");
        this.config.getBoolean(KEY_AUTOMATIC_RECIPE_CALCULATION, CATEGORY_MATTER, true, "Shoud Matter be automaticly calculated from Recipes");
        this.save();
    }

    public void postInit() {
        this.config.load();
        for (IConfigSubscriber subscriber : this.subscribers) {
            subscriber.onConfigChanged(this);
        }
        this.save();
    }

    public void updateCategoryLang(ConfigCategory category) {
        category.setLanguageKey("config." + category.getName().replace(' ', '_') + ".name");
    }

    public boolean getBool(String key, String category, Boolean def, String comment) {
        return this.config.getBoolean(key, category, def.booleanValue(), comment);
    }

    public boolean getBool(String key, String category, Boolean def) {
        return this.config.getBoolean(key, category, def.booleanValue(), null);
    }

    public int getInt(String key, String category, Integer def, String comment) {
        Property property = this.config.get(category, key, def.intValue());
        property.comment = comment;
        return property.getInt(def.intValue());
    }

    public int getInt(String key, String category, Integer def) {
        return this.getInt(key, category, def, "");
    }

    public void setInt(String key, String category, Integer def) {
        this.config.get(category, key, def.intValue()).set(def.intValue());
    }

    public String[] getStringList(String category, String key) {
        return this.config.get(category, key, new String[0]).getStringList();
    }

    public ConfigCategory getCategory(String cat) {
        return this.config.getCategory(cat);
    }

    public double getMachineDouble(String machine, String prop, double def, double min, double max, String comment) {
        Property p = this.config.get("machine options." + machine.replaceFirst("tile.", ""), prop, def);
        p.comment = comment;
        p.setLanguageKey(machine + ".config." + prop);
        p.setMinValue(min);
        p.setMaxValue(max);
        return p.getDouble(def);
    }

    public double getMachineDouble(String machine, String prop, double def, String comment) {
        Property p = this.config.get("machine options." + machine.replaceFirst("tile.", ""), prop, def);
        p.comment = comment;
        p.setLanguageKey(machine + ".config." + prop);
        return p.getDouble(def);
    }

    public boolean getMachineBool(String machine, String prop, boolean def, String comment) {
        Property p = this.config.get("machine options." + machine.replaceFirst("tile.", ""), prop, def);
        p.comment = comment;
        p.setLanguageKey(machine + ".config." + prop);
        return p.getBoolean(def);
    }

    public int getMachineInt(String machine, String prop, int def, String comment) {
        Property p = this.config.get("machine options." + machine.replaceFirst("tile.", ""), prop, def);
        p.comment = comment;
        p.setLanguageKey(machine + ".config." + prop);
        return p.getInt(def);
    }

    public void initMachineCategory(String machine) {
        this.config.setCategoryLanguageKey("machine options." + machine.replaceFirst("tile.", ""), machine + ".name");
    }

    public void save() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public void subscribe(IConfigSubscriber subscriber) {
        if (!this.subscribers.contains(subscriber)) {
            this.subscribers.add(subscriber);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals("mo")) {
            this.config.save();
        }
        for (IConfigSubscriber subscriber : this.subscribers) {
            subscriber.onConfigChanged(this);
        }
    }

    public void addCategoryToGui(List<IConfigElement> list) {
        list.add((IConfigElement)new ConfigElement(this.getCategory(CATEGORY_CLIENT)));
        list.add((IConfigElement)new ConfigElement(this.getCategory(CATEGORY_SERVER)));
        list.add((IConfigElement)new ConfigElement(this.getCategory(CATEGORY_WORLD_GEN)));
        list.add((IConfigElement)new ConfigElement(this.getCategory(CATEGORY_MATTER_NETWORK)));
        list.add((IConfigElement)new ConfigElement(this.getCategory(CATEGORY_MACHINES)));
        list.add((IConfigElement)new ConfigElement(this.getCategory(CATEGORY_MATTER)));
        list.add((IConfigElement)new ConfigElement(this.getCategory(CATEGORY_STARMAP)));
        list.add((IConfigElement)new ConfigElement(this.getCategory(CATEGORY_ABILITIES)));
        list.add((IConfigElement)new ConfigElement(this.getCategory(CATEGORY_ENTITIES)));
        list.add((IConfigElement)new ConfigElement(this.getCategory(CATEGORY_DEBUG)));
    }
}

