/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import com.brsanthu.googleanalytics.EventHit;
import com.brsanthu.googleanalytics.GoogleAnalytics;
import com.brsanthu.googleanalytics.GoogleAnalyticsConfig;
import com.brsanthu.googleanalytics.GoogleAnalyticsRequest;
import com.brsanthu.googleanalytics.PageViewHit;
import com.brsanthu.googleanalytics.TimingHit;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.util.IConfigSubscriber;
import net.minecraft.entity.player.EntityPlayer;

public class GoogleAnalyticsCommon
implements IConfigSubscriber {
    private String lastScreen;
    private GoogleAnalyticsConfig config = new GoogleAnalyticsConfig();
    private static final String APP_ID = "UA-3322335-6";
    protected GoogleAnalytics googleAnalytics;
    public static final String EVENT_CATEGORY_BIOTIC_STATS = "Biotic Stats";
    public static final String EVENT_CATEGORY_MACHINES = "Machines";
    public static final String EVENT_CATEGORY_ENTITIES = "Entities";
    public static final String EVENT_CATEGORY_BLOCK_PLACEING = "Block Placing";
    public static final String TIMING_CATEGORY_MATTER_REGISTRY = "Matter Registry";
    public static final String EVENT_CATEGORY_ITEMS = "Items";
    public static final String EVENT_CATEGORY_QUESTS = "Quests";
    public static final String EVENT_ACTION_BIOTIC_STAT_UNLOCK = "Unlock";
    public static final String EVENT_ACTION_KILL = "Kill";
    public static final String EVENT_ACTION_REPLICATE = "Replicate";
    public static final String EVENT_ACTION_BIOTIC_STAT_USE = "Use";
    public static final String EVENT_ACTION_CRAFT_ITEMS = "Craft";
    public static final String EVENT_ACTION_PLAYER_DEATH = "Player Death";
    public static final String EVENT_ACTION_QUEST_COMPLETE = "Complete";
    public static final String EVENT_ACTION_QUEST_ABANDON = "Abandon";
    public static final String EVENT_ACTION_QUEST_ACCEPT = "Accept";
    public static final String TIMING_VAR_MATTER_REGISTRY_CALCULATION = "Calculation";
    public static final String TIMING_VAR_MATTER_REGISTRY_SAVING_TO_DISK = "Saving To Disk";
    public static final String PAGE_PATH_GUIDE_ENTIRES = "Guide Entries";

    public void sendEventHit(String category, String action, String label, Integer value, EntityPlayer entityPlayer) {
        if (this.googleAnalytics != null) {
            this.googleAnalytics.postAsync(this.changeUserID(new EventHit(category, action, label, value), entityPlayer));
        }
    }

    public void sendEventHit(String category, String action, String label, EntityPlayer entityPlayer) {
        if (this.googleAnalytics != null) {
            this.googleAnalytics.postAsync(this.changeUserID(new EventHit(category, action, label, null), entityPlayer));
        }
    }

    public void sendTimingHit(String category, String var, int time, EntityPlayer entityPlayer) {
        if (this.googleAnalytics != null) {
            this.googleAnalytics.postAsync(this.changeUserID(new TimingHit().userTimingCategory(category).userTimingVariableName(var).userTimingTime(time), entityPlayer));
        }
    }

    public void sendScreenHit(String screen, EntityPlayer entityPlayer) {
        if (this.googleAnalytics != null && this.lastScreen != screen) {
            this.googleAnalytics.postAsync(this.changeUserID((GoogleAnalyticsRequest)new GoogleAnalyticsRequest("screenview").contentDescription(screen), entityPlayer));
            this.lastScreen = screen;
        }
    }

    public void setPageHit(String pageTitle, String pagePath, EntityPlayer entityPlayer) {
        if (this.googleAnalytics != null) {
            this.googleAnalytics.postAsync(this.changeUserID((GoogleAnalyticsRequest)new PageViewHit(null, pageTitle).documentPath(pagePath), entityPlayer));
        }
    }

    public GoogleAnalyticsRequest changeUserID(GoogleAnalyticsRequest request, EntityPlayer entityPlayer) {
        if (entityPlayer != null) {
            request.userId(EntityPlayer.func_146094_a((GameProfile)entityPlayer.func_146103_bH()).toString());
        }
        return request;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        this.config.setEnabled(config.getBool("google_analytics", "server", true, "Enable Google Analytics Anonymous Statistics Gathering"));
    }

    public void unload() {
        if (this.googleAnalytics != null) {
            this.googleAnalytics.close();
            this.googleAnalytics = null;
        }
    }

    public void load() {
        if (this.config.isEnabled() && FMLCommonHandler.instance().getSide() != Side.SERVER) {
            this.googleAnalytics = new GoogleAnalytics(this.config, APP_ID, "Matter Overdrive", "0.4.2");
        }
    }
}

