/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import cpw.mods.fml.common.event.FMLServerStartedEvent;
import java.util.concurrent.Future;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.handler.thread.RegisterItemsFromRecipes;
import matteroverdrive.network.packet.client.PacketUpdateMatterRegistry;
import matteroverdrive.util.MOLog;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;

public class MatterRegistrationHandler {
    public final String registryPath;
    private Future matterCalculationThread;

    public MatterRegistrationHandler(String registryPath) {
        this.registryPath = registryPath;
    }

    public void serverStart(FMLServerStartedEvent event) {
        block8: {
            try {
                if (MatterOverdrive.matterRegistry.needsCalculation(this.registryPath) && MatterOverdrive.matterRegistry.AUTOMATIC_CALCULATION) {
                    try {
                        this.runCalculationThread();
                    }
                    catch (Exception e) {
                        MOLog.log(Level.ERROR, e, "There was a problem calculating Matter from Recipes or Furnaces", new Object[0]);
                    }
                    break block8;
                }
                try {
                    MatterOverdrive.matterRegistry.loadFromFile(this.registryPath);
                }
                catch (Exception e) {
                    MOLog.log(Level.ERROR, e, "There was a problem loading the Matter Registry file.", new Object[0]);
                    if (MatterOverdrive.matterRegistry.AUTOMATIC_CALCULATION) {
                        MOLog.log(Level.INFO, e, "Starting automatic matter calculation thread.", new Object[0]);
                        this.runCalculationThread();
                        break block8;
                    }
                    MOLog.log(Level.INFO, e, "Automatic matter calculation disabled. To enable go to Matter Overdrive configs", new Object[0]);
                }
            }
            catch (Exception e) {
                MOLog.log(Level.ERROR, e, "There was a problem while trying to load Matter Registry or trying to Calculate it", new Object[0]);
            }
        }
    }

    public void runCalculationThread() {
        if (this.matterCalculationThread != null) {
            MOLog.log(Level.INFO, "Old calculation thread is running. Stopping old calculation thread", new Object[0]);
            this.matterCalculationThread.cancel(true);
            this.matterCalculationThread = null;
        }
        this.matterCalculationThread = MatterOverdrive.threadPool.submit(new RegisterItemsFromRecipes(this.registryPath));
    }

    public void onRegistrationComplete() {
        PacketUpdateMatterRegistry updateMatterRegistry = new PacketUpdateMatterRegistry(MatterOverdrive.matterRegistry.getEntries());
        for (EntityPlayerMP playerMP : MinecraftServer.func_71276_C().func_130014_f_().field_73010_i) {
            MatterOverdrive.packetPipeline.sendTo(updateMatterRegistry, playerMP);
        }
    }
}

