/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler.weapon;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import java.util.Map;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.events.weapon.MOEventEnergyWeapon;
import matteroverdrive.entity.player.AndroidPlayer;
import matteroverdrive.network.packet.bi.PacketFirePlasmaShot;
import net.minecraft.entity.player.EntityPlayer;

public class CommonWeaponHandler {
    private static final PacketFirePlasmaShot.BiHandler firePlasmaShotHandler = new PacketFirePlasmaShot.BiHandler();
    Map<EntityPlayer, Long> weaponTimestamps = new HashMap<EntityPlayer, Long>();

    public void addTimestamp(EntityPlayer player, long timestamp) {
        this.weaponTimestamps.put(player, timestamp);
    }

    public boolean hasTimestamp(EntityPlayer player) {
        return this.weaponTimestamps.containsKey(player);
    }

    public long getTimestamp(EntityPlayer entityPlayer) {
        return this.weaponTimestamps.get(entityPlayer);
    }

    public void handlePlasmaShotFire(EntityPlayer entityPlayer, PacketFirePlasmaShot plasmaShot, long timeStamp) {
        int delay = (int)(timeStamp - this.getTimestamp(entityPlayer));
        firePlasmaShotHandler.handleServerShot(entityPlayer, plasmaShot, delay);
        MatterOverdrive.packetPipeline.sendToAllAround((IMessage)plasmaShot, entityPlayer, (double)(plasmaShot.getShot().getRange() + 64));
    }

    @SubscribeEvent
    public void onEnergyWeaponEvent(MOEventEnergyWeapon eventEnergyWeapon) {
        AndroidPlayer androidPlayer;
        if (eventEnergyWeapon.entityLiving != null && eventEnergyWeapon.entityLiving instanceof EntityPlayer && (androidPlayer = AndroidPlayer.get((EntityPlayer)eventEnergyWeapon.entityLiving)) != null) {
            androidPlayer.onWeaponEvent(eventEnergyWeapon);
        }
    }
}

