/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.init;

import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.entity.EntityFailedChicken;
import matteroverdrive.entity.EntityFailedCow;
import matteroverdrive.entity.EntityFailedPig;
import matteroverdrive.entity.EntityFailedSheep;
import matteroverdrive.entity.EntityVillagerMadScientist;
import matteroverdrive.entity.monster.EntityMeleeRougeAndroidMob;
import matteroverdrive.entity.monster.EntityMutantScientist;
import matteroverdrive.entity.monster.EntityRangedRogueAndroidMob;
import matteroverdrive.entity.monster.EntityRogueAndroid;
import matteroverdrive.entity.weapon.PlasmaBolt;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.handler.village.TradeHandlerMadScientist;
import matteroverdrive.handler.village.VillageCreatationMadScientist;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;

public class MatterOverdriveEntities {
    public static final int ENTITY_STARTING_ID = 171;
    public static EntityRogueAndroid rogueandroid;

    public static void init(FMLPreInitializationEvent event, ConfigurationHandler configurationHandler) {
        rogueandroid = new EntityRogueAndroid();
        configurationHandler.subscribe(rogueandroid);
    }

    public static void register(FMLPostInitializationEvent event) {
        MatterOverdrive.configHandler.config.load();
        MatterOverdriveEntities.addEntity(EntityFailedPig.class, "failed_pig", 15771042, 0x33CC33, 171);
        MatterOverdriveEntities.addEntity(EntityFailedCow.class, "failed_cow", 4470310, 0x33CC33, 172);
        MatterOverdriveEntities.addEntity(EntityFailedChicken.class, "failed_chicken", 0xA1A1A1, 0x33CC33, 173);
        MatterOverdriveEntities.addEntity(EntityFailedSheep.class, "failed_sheep", 0xE7E7E7, 0x33CC33, 174);
        MatterOverdriveEntities.addEntity(EntityVillagerMadScientist.class, "mad_scientist", 0xFFFFFF, 0, 175);
        MatterOverdriveEntities.addEntity(EntityMutantScientist.class, "mutant_scientist", 0xFFFFFF, 65280, 176);
        MatterOverdriveEntities.addEntity(EntityMeleeRougeAndroidMob.class, "rogue_android", 1048575, 0, 177);
        MatterOverdriveEntities.addEntity(EntityRangedRogueAndroidMob.class, "ranged_rogue_android", 1048575, 0, 178);
        VillagerRegistry.instance().registerVillageTradeHandler(666, (VillagerRegistry.IVillageTradeHandler)new TradeHandlerMadScientist());
        VillageCreatationMadScientist creatationMadScientist = new VillageCreatationMadScientist();
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)creatationMadScientist);
        EntityRogueAndroid.addAsBiomeGen(EntityMeleeRougeAndroidMob.class);
        EntityRogueAndroid.addAsBiomeGen(EntityRangedRogueAndroidMob.class);
        int phaserFireID = MatterOverdriveEntities.loadIDFromConfig(PlasmaBolt.class, "phaser_fire", 170);
        EntityRegistry.registerGlobalEntityID(PlasmaBolt.class, (String)"phaser_fire", (int)phaserFireID);
        MatterOverdrive.configHandler.save();
    }

    public static int addEntity(Class<? extends Entity> enityClass, String name, int mainColor, int spotsColor, int id) {
        id = MatterOverdriveEntities.loadIDFromConfig(enityClass, name, id);
        EntityRegistry.registerGlobalEntityID(enityClass, (String)name, (int)id);
        EntityRegistry.registerModEntity(enityClass, (String)name, (int)id, (Object)MatterOverdrive.instance, (int)64, (int)1, (boolean)true);
        MatterOverdriveEntities.createEgg(id, mainColor, spotsColor);
        return id;
    }

    public static void createEgg(int id, int solidColor, int spotColor) {
        EntityList.field_75627_a.put(id, new EntityList.EntityEggInfo(id, solidColor, spotColor));
    }

    public static int loadIDFromConfig(Class<? extends Entity> entityClass, String name, int id) {
        return MatterOverdrive.configHandler.getInt(MatterOverdriveEntities.getEntityConfigKey(name), "entities", id);
    }

    private static String getEntityConfigKey(String name) {
        return "entity." + name + ".id";
    }
}

