/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.init;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.events.MOEventTransport;
import matteroverdrive.api.events.anomaly.MOEventGravitationalAnomalyConsume;
import matteroverdrive.api.quest.IQuestLogic;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.GenericMultiQuest;
import matteroverdrive.data.quest.GenericQuest;
import matteroverdrive.data.quest.QuestItem;
import matteroverdrive.data.quest.RandomQuestText;
import matteroverdrive.data.quest.WeightedRandomQuest;
import matteroverdrive.data.quest.logic.QuestLogicBecomeAndroid;
import matteroverdrive.data.quest.logic.QuestLogicCocktailOfAscension;
import matteroverdrive.data.quest.logic.QuestLogicCollectItem;
import matteroverdrive.data.quest.logic.QuestLogicCraft;
import matteroverdrive.data.quest.logic.QuestLogicKillCreature;
import matteroverdrive.data.quest.logic.QuestLogicMine;
import matteroverdrive.data.quest.logic.QuestLogicPlaceBlock;
import matteroverdrive.data.quest.logic.QuestLogicScanBlock;
import matteroverdrive.data.quest.logic.QuestLogicSingleEvent;
import matteroverdrive.data.quest.rewards.ItemStackReward;
import matteroverdrive.data.quest.rewards.QuestStackReward;
import matteroverdrive.entity.monster.EntityRougeAndroidMob;
import matteroverdrive.entity.player.AndroidAttributes;
import matteroverdrive.handler.quest.Quests;
import matteroverdrive.init.MatterOverdriveBlocks;
import matteroverdrive.init.MatterOverdriveItems;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;

public class MatterOverdriveQuests {
    public static List<WeightedRandom.Item> contractGeneration = new ArrayList<WeightedRandom.Item>();
    public static RandomQuestText killAndroids;
    public static GenericQuest cocktailOfAscension;
    public static GenericQuest sacrifice;
    public static GenericQuest departmentOfAgriculture;
    public static GenericQuest weaponsOfWar;
    public static GenericQuest oneTrueLove;
    public static GenericQuest toThePowerOf;
    public static GenericQuest punyHumans;
    public static GenericQuest is_it_really_me;
    public static GenericQuest beast_belly;
    public static GenericQuest crashLanding;
    public static GenericQuest weMustKnow;
    public static GenericQuest gmo;

    public static void init(FMLInitializationEvent event) {
        MatterOverdriveQuests.initMatterOverdriveQuests();
        MatterOverdriveQuests.initModdedQuests();
    }

    private static void initMatterOverdriveQuests() {
        killAndroids = (RandomQuestText)new RandomQuestText(new QuestLogicKillCreature(EntityRougeAndroidMob.class, 12, 28, 40).setAutoComplete(true), "kill_androids", 1, 0).addQuestRewards(new ItemStackReward(MatterOverdriveItems.androidParts));
        cocktailOfAscension = (GenericQuest)new GenericQuest(new QuestLogicCocktailOfAscension(), "cocktail_of_ascension", 512).addQuestRewards(new ItemStackReward((Item)MatterOverdriveItems.androidPill, 1, 0), new ItemStackReward((Item)MatterOverdriveItems.androidPill, 1, 1), new ItemStackReward((Item)MatterOverdriveItems.androidPill, 1, 2));
        sacrifice = (GenericQuest)new GenericQuest(new QuestLogicKillCreature(new Class[]{EntityChicken.class, EntityCow.class, EntityCow.class}, 8, 15, 10).setOnlyChildren(true).setAutoComplete(true), "sacrifice", 0).addQuestRewards(new ItemStackReward(Items.field_151141_av), new ItemStackReward(Items.field_151057_cb));
        departmentOfAgriculture = (GenericQuest)new GenericQuest(new QuestLogicCollectItem(new Item[]{Items.field_151015_O, Items.field_151172_bF, Items.field_151174_bG}, 31, 63, 3), "department_of_agriculture", 0).addQuestRewards(new ItemStackReward(Items.field_151166_bC, 4), new ItemStackReward(Items.field_151012_L));
        weaponsOfWar = (GenericQuest)new GenericQuest(new QuestLogicCraft(new ItemStack(Blocks.field_150467_bQ), 1, 3, 60).setAutoComplete(true), "weapons_of_war", 0).addQuestRewards(new ItemStackReward((Item)MatterOverdriveItems.tritaniumSword), new ItemStackReward((Item)MatterOverdriveItems.tritaniumChestplate));
        oneTrueLove = (GenericQuest)new GenericQuest(new QuestLogicMine(Blocks.field_150482_ag, 1, 1, 180).setAutoComplete(true), "one_true_love", 0).addQuestRewards(new ItemStackReward(Items.field_151166_bC, 6));
        punyHumans = (GenericQuest)new GenericQuest(new QuestLogicBecomeAndroid(), "puny_humans", 256).addQuestRewards(new ItemStackReward(MatterOverdriveItems.battery), new ItemStackReward((Item)MatterOverdriveItems.androidPill, 1));
        is_it_really_me = (GenericQuest)new GenericQuest(new QuestLogicSingleEvent(MOEventTransport.class).setAutoComplete(true), "is_it_really_me", 120).addQuestRewards(new ItemStackReward(MatterOverdriveItems.item_upgrade, 2, 4));
        beast_belly = (GenericQuest)new GenericQuest(new QuestLogicSingleEvent(MOEventGravitationalAnomalyConsume.class), "beast_belly", 210).addQuestRewards(new ItemStackReward(MatterOverdriveBlocks.gravitational_stabilizer, 2));
        weMustKnow = (GenericQuest)new GenericQuest(new QuestLogicPlaceBlock(4, new ItemStack((Block)MatterOverdriveBlocks.decorative_coils).func_151001_c("Communication Relay"), 1, 1).setAutoComplete(true), "we_must_know", 120).addQuestRewards(new ItemStackReward(Items.field_151166_bC, 8));
        crashLanding = (GenericQuest)new GenericQuest(new QuestLogicCraft(new ItemStack((Item)MatterOverdriveItems.security_protocol), 0, 0, 0).setAutoComplete(true), "crash_landing", 60).addQuestRewards(new ItemStackReward(new ItemStack((Block)MatterOverdriveBlocks.decorative_coils).func_151001_c("Communication Relay")), new QuestStackReward(new QuestStack(weMustKnow)).setCopyNBT("Pos"));
        gmo = (GenericQuest)new GenericMultiQuest(new IQuestLogic[]{new QuestLogicScanBlock(Blocks.field_150459_bM, -1, 12, 24, 10).setOnlyDestoryable(true), new QuestLogicScanBlock(Blocks.field_150469_bN, -1, 12, 24, 10).setOnlyDestoryable(true)}, "gmo", 0).setAutoComplete(true).setSequential(true).addQuestRewards(new ItemStackReward(MatterOverdrive.androidPartsFactory.addAttributeToPart(MatterOverdrive.androidPartsFactory.addAttributeToPart(new ItemStack((Item)MatterOverdriveItems.tritaniumSpine), new AttributeModifier(SharedMonsterAttributes.field_111267_a.func_111108_a(), 5.0, 0)), new AttributeModifier(AndroidAttributes.attributeGlitchTime.func_111108_a(), -1.0, 2)).func_151001_c("Hardened Tritanium Spine")));
    }

    private static void initModdedQuests() {
        toThePowerOf = (GenericQuest)new GenericQuest(new QuestLogicCraft(new QuestItem[]{new QuestItem("BigReactors:BRReactorPart", "BigReactors"), new QuestItem("ExtraUtilities:generator", "ExtraUtilities", 1, 1), new QuestItem(new ItemStack((Item)MatterOverdriveItems.battery))}, 0, 0, 120).setRandomItem(false).setAutoComplete(true), "to_the_power_of", 0).addQuestRewards(new ItemStackReward(MatterOverdriveItems.tritanium_ingot, 10), new ItemStackReward(MatterOverdriveItems.tritanium_plate, 4));
    }

    public static void register(FMLInitializationEvent event, Quests quests) {
        MatterOverdriveQuests.registerMatterOverdriveQuests(quests);
        MatterOverdriveQuests.registerModdedQuests(quests);
    }

    private static void registerMatterOverdriveQuests(Quests quests) {
        quests.registerQuest("kill_androids", killAndroids);
        quests.registerQuest("cocktail_of_ascension", cocktailOfAscension);
        quests.registerQuest("sacrifice", sacrifice);
        quests.registerQuest("department_of_agriculture", departmentOfAgriculture);
        quests.registerQuest("weapons_of_war", weaponsOfWar);
        quests.registerQuest("one_true_love", oneTrueLove);
        quests.registerQuest("puny_humans", punyHumans);
        quests.registerQuest("is_it_really_me", is_it_really_me);
        quests.registerQuest("beast_belly", beast_belly);
        quests.registerQuest("crash_landing", crashLanding);
        quests.registerQuest("weMustKnow", weMustKnow);
        quests.registerQuest("gmo", gmo);
        contractGeneration.add(new WeightedRandomQuest(killAndroids, 100));
        contractGeneration.add(new WeightedRandomQuest(sacrifice, 100));
        contractGeneration.add(new WeightedRandomQuest(departmentOfAgriculture, 100));
        contractGeneration.add(new WeightedRandomQuest(weaponsOfWar, 80));
        contractGeneration.add(new WeightedRandomQuest(oneTrueLove, 100));
        contractGeneration.add(new WeightedRandomQuest(is_it_really_me, 80));
        contractGeneration.add(new WeightedRandomQuest(beast_belly, 60));
    }

    private static void registerModdedQuests(Quests quests) {
        quests.registerQuest("to_the_power_of", toThePowerOf);
    }
}

