/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import com.mojang.realmsclient.gui.ChatFormatting;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import matteroverdrive.api.IScannable;
import matteroverdrive.api.events.MOEventScan;
import matteroverdrive.api.inventory.IBlockScanner;
import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.client.sound.MachineSound;
import matteroverdrive.data.BlockPos;
import matteroverdrive.data.ItemPattern;
import matteroverdrive.gui.GuiMatterScanner;
import matteroverdrive.handler.SoundHandler;
import matteroverdrive.items.includes.MOBaseItem;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MOPhysicsHelper;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Keyboard;

public class MatterScanner
extends MOBaseItem
implements IBlockScanner {
    public static final String SELECTED_TAG_NAME = "lastSelected";
    public static final String PAGE_TAG_NAME = "page";
    public static final String PANEL_OPEN_TAG_NAME = "panelOpen";
    public static final int PROGRESS_PER_ITEM = 10;
    public static final int SCAN_TIME = 60;
    @SideOnly(value=Side.CLIENT)
    public static MachineSound scanningSound;
    public static IIcon offline_icon;

    public MatterScanner(String name) {
        super(name);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack itemStack) {
        if (itemStack.func_77942_o() && Minecraft.func_71410_x().field_71441_e != null && MatterScanner.isLinked(itemStack)) {
            return this.field_77791_bV;
        }
        return offline_icon;
    }

    @Override
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List infos, boolean p_77624_4_) {
        if (this.hasDetails(itemstack)) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                this.addDetails(itemstack, player, infos);
            } else {
                infos.add(MOStringHelper.MORE_INFO);
                infos.add("Press '" + EnumChatFormatting.YELLOW + GameSettings.func_74298_c((int)ClientProxy.keyHandler.getBinding(0).func_151463_i()) + EnumChatFormatting.GRAY + "' to open GUI");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A());
        offline_icon = iconRegister.func_94245_a("mo:matter_scanner_offline");
    }

    @Override
    public void addDetails(ItemStack itemstack, EntityPlayer player, List infos) {
        if (MatterScanner.isLinked(itemstack)) {
            ItemPattern lastSelected;
            if (itemstack.func_77942_o()) {
                infos.add(ChatFormatting.GREEN + "Online");
            }
            if ((lastSelected = MatterScanner.getSelectedAsPattern(itemstack)) != null) {
                infos.add("Progress: " + lastSelected.getProgress() + " / " + 100 + " %");
                infos.add("Selected: " + lastSelected.getDisplayName());
            }
        } else {
            infos.add(ChatFormatting.RED + "Offline");
        }
    }

    @Override
    public boolean hasDetails(ItemStack itemStack) {
        return true;
    }

    public static IMatterDatabase getLink(World world, ItemStack scanner) {
        int z;
        int y;
        int x;
        TileEntity e;
        if (scanner != null && scanner.func_77973_b() instanceof MatterScanner && scanner.func_77942_o() && scanner.func_77978_p().func_74767_n("isLinked") && (e = world.func_147438_o(x = scanner.func_77978_p().func_74762_e("link_x"), y = scanner.func_77978_p().func_74762_e("link_y"), z = scanner.func_77978_p().func_74762_e("link_z"))) instanceof IMatterDatabase) {
            return (IMatterDatabase)e;
        }
        return null;
    }

    public static BlockPos getLinkPosition(ItemStack scanner) {
        if (scanner != null && scanner.func_77973_b() instanceof MatterScanner && scanner.func_77942_o()) {
            return new BlockPos(scanner.func_77978_p().func_74762_e("link_x"), scanner.func_77978_p().func_74762_e("link_y"), scanner.func_77978_p().func_74762_e("link_z"));
        }
        return new BlockPos(0, 0, 0);
    }

    public static boolean isLinked(ItemStack scanner) {
        if (scanner != null && scanner.func_77973_b() instanceof MatterScanner && scanner.func_77942_o()) {
            return scanner.func_77978_p().func_74767_n("isLinked");
        }
        return false;
    }

    public static void unLink(World world, ItemStack scanner) {
        if (scanner.func_77942_o()) {
            scanner.func_77978_p().func_74757_a("isLinked", false);
        }
    }

    public static void link(World world, int xCoord, int yCoord, int zCoord, ItemStack scanner) {
        if (scanner.func_77973_b() instanceof MatterScanner) {
            ((MatterScanner)scanner.func_77973_b()).TagCompountCheck(scanner);
        }
        if (scanner.func_77942_o()) {
            scanner.func_77978_p().func_74757_a("isLinked", true);
            scanner.func_77978_p().func_74768_a("link_x", xCoord);
            scanner.func_77978_p().func_74768_a("link_y", yCoord);
            scanner.func_77978_p().func_74768_a("link_z", zCoord);
        }
    }

    public int getItemStackLimit(ItemStack item) {
        return 1;
    }

    private void resetScanProgress(ItemStack item) {
        if (item.func_77942_o()) {
            item.func_77978_p().func_74768_a("scan_progress", 0);
        }
    }

    private boolean HarvestBlock(ItemStack scanner, EntityPlayer player, World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            ItemStack item = MatterDatabaseHelper.GetItemStackFromWorld(world, x, y, z);
            return world.func_147480_a(x, y, z, false);
        }
        return false;
    }

    public static void setSelected(World world, ItemStack scanner, ItemStack itemStack) {
        if (scanner.func_77942_o()) {
            ItemPattern itemPattern = MatterScanner.getSelectedFromDatabase(world, scanner, itemStack);
            if (itemPattern == null) {
                itemPattern = new ItemPattern(itemStack);
            }
            MatterScanner.setSelected(scanner, itemPattern);
        }
    }

    public static void setSelected(ItemStack scanner, ItemPattern itemPattern) {
        if (scanner.func_77942_o()) {
            NBTTagCompound seletedNBT = new NBTTagCompound();
            itemPattern.writeToNBT(seletedNBT);
            scanner.func_77978_p().func_74782_a(SELECTED_TAG_NAME, (NBTBase)seletedNBT);
        }
    }

    public static ItemPattern getSelectedAsPattern(ItemStack scanner) {
        if (scanner.func_77942_o() && scanner.func_77978_p().func_74764_b(SELECTED_TAG_NAME)) {
            return new ItemPattern(scanner.func_77978_p().func_74775_l(SELECTED_TAG_NAME));
        }
        return null;
    }

    public static ItemStack getSelectedAsItem(ItemStack scanner) {
        if (scanner.func_77942_o()) {
            return ItemStack.func_77949_a((NBTTagCompound)scanner.func_77978_p().func_74775_l(SELECTED_TAG_NAME));
        }
        return null;
    }

    public static ItemPattern getSelectedFromDatabase(World world, ItemStack scanner, ItemStack forItem) {
        IMatterDatabase database = MatterScanner.getLink(world, scanner);
        if (database != null) {
            return database.getPattern(forItem);
        }
        return null;
    }

    @Override
    public void InitTagCompount(ItemStack stack) {
        MatterDatabaseHelper.initTagCompound(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public static void DisplayGuiScreen() {
        try {
            if (MatterHelper.isMatterScanner(Minecraft.func_71410_x().field_71439_g.func_70694_bm())) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMatterScanner(Minecraft.func_71410_x().field_71439_g.func_70694_bm(), Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c));
                return;
            }
            for (int i = 0; i < Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70302_i_(); ++i) {
                if (!MatterHelper.isMatterScanner(Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70301_a(i))) continue;
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMatterScanner(Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70301_a(i), i));
                return;
            }
        }
        catch (Exception e) {
            MOLog.log(Level.ERROR, e, "There was a problem while trying to open Matter Scanner GUI", new Object[0]);
        }
    }

    public static int getLastPage(ItemStack scanner) {
        if (scanner.func_77942_o()) {
            return scanner.func_77978_p().func_74765_d(PAGE_TAG_NAME);
        }
        return 0;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack scanner) {
        ItemStack selected = MatterScanner.getSelectedAsItem(scanner);
        if (selected != null && MatterHelper.CanScan(selected)) {
            return 60 + MatterHelper.getMatterAmountFromItem(selected);
        }
        return Integer.MAX_VALUE;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        MovingObjectPosition hit = this.getScanningPos(itemstack, entityplayer);
        if (hit != null && hit.field_72313_a != MovingObjectPosition.MovingObjectType.MISS) {
            if (world.field_72995_K) {
                this.playSound(entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v);
            }
            entityplayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
        }
        return itemstack;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        EntityPlayer player;
        super.func_77663_a(itemStack, world, entity, p_77663_4_, p_77663_5_);
        if (world.field_72995_K && entity instanceof EntityPlayer && !(player = (EntityPlayer)entity).func_71039_bw()) {
            this.stopScanSounds();
        }
    }

    public ItemStack func_77654_b(ItemStack scanner, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            this.stopScanSounds();
            return scanner;
        }
        MovingObjectPosition position = this.getScanningPos(scanner, player);
        if (position != null && position.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && !world.field_72995_K) {
            int x = position.field_72311_b;
            int y = position.field_72312_c;
            int z = position.field_72309_d;
            ItemStack worldItem = MatterDatabaseHelper.GetItemStackFromWorld(world, x, y, z);
            if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventScan(player, scanner, position))) {
                this.Scan(world, scanner, player, worldItem, x, y, z);
            }
        }
        return scanner;
    }

    @Override
    public MovingObjectPosition getScanningPos(ItemStack itemStack, EntityPlayer player) {
        return MOPhysicsHelper.rayTrace((EntityLivingBase)player, player.field_70170_p, 5.0, 0.0f, Vec3.func_72443_a((double)0.0, (double)(player.field_70170_p.field_72995_K ? 0.0 : (double)player.func_70047_e()), (double)0.0), true, false);
    }

    @Override
    public boolean destroysBlocks(ItemStack itemStack) {
        return true;
    }

    public void onUsingTick(ItemStack scanner, EntityPlayer player, int count) {
        MovingObjectPosition hit = this.getScanningPos(scanner, player);
        if (hit != null) {
            if (hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                ItemStack worldItem;
                int x = hit.field_72311_b;
                int y = hit.field_72312_c;
                int z = hit.field_72309_d;
                ItemStack lastSelected = MatterScanner.getSelectedAsItem(scanner);
                if (!MatterDatabaseHelper.areEqual(lastSelected, worldItem = MatterDatabaseHelper.GetItemStackFromWorld(player.field_70170_p, x, y, z))) {
                    MatterScanner.setSelected(player.field_70170_p, scanner, worldItem);
                    player.func_71034_by();
                    if (player.field_70170_p.field_72995_K) {
                        this.stopScanSounds();
                    }
                }
            }
        } else if (player.field_70170_p.field_72995_K) {
            this.stopScanSounds();
            player.func_71034_by();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playSound(double x, double y, double z) {
        if (scanningSound == null) {
            scanningSound = new MachineSound(new ResourceLocation("mo:scanner_scanning"), (float)x, (float)y, (float)z, 0.6f, 1.0f);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)scanningSound);
        }
    }

    public void func_77615_a(ItemStack scanner, World world, EntityPlayer player, int count) {
        if (world.field_72995_K) {
            this.stopScanSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopScanSounds() {
        if (scanningSound != null) {
            scanningSound.stopPlaying();
            scanningSound = null;
        }
    }

    public boolean Scan(World world, ItemStack scanner, EntityPlayer player, ItemStack worldBlock, int x, int y, int z) {
        this.TagCompountCheck(scanner);
        StringBuilder scanInfo = new StringBuilder();
        IMatterDatabase database = MatterScanner.getLink(world, scanner);
        if (database != null && MatterHelper.CanScan(worldBlock)) {
            this.resetScanProgress(scanner);
            scanInfo.append(EnumChatFormatting.YELLOW + "[" + scanner.func_82833_r() + "] ");
            if (database.addItem(worldBlock, 10, false, scanInfo)) {
                SoundHandler.PlaySoundAt(world, "scanner_success", (Entity)player);
                this.DisplayInfo(player, scanInfo, EnumChatFormatting.GREEN);
                return this.HarvestBlock(scanner, player, world, x, y, z);
            }
            this.DisplayInfo(player, scanInfo, EnumChatFormatting.RED);
            SoundHandler.PlaySoundAt(world, "scanner_fail", (Entity)player);
            return false;
        }
        if (world.func_147439_a(x, y, z) instanceof IScannable) {
            ((IScannable)world.func_147439_a(x, y, z)).onScan(world, x, y, z, player, scanner);
            return true;
        }
        if (world.func_147438_o(x, y, z) instanceof IScannable) {
            ((IScannable)world.func_147439_a(x, y, z)).onScan(world, x, y, z, player, scanner);
            return true;
        }
        return false;
    }

    private void DisplayInfo(EntityPlayer player, StringBuilder scanInfo, EnumChatFormatting formatting) {
        if (player != null && !scanInfo.toString().isEmpty()) {
            player.func_145747_a((IChatComponent)new ChatComponentText(formatting + scanInfo.toString()));
        }
    }
}

