/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.starmap;

import java.util.List;
import matteroverdrive.api.starmap.BuildingType;
import matteroverdrive.api.starmap.IPlanetStatChange;
import matteroverdrive.api.starmap.PlanetStatType;
import matteroverdrive.items.starmap.ItemBuildingAbstract;
import matteroverdrive.starmap.data.Planet;
import net.minecraft.item.ItemStack;

public class ItemBuildingResidential
extends ItemBuildingAbstract
implements IPlanetStatChange {
    private static final int POPULATION_COUNT = 10000;
    private static final int ENERGY_DRAIN = 4;
    private static final int MATTER_DRAIN = 2;
    private static final int BUILDING_SIZE_INCREASE = 4;

    public ItemBuildingResidential(String name) {
        super(name);
    }

    @Override
    public BuildingType getType(ItemStack building) {
        return BuildingType.RESIDENTIAL;
    }

    @Override
    protected int getBuildLengthUnscaled(ItemStack buildableStack, Planet planet) {
        return 6000;
    }

    @Override
    public boolean canBuild(ItemStack building, Planet planet, List<String> info) {
        return true;
    }

    @Override
    public float changeStat(ItemStack stack, Planet planet, PlanetStatType statType, float original) {
        switch (statType) {
            case POPULATION_COUNT: {
                return original + 10000.0f;
            }
            case ENERGY_PRODUCTION: {
                return original - 4.0f;
            }
            case MATTER_PRODUCTION: {
                return original - 2.0f;
            }
            case BUILDINGS_SIZE: {
                return original + 4.0f;
            }
            case HAPPINESS: {
                return original + this.calculateHappiness(stack, planet);
            }
        }
        return original;
    }

    public float calculateHappiness(ItemStack stack, Planet planet) {
        float happiness = 0.0f;
        happiness += planet.getPowerProducation() >= 0 ? 0.5f : -0.4f;
        float matterProdruction = planet.getMatterProduction();
        return happiness += matterProdruction >= 0.0f ? 0.5f : -0.6f;
    }
}

