/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.starmap;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import matteroverdrive.api.starmap.BuildingType;
import matteroverdrive.api.starmap.IBuilding;
import matteroverdrive.api.starmap.ShipType;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.items.starmap.ItemShipAbstract;
import matteroverdrive.starmap.data.Planet;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemColonizerShip
extends ItemShipAbstract {
    public ItemColonizerShip(String name) {
        super(name);
    }

    @Override
    public ShipType getType(ItemStack ship) {
        return ShipType.COLONIZER;
    }

    @Override
    public void onTravel(ItemStack shipStack, Planet to) {
        UUID owner = this.getOwnerID(shipStack);
        if (owner != null) {
            ItemStack base = new ItemStack((Item)MatterOverdriveItems.buildingBase);
            MatterOverdriveItems.buildingBase.setOwner(base, owner);
            if (to.canBuild((IBuilding)base.func_77973_b(), base, new ArrayList<String>())) {
                shipStack.field_77994_a = 0;
                to.addBuilding(base);
                to.setOwnerUUID(owner);
            }
        }
    }

    @Override
    public boolean canBuild(ItemStack building, Planet planet, List<String> info) {
        return !planet.hasBuildingType(BuildingType.BASE);
    }

    @Override
    public int getBuildLengthUnscaled(ItemStack building, Planet planet) {
        return 5000;
    }
}

