/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.analyzer.components;

import cpw.mods.fml.common.gameevent.TickEvent;
import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.api.network.IMatterNetworkDispatcher;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.data.ItemPattern;
import matteroverdrive.machines.analyzer.TileEntityMachineMatterAnalyzer;
import matteroverdrive.matter_network.MatterNetworkPacket;
import matteroverdrive.matter_network.components.MatterNetworkComponentClientDispatcher;
import matteroverdrive.matter_network.packets.MatterNetworkRequestPacket;
import matteroverdrive.matter_network.packets.MatterNetworkResponsePacket;
import matteroverdrive.matter_network.tasks.MatterNetworkTaskStorePattern;
import matteroverdrive.util.MatterNetworkHelper;
import matteroverdrive.util.TimeTracker;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MatterNetworkComponentAnalyzer
extends MatterNetworkComponentClientDispatcher<MatterNetworkTaskStorePattern, TileEntityMachineMatterAnalyzer> {
    private IMatterNetworkConnection connection;
    private boolean badLocation;
    private TimeTracker broadcastTracker = new TimeTracker();
    private TimeTracker validDestinationTracker = new TimeTracker();

    public MatterNetworkComponentAnalyzer(TileEntityMachineMatterAnalyzer analyzer) {
        super(analyzer, TickEvent.Phase.START);
        this.handlers.add(BASIC_CONNECTIONS_HANDLER);
    }

    @Override
    protected void executePacket(MatterNetworkPacket packet) {
        if (packet instanceof MatterNetworkResponsePacket) {
            this.executeResponses((MatterNetworkResponsePacket)packet);
        }
    }

    protected void executeResponses(MatterNetworkResponsePacket packet) {
        if (packet.fits(0, 3)) {
            this.badLocation = true;
            this.connection = null;
        } else if (packet.fits(1, 3) && !this.badLocation && this.isConnectionBetter(this.connection, packet)) {
            this.connection = packet.getSender(((TileEntityMachineMatterAnalyzer)this.rootClient).func_145831_w());
        }
    }

    @Override
    public int manageTopQueue(World world, int queueID, MatterNetworkTaskStorePattern task) {
        int broadcastCount = 0;
        if (task.getState() == MatterNetworkTaskState.FINISHED) {
            this.onTaskComplete((MatterNetworkTask)((TileEntityMachineMatterAnalyzer)this.rootClient).getTaskQueue(0).dequeue());
        } else if (this.canBroadcastTask(world, task)) {
            for (int i = 0; i < 6; ++i) {
                if (!MatterNetworkHelper.broadcastPacketInDirection(world, (byte)0, task, (IMatterNetworkDispatcher)((Object)this.rootClient), ForgeDirection.getOrientation((int)i), this.connection != null ? MatterNetworkHelper.getFilterFromPositions(this.connection.getPosition()) : null)) continue;
                this.onTaskBroadcast(world, task, ForgeDirection.getOrientation((int)i));
                ++broadcastCount;
            }
        }
        ((TileEntityMachineMatterAnalyzer)this.rootClient).getTaskQueue(queueID).tickAllAlive(world, false);
        return broadcastCount;
    }

    @Override
    public int onNetworkTick(World world, TickEvent.Phase phase) {
        int broadcasts = super.onNetworkTick(world, phase);
        if (phase.equals((Object)TickEvent.Phase.START)) {
            broadcasts += this.manageValidDestinationCheck(world);
        }
        return broadcasts;
    }

    private boolean isConnectionBetter(IMatterNetworkConnection one, MatterNetworkResponsePacket two) {
        if (one == null && two != null) {
            return true;
        }
        if (one == null && two == null) {
            return false;
        }
        if (!(two.getSender(((TileEntityMachineMatterAnalyzer)this.rootClient).func_145831_w()) instanceof IMatterDatabase)) {
            return false;
        }
        ItemPattern packetPattern = new ItemPattern(two.getResponse());
        ItemStack packetPatternStack = packetPattern.toItemStack(false);
        if (packetPattern != null && packetPatternStack != null) {
            if (one instanceof IMatterDatabase) {
                int twoProgress;
                int oneProgress;
                ItemPattern patternOne = ((IMatterDatabase)((Object)one)).getPattern(packetPatternStack);
                if (patternOne != null && (oneProgress = patternOne.getProgress()) < (twoProgress = packetPattern.getProgress())) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private int manageValidDestinationCheck(World world) {
        int broadcastCount = 0;
        if ((((TileEntityMachineMatterAnalyzer)this.rootClient).isActive() || this.getTaskQueue(0).size() > 0 && this.connection == null) && this.validDestinationTracker.hasDelayPassed(world, 200)) {
            for (int i = 0; i < 6; ++i) {
                MatterNetworkRequestPacket packet = new MatterNetworkRequestPacket((IMatterNetworkConnection)((Object)this.rootClient), 3, ForgeDirection.getOrientation((int)i), ((TileEntityMachineMatterAnalyzer)this.rootClient).getFilter(), new ItemPattern(((TileEntityMachineMatterAnalyzer)this.rootClient).getInventory().func_70301_a(((TileEntityMachineMatterAnalyzer)this.rootClient).input_slot)));
                if (!MatterNetworkHelper.broadcastPacketInDirection(world, packet, (IMatterNetworkConnection)((Object)this.rootClient), ForgeDirection.getOrientation((int)i))) continue;
                this.resetValidLocation();
                ++broadcastCount;
            }
        }
        return broadcastCount;
    }

    public void resetValidLocation() {
        this.connection = null;
        this.badLocation = false;
    }

    private boolean canBroadcastTask(World world, MatterNetworkTask task) {
        return !task.isAlive() && this.broadcastTracker.hasDelayPassed(world, task.getState() == MatterNetworkTaskState.WAITING ? 2 : 60);
    }

    private void onTaskComplete(MatterNetworkTask task) {
        ((TileEntityMachineMatterAnalyzer)this.rootClient).forceSync();
    }

    private void onTaskBroadcast(World world, MatterNetworkTask task, ForgeDirection direction) {
        task.setState(MatterNetworkTaskState.WAITING);
    }

    public IMatterNetworkConnection getConnection() {
        return this.connection;
    }
}

