/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.transporter;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.SimpleComponent;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.events.MOEventTransport;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.transport.ITransportList;
import matteroverdrive.api.transport.TransportLocation;
import matteroverdrive.compat.modules.waila.IWailaBodyProvider;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.TeleportFlashDriveSlot;
import matteroverdrive.fx.ReplicatorParticle;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.transporter.components.ComponentComputers;
import matteroverdrive.network.packet.client.PacketSyncTransportProgress;
import matteroverdrive.tile.MOTileEntityMachineMatter;
import matteroverdrive.util.math.MOMathHelper;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.util.vector.Vector3f;

@Optional.InterfaceList(value={@Optional.Interface(modid="ComputerCraft", iface="dan200.computercraft.api.peripheral.IPeripheral"), @Optional.Interface(modid="OpenComputers", iface="li.cil.oc.api.network.SimpleComponent"), @Optional.Interface(modid="OpenComputers", iface="li.cil.oc.api.network.ManagedPeripheral")})
public class TileEntityMachineTransporter
extends MOTileEntityMachineMatter
implements ITransportList,
IWailaBodyProvider,
IPeripheral,
SimpleComponent,
ManagedPeripheral {
    public static final int MAX_ENTETIES_PRE_TRANSPORT = 3;
    public static final int TRANSPORT_TIME = 70;
    public static final int TRANSPORT_DELAY = 80;
    private static final int TRANSPORT_RANGE = 32;
    public static final int ENERGY_STORAGE = 1024000;
    public static final int MAX_ENERGY_EXTRACT = 32000;
    public static final int ENERGY_PER_UNIT = 16;
    public List<TransportLocation> locations;
    public int selectedLocation;
    public int usbSlotID;
    int transportTimer;
    long transportTracker;
    private ComponentComputers computerComponent;

    public TileEntityMachineTransporter() {
        super(5);
        this.energyStorage.setCapacity(1024000);
        this.energyStorage.setMaxExtract(32000);
        this.matterStorage.setCapacity(512);
        this.locations = new ArrayList<TransportLocation>();
        this.selectedLocation = 0;
        this.playerSlotsHotbar = true;
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        super.RegisterSlots(inventory);
        this.usbSlotID = inventory.AddSlot(new TeleportFlashDriveSlot(true));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeCustomNBT(nbt, categories, toDisk);
        if (categories.contains((Object)MachineNBTCategory.CONFIGS)) {
            this.writeLocations(nbt);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.CONFIGS)) {
            this.readLocations(nbt);
        }
    }

    @Override
    protected void onAwake(Side side) {
    }

    public void readLocations(NBTTagCompound nbt) {
        this.locations.clear();
        NBTTagList locationsList = nbt.func_150295_c("transportLocations", 10);
        for (int i = 0; i < locationsList.func_74745_c(); ++i) {
            this.locations.add(new TransportLocation(locationsList.func_150305_b(i)));
        }
        this.selectedLocation = nbt.func_74762_e("selectedTransport");
    }

    public void writeLocations(NBTTagCompound nbt) {
        NBTTagList locationsList = new NBTTagList();
        for (TransportLocation location : this.locations) {
            NBTTagCompound positionTag = new NBTTagCompound();
            location.writeToNBT(positionTag);
            locationsList.func_74742_a((NBTBase)positionTag);
        }
        nbt.func_74782_a("transportLocations", (NBTBase)locationsList);
        nbt.func_74768_a("selectedTransport", this.selectedLocation);
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
        super.writeToDropItem(itemStack);
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        this.writeLocations(itemStack.func_77978_p());
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
        super.readFromPlaceItem(itemStack);
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        this.readLocations(itemStack.func_77978_p());
    }

    @Override
    protected void onActiveChange() {
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.manageTeleportation();
    }

    @Override
    protected void registerComponents() {
        super.registerComponents();
        this.computerComponent = new ComponentComputers(this);
        this.addComponent(this.computerComponent);
    }

    void manageTeleportation() {
        block9: {
            TransportLocation position;
            List entities;
            block7: {
                block8: {
                    entities = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1)));
                    position = this.getSelectedLocation();
                    if (this.field_145850_b.field_72995_K) break block7;
                    if (this.getEnergyStorage().getEnergyStored() <= this.getEnergyDrain() || entities.size() <= 0 || !this.isLocationValid(this.getSelectedLocation())) break block8;
                    if (this.transportTracker < this.field_145850_b.func_82737_E()) {
                        ++this.transportTimer;
                        if (this.transportTimer >= this.getSpeed()) {
                            for (int i = 0; i < Math.min(entities.size(), 3); ++i) {
                                this.Teleport((Entity)entities.get(i), position);
                                this.transportTracker = this.field_145850_b.func_82737_E() + (long)this.getTransportDelay();
                            }
                            this.energyStorage.modifyEnergyStored(-this.getEnergyDrain());
                            this.transportTimer = 0;
                            MatterOverdrive.packetPipeline.sendToDimention((IMessage)new PacketSyncTransportProgress(this), this.field_145850_b);
                        } else {
                            MatterOverdrive.packetPipeline.sendToAllAround((IMessage)new PacketSyncTransportProgress(this), this, 32.0);
                        }
                    }
                    break block9;
                }
                if (this.transportTimer == 0) break block9;
                this.transportTimer = 0;
                MatterOverdrive.packetPipeline.sendToDimention((IMessage)new PacketSyncTransportProgress(this), this.field_145850_b);
                break block9;
            }
            if (this.transportTimer > 0) {
                for (Entity entity : entities) {
                    this.SpawnReplicateParticles(entity, new Vector3f((float)entity.field_70165_t, (float)this.field_145848_d, (float)entity.field_70161_v));
                }
                for (Entity entity : entities) {
                    this.SpawnReplicateParticles(entity, new Vector3f((float)position.x, (float)(position.y - 1), (float)position.z));
                }
            }
        }
    }

    public void Teleport(Entity entity, TransportLocation position) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventTransport(new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e), position, entity))) {
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70634_a((double)position.x, (double)position.y, (double)position.z);
            } else {
                entity.func_70107_b((double)position.x, (double)position.y, (double)position.z);
            }
        }
    }

    public TransportLocation getSelectedLocation() {
        if (this.selectedLocation < this.locations.size() && this.selectedLocation >= 0) {
            TransportLocation location = this.locations.get(this.selectedLocation);
            int range = this.getTransportRange();
            return location;
        }
        return new TransportLocation(this.field_145851_c, this.field_145848_d, this.field_145849_e, "Unknown");
    }

    public boolean isLocationValid(TransportLocation location) {
        return (location.x != this.field_145851_c || location.y >= this.field_145848_d + 4 || location.y <= this.field_145848_d - 4 || location.z != this.field_145849_e) && location.getDistance(this.field_145851_c, this.field_145848_d, this.field_145849_e) < this.getTransportRange();
    }

    public void setSelectedLocation(int x, int y, int z, String name) {
        if (this.selectedLocation < this.locations.size() && this.selectedLocation >= 0) {
            TransportLocation location = this.locations.get(this.selectedLocation);
            if (location != null) {
                location.setPosition(x, y, z);
                location.setName(name);
            } else {
                this.locations.set(this.selectedLocation, new TransportLocation(x, y, z, name));
            }
        } else {
            this.selectedLocation = 0;
            this.locations.add(new TransportLocation(x, y, z, name));
        }
    }

    public void addNewLocation(int x, int y, int z, String name) {
        this.locations.add(new TransportLocation(x, y, z, name));
    }

    public void removeLocation(int at) {
        if (at < this.locations.size() && at >= 0) {
            this.locations.remove(at);
            this.selectedLocation = MathHelper.func_76125_a((int)this.selectedLocation, (int)0, (int)(this.locations.size() - 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void SpawnReplicateParticles(Entity entity, Vector3f p) {
        double entityRadius = entity.field_70130_N;
        double entityArea = Math.max(entityRadius * (double)entity.field_70131_O, 0.3);
        double radiusX = entityRadius + random.nextDouble() * (double)0.2f;
        double radiusZ = entityRadius + random.nextDouble() * (double)0.2f;
        double time = Math.min((double)this.transportTimer / (double)this.getTransportDelay(), 1.0);
        double gravity = 0.015f;
        int age = (int)Math.round(MOMathHelper.easeIn(time, 5.0, 15.0, 1.0));
        int count = (int)Math.round(MOMathHelper.easeIn(time, 2.0, entityArea * 15.0, 1.0));
        for (int i = 0; i < count; ++i) {
            float speed = random.nextFloat() * 0.05f + 0.15f;
            float height = p.y + 1.0f + random.nextFloat() * entity.field_70131_O;
            Vector3f origin = new Vector3f(p.x, height, p.z);
            Vector3f pos = MOMathHelper.randomSpherePoint(origin.x, origin.y, origin.z, Vec3.func_72443_a((double)radiusX, (double)0.0, (double)radiusZ), random);
            Vector3f dir = Vector3f.cross((Vector3f)Vector3f.sub((Vector3f)origin, (Vector3f)pos, null), (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f), null);
            dir.scale(speed);
            ReplicatorParticle replicatorParticle = new ReplicatorParticle(this.field_145850_b, pos.x, pos.y, pos.z, dir.x, dir.y, dir.z);
            replicatorParticle.setCenter(origin.x, origin.y, origin.z);
            replicatorParticle.setParticleAge(age);
            replicatorParticle.setPointGravityScale(gravity);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)replicatorParticle);
        }
    }

    public int getEnergyDrain() {
        TransportLocation location = this.getSelectedLocation();
        return (int)Math.round(this.getUpgradeMultiply(UpgradeTypes.PowerUsage) * (double)(location.getDistance(this.field_145851_c, this.field_145848_d, this.field_145849_e) * 16));
    }

    private int getSpeed() {
        return (int)Math.round(this.getUpgradeMultiply(UpgradeTypes.Speed) * 70.0);
    }

    private int getTransportDelay() {
        return (int)Math.round(this.getUpgradeMultiply(UpgradeTypes.Speed) * 80.0);
    }

    public int getTransportRange() {
        return (int)Math.round(this.getUpgradeMultiply(UpgradeTypes.Range) * 32.0);
    }

    @Override
    public String getSound() {
        return "transporter";
    }

    @Override
    public boolean hasSound() {
        return true;
    }

    @Override
    public boolean getServerActive() {
        return this.transportTimer > 0;
    }

    @Override
    public float soundVolume() {
        return 0.5f;
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UP && super.canFill(from, fluid);
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UP && super.canDrain(from, fluid);
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return type == UpgradeTypes.PowerUsage || type == UpgradeTypes.Speed || type == UpgradeTypes.Range || type == UpgradeTypes.PowerStorage;
    }

    public void setTransportTime(int time) {
        this.transportTimer = time;
    }

    public int getTransportTime() {
        return this.transportTimer;
    }

    @Override
    public List<TransportLocation> getPositions() {
        return this.locations;
    }

    @Override
    @Optional.Method(modid="Waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te = accessor.getTileEntity();
        if (!(te instanceof TileEntityMachineTransporter)) {
            throw new RuntimeException("Transporter WAILA provider is being used for something that is not a Transporter: " + te.getClass());
        }
        TileEntityMachineTransporter transporter = (TileEntityMachineTransporter)te;
        TransportLocation location = transporter.getSelectedLocation();
        currenttip.add(String.format("%sSelected Location: %s%s", EnumChatFormatting.YELLOW, EnumChatFormatting.WHITE, location.name));
        currenttip.add(String.format("%sDestination Coords: %s X:%d Y:%d Z:%d", EnumChatFormatting.YELLOW, EnumChatFormatting.WHITE, location.x, location.y, location.z));
        return currenttip;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return this.computerComponent.getType();
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return this.computerComponent.getMethodNames();
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        return this.computerComponent.callMethod(computer, context, method, arguments);
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
        this.computerComponent.attach(computer);
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
        this.computerComponent.attach(computer);
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return this.computerComponent.equals(other);
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return this.computerComponent.getComponentName();
    }

    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return this.computerComponent.methods();
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        return this.computerComponent.invoke(method, context, args);
    }
}

