/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network;

import java.util.HashSet;
import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.data.BlockPos;
import matteroverdrive.matter_network.MatterNetworkPacketQueue;
import matteroverdrive.matter_network.MatterNetworkPathNode;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MatterNetworkPacket {
    protected BlockPos senderPos;
    protected NBTTagCompound filter;
    protected HashSet<MatterNetworkPathNode> path = new HashSet();

    public MatterNetworkPacket() {
    }

    public MatterNetworkPacket(BlockPos senderPos, ForgeDirection port) {
        this();
        this.senderPos = senderPos;
        this.senderPos.setOrientation(port);
    }

    public MatterNetworkPacket(BlockPos senderPos, ForgeDirection port, NBTTagCompound filter) {
        this();
        this.senderPos = senderPos;
        this.senderPos.setOrientation(port);
        this.filter = filter;
    }

    public MatterNetworkPacket addToPath(IMatterNetworkConnection connection, ForgeDirection recivedFrom) {
        MatterNetworkPathNode node = new MatterNetworkPathNode(connection.getPosition(), recivedFrom.getOpposite());
        if (!this.path.contains(node)) {
            this.path.add(node);
        }
        return this;
    }

    public boolean hasPassedTrough(IMatterNetworkConnection connection) {
        return this.path.contains(new MatterNetworkPathNode(connection.getPosition()));
    }

    public IMatterNetworkConnection getSender(World world) {
        TileEntity tileEntity;
        if (world != null && (tileEntity = this.senderPos.getTileEntity(world)) != null && tileEntity instanceof IMatterNetworkConnection) {
            return (IMatterNetworkConnection)tileEntity;
        }
        return null;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound != null) {
            if (tagCompound.func_150297_b("Sender", 10)) {
                this.senderPos = new BlockPos(tagCompound.func_74775_l("Sender"));
            }
            if (tagCompound.func_150297_b("Filter", 10)) {
                this.filter = tagCompound.func_74775_l("Filter");
            }
        }
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        if (tagCompound != null && this.senderPos != null) {
            if (this.senderPos != null) {
                NBTTagCompound sender = new NBTTagCompound();
                this.senderPos.writeToNBT(sender);
                tagCompound.func_74782_a("Sender", (NBTBase)sender);
            }
            if (this.filter != null) {
                tagCompound.func_74782_a("Filter", (NBTBase)this.filter);
            }
        }
    }

    public abstract boolean isValid(World var1);

    public NBTTagCompound getFilter() {
        return this.filter;
    }

    public abstract String getName();

    public ForgeDirection getSenderPort() {
        return this.senderPos.orientation;
    }

    public void tickAlive(World world, boolean isAlive) {
    }

    public void onAddedToQueue(World world, MatterNetworkPacketQueue packetQueue, int queueID) {
    }
}

