/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network.components;

import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.api.network.IMatterNetworkDispatcher;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.data.BlockPos;
import matteroverdrive.data.ItemPattern;
import matteroverdrive.matter_network.MatterNetworkPacket;
import matteroverdrive.matter_network.components.MatterNetworkComponentClient;
import matteroverdrive.matter_network.packets.MatterNetworkRequestPacket;
import matteroverdrive.matter_network.packets.MatterNetworkResponsePacket;
import matteroverdrive.matter_network.tasks.MatterNetworkTaskReplicatePattern;
import matteroverdrive.network.packet.client.PacketPatternMonitorSync;
import matteroverdrive.tile.TileEntityMachinePatternMonitor;
import matteroverdrive.util.MatterNetworkHelper;
import matteroverdrive.util.TimeTracker;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MatterNetworkComponentPatternMonitor
extends MatterNetworkComponentClient<TileEntityMachinePatternMonitor> {
    private TimeTracker broadcastTracker = new TimeTracker();
    TimeTracker validateTracker = new TimeTracker();
    private boolean needsSearchRefresh = true;

    public MatterNetworkComponentPatternMonitor(TileEntityMachinePatternMonitor patternMonitor) {
        super(patternMonitor);
        this.handlers.add(BASIC_CONNECTIONS_HANDLER);
    }

    @Override
    protected void executePacket(MatterNetworkPacket packet) {
        super.executePacket(packet);
        if (packet instanceof MatterNetworkResponsePacket) {
            this.executeResponses((MatterNetworkResponsePacket)packet);
        }
    }

    protected void executeResponses(MatterNetworkResponsePacket packet) {
        if (packet.fits(1, 0) && !((TileEntityMachinePatternMonitor)this.rootClient).getDatabases().contains(packet.getSender(this.getWorldObj()).getPosition())) {
            ((TileEntityMachinePatternMonitor)this.rootClient).getDatabases().add(packet.getSender(((TileEntityMachinePatternMonitor)this.rootClient).func_145831_w()).getPosition());
            ((TileEntityMachinePatternMonitor)this.rootClient).SyncDatabasesWithClient();
        }
    }

    @Override
    public int onNetworkTick(World world, TickEvent.Phase phase) {
        int broadcasts = super.onNetworkTick(world, phase);
        this.manageDatabaseValidation(world);
        this.manageSearch(world, phase);
        return broadcasts + this.manageTaskBroadcast(world, phase);
    }

    private void manageSearch(World world, TickEvent.Phase phase) {
        if (phase.equals((Object)TickEvent.Phase.END) && this.needsSearchRefresh) {
            ((TileEntityMachinePatternMonitor)this.rootClient).getDatabases().clear();
            MatterOverdrive.packetPipeline.sendToAllAround((IMessage)new PacketPatternMonitorSync((TileEntityMachinePatternMonitor)this.rootClient), this.rootClient, 64.0);
            for (int i = 0; i < 6; ++i) {
                MatterNetworkRequestPacket packet = new MatterNetworkRequestPacket((IMatterNetworkConnection)((Object)this.rootClient), 0, ForgeDirection.getOrientation((int)i), ((TileEntityMachinePatternMonitor)this.rootClient).getFilter(), IMatterDatabase.class);
                MatterNetworkHelper.broadcastPacketInDirection(world, packet, (IMatterNetworkConnection)((Object)this.rootClient), ForgeDirection.getOrientation((int)i));
            }
            this.needsSearchRefresh = false;
        }
    }

    private void manageDatabaseValidation(World world) {
        if (this.validateTracker.hasDelayPassed(world, 120)) {
            for (BlockPos blockPosition : ((TileEntityMachinePatternMonitor)this.rootClient).getDatabases()) {
                if (blockPosition.getBlock(world) != null && blockPosition.getTileEntity(world) != null && blockPosition.getTileEntity(world) instanceof IMatterDatabase) continue;
                this.needsSearchRefresh = true;
                return;
            }
        }
    }

    private int manageTaskBroadcast(World world, TickEvent.Phase phase) {
        if (phase.equals((Object)TickEvent.Phase.START)) {
            int broadcastCount = 0;
            MatterNetworkTaskReplicatePattern task = (MatterNetworkTaskReplicatePattern)((TileEntityMachinePatternMonitor)this.rootClient).getTaskQueue(0).peek();
            if (task != null) {
                if (task.getState() == MatterNetworkTaskState.FINISHED || task.getState() == MatterNetworkTaskState.PROCESSING) {
                    ((TileEntityMachinePatternMonitor)this.rootClient).getTaskQueue(0).dequeue();
                    ((TileEntityMachinePatternMonitor)this.rootClient).forceSync();
                } else if (!task.isAlive() && this.broadcastTracker.hasDelayPassed(world, 80)) {
                    for (int i = 0; i < 6; ++i) {
                        if (!MatterNetworkHelper.broadcastPacketInDirection(world, (byte)0, task, (IMatterNetworkDispatcher)((Object)this.rootClient), ForgeDirection.getOrientation((int)i), ((TileEntityMachinePatternMonitor)this.rootClient).getFilter())) continue;
                        task.setState(MatterNetworkTaskState.WAITING);
                        ++broadcastCount;
                    }
                }
            }
            ((TileEntityMachinePatternMonitor)this.rootClient).getTaskQueue(0).tickAllAlive(world, false);
            return broadcastCount;
        }
        return 0;
    }

    public void queuePatternRequest(List<ItemPattern> patternRequests) {
        for (int i = 0; i < patternRequests.size(); ++i) {
            MatterNetworkTaskReplicatePattern task = new MatterNetworkTaskReplicatePattern((IMatterNetworkConnection)((Object)this.rootClient), patternRequests.get(i));
            task.setState(MatterNetworkTaskState.WAITING);
            if (!((TileEntityMachinePatternMonitor)this.rootClient).getTaskQueue(0).queue(task)) continue;
        }
        ((TileEntityMachinePatternMonitor)this.rootClient).forceSync();
    }

    public boolean getNeedsSearchRefresh() {
        return this.needsSearchRefresh;
    }

    public void setNeedsSearchRefresh(boolean needsSearchRefresh) {
        this.needsSearchRefresh = needsSearchRefresh;
    }
}

