/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network.components;

import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.matter_network.MatterNetworkPacket;
import matteroverdrive.matter_network.components.MatterNetworkComponentClient;
import matteroverdrive.network.packet.client.PacketSendQueueFlash;
import matteroverdrive.tile.TileEntityMachinePacketQueue;
import matteroverdrive.util.MatterNetworkHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MatterNetworkComponentQueue
extends MatterNetworkComponentClient<TileEntityMachinePacketQueue> {
    public static int[] directions = new int[]{0, 1, 2, 3, 4, 5};

    public MatterNetworkComponentQueue(TileEntityMachinePacketQueue queue) {
        super(queue);
    }

    @Override
    public boolean canPreform(MatterNetworkPacket packet) {
        return ((TileEntityMachinePacketQueue)this.rootClient).getRedstoneActive();
    }

    @Override
    public void queuePacket(MatterNetworkPacket packet, ForgeDirection from) {
        if (this.canPreform(packet) && packet.isValid(this.getWorldObj()) && this.getPacketQueue(0).queue(packet)) {
            packet.addToPath((IMatterNetworkConnection)((Object)this.rootClient), from);
            packet.tickAlive(this.getWorldObj(), true);
            MatterOverdrive.packetPipeline.sendToAllAround((IMessage)new PacketSendQueueFlash((TileEntityMachinePacketQueue)this.rootClient), this.rootClient, 32.0);
        }
    }

    @Override
    protected void executePacket(MatterNetworkPacket packet) {
    }

    protected int handlePacketBroadcast(World world, MatterNetworkPacket packet) {
        int broadcastCount = 0;
        for (int i = 0; i < directions.length; ++i) {
            if (!MatterNetworkHelper.broadcastPacketInDirection(world, packet, (IMatterNetworkConnection)((Object)this.rootClient), ForgeDirection.getOrientation((int)directions[i]))) continue;
            ++broadcastCount;
        }
        return broadcastCount;
    }

    @Override
    public int onNetworkTick(World world, TickEvent.Phase phase) {
        int broadcastCount = 0;
        if (phase == TickEvent.Phase.END) {
            for (int i = 0; i < this.getPacketQueueCount(); ++i) {
                this.getPacketQueue(i).tickAllAlive(world, true);
                MatterNetworkPacket packet = (MatterNetworkPacket)this.getPacketQueue(i).dequeue();
                if (packet == null || !packet.isValid(world)) continue;
                broadcastCount += this.handlePacketBroadcast(world, packet);
            }
        }
        return broadcastCount;
    }
}

