/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.bi;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.weapon.WeaponShot;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.network.packet.AbstractBiPacketHandler;
import matteroverdrive.network.packet.PacketAbstract;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;

public class PacketFirePlasmaShot
extends PacketAbstract {
    WeaponShot shot;
    private int sender;
    private Vec3 position;
    private Vec3 direction;

    public PacketFirePlasmaShot() {
    }

    public PacketFirePlasmaShot(int sender, Vec3 pos, Vec3 dir, WeaponShot shot) {
        this.shot = shot;
        this.sender = sender;
        this.position = pos;
        this.direction = dir;
    }

    public void fromBytes(ByteBuf buf) {
        this.shot = new WeaponShot(buf);
        this.sender = buf.readInt();
        this.position = Vec3.func_72443_a((double)buf.readDouble(), (double)buf.readDouble(), (double)buf.readDouble());
        this.direction = Vec3.func_72443_a((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
    }

    public void toBytes(ByteBuf buf) {
        this.shot.writeTo(buf);
        buf.writeInt(this.sender);
        buf.writeDouble(this.position.field_72450_a);
        buf.writeDouble(this.position.field_72448_b);
        buf.writeDouble(this.position.field_72449_c);
        buf.writeFloat((float)this.direction.field_72450_a);
        buf.writeFloat((float)this.direction.field_72448_b);
        buf.writeFloat((float)this.direction.field_72449_c);
    }

    public WeaponShot getShot() {
        return this.shot;
    }

    public static class BiHandler
    extends AbstractBiPacketHandler<PacketFirePlasmaShot> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, PacketFirePlasmaShot message, MessageContext ctx) {
            EntityLivingBase livingBase;
            Entity entity;
            if (player.func_145782_y() != message.sender && (entity = player.field_70170_p.func_73045_a(message.sender)) != null && entity instanceof EntityLivingBase && (livingBase = (EntityLivingBase)entity).func_70694_bm() != null && livingBase.func_70694_bm().func_77973_b() instanceof EnergyWeapon) {
                ((EnergyWeapon)livingBase.func_70694_bm().func_77973_b()).onClientShot(livingBase.func_70694_bm(), livingBase, message.position, message.direction, message.shot);
            }
            return null;
        }

        @Override
        public IMessage handleServerMessage(EntityPlayer player, PacketFirePlasmaShot message, MessageContext ctx) {
            this.handleServerShot(player, message, 0);
            MatterOverdrive.packetPipeline.sendToAllAround((IMessage)message, player, (double)(message.shot.getRange() + 64));
            return null;
        }

        public void handleServerShot(EntityPlayer player, PacketFirePlasmaShot shot, int delay) {
            ItemStack heldItem = player.func_70694_bm();
            if (heldItem != null && heldItem.func_77973_b() instanceof EnergyWeapon && ((EnergyWeapon)heldItem.func_77973_b()).canFire(player.func_70694_bm(), player.field_70170_p, (EntityLivingBase)player)) {
                ((EnergyWeapon)heldItem.func_77973_b()).onServerFire(heldItem, (EntityLivingBase)player, shot.shot, shot.position, shot.direction, delay);
            }
        }
    }
}

