/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.client;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.data.BlockPos;
import matteroverdrive.data.ItemPattern;
import matteroverdrive.network.packet.TileEntityUpdatePacket;
import matteroverdrive.network.packet.client.AbstractClientPacketHandler;
import matteroverdrive.tile.TileEntityMachinePatternMonitor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketPatternMonitorSync
extends TileEntityUpdatePacket {
    List<ItemPattern> patterns;

    public PacketPatternMonitorSync() {
    }

    public PacketPatternMonitorSync(TileEntityMachinePatternMonitor monitor) {
        super(monitor);
        this.loadPatternsFromDatabases(monitor.func_145831_w(), monitor.getDatabases());
    }

    public void loadPatternsFromDatabases(World world, HashSet<BlockPos> databases) {
        this.patterns = new ArrayList<ItemPattern>();
        for (BlockPos pos : databases) {
            TileEntity tileEntity = pos.getTileEntity(world);
            if (!(tileEntity instanceof IMatterDatabase)) continue;
            List<ItemPattern> itemStacks = ((IMatterDatabase)tileEntity).getPatterns();
            this.patterns.addAll(itemStacks);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        int size = buf.readInt();
        this.patterns = new ArrayList<ItemPattern>();
        for (int i = 0; i < size; ++i) {
            this.patterns.add(new ItemPattern(buf));
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.patterns.size());
        for (ItemPattern pattern : this.patterns) {
            pattern.writeToBuffer(buf);
        }
    }

    public static class ClientHandler
    extends AbstractClientPacketHandler<PacketPatternMonitorSync> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, PacketPatternMonitorSync message, MessageContext ctx) {
            TileEntity entity = message.getTileEntity(player.field_70170_p);
            if (entity != null && entity instanceof TileEntityMachinePatternMonitor) {
                TileEntityMachinePatternMonitor monitor = (TileEntityMachinePatternMonitor)entity;
                monitor.setGuiPatterns(message.patterns);
                monitor.forceSearch(true);
            }
            return null;
        }
    }
}

