/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.client.quest;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.PlayerQuestData;
import matteroverdrive.entity.player.MOExtendedProperties;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.AbstractClientPacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class PacketUpdateQuest
extends PacketAbstract {
    public static final byte UPDATE_QUEST = 0;
    public static final byte ADD_QUEST = 1;
    public static final byte COMPLETE_QUEST = 2;
    private byte questUpdateOperation;
    private int questIndex;
    private QuestStack questStack;

    public PacketUpdateQuest() {
    }

    public PacketUpdateQuest(int questIndex, PlayerQuestData playerQuestData, byte questUpdateOperation) {
        this.questIndex = questIndex;
        this.questUpdateOperation = questUpdateOperation;
        this.questStack = playerQuestData.getActiveQuests().get(questIndex);
    }

    public PacketUpdateQuest(int questIndex, QuestStack questStack, byte questUpdateOperation) {
        this.questIndex = questIndex;
        this.questUpdateOperation = questUpdateOperation;
        this.questStack = questStack;
    }

    public PacketUpdateQuest(QuestStack questStack, byte questUpdateOperation) {
        this.questIndex = -1;
        this.questUpdateOperation = questUpdateOperation;
        this.questStack = questStack;
    }

    public void fromBytes(ByteBuf buf) {
        this.questIndex = buf.readInt();
        this.questUpdateOperation = buf.readByte();
        this.questStack = QuestStack.loadFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.questIndex);
        buf.writeByte((int)this.questUpdateOperation);
        NBTTagCompound questStackNBT = new NBTTagCompound();
        this.questStack.writeToNBT(questStackNBT);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)questStackNBT);
    }

    public static class ClientHandler
    extends AbstractClientPacketHandler<PacketUpdateQuest> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, PacketUpdateQuest message, MessageContext ctx) {
            MOExtendedProperties extendedProperties = MOExtendedProperties.get(player);
            if (extendedProperties != null) {
                if (message.questUpdateOperation == 0) {
                    extendedProperties.updateQuestFromServer(message.questIndex, message.questStack);
                } else if (message.questUpdateOperation == 1) {
                    extendedProperties.addQuest(message.questStack);
                } else if (message.questUpdateOperation == 2) {
                    extendedProperties.onQuestCompleted(message.questStack, message.questIndex);
                }
            }
            return null;
        }
    }
}

