/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import matteroverdrive.data.ItemPattern;
import matteroverdrive.items.MatterScanner;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import matteroverdrive.util.MatterHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PacketMatterScannerUpdate
extends PacketAbstract {
    private ItemPattern selected;
    private short page;
    private short slot;

    public PacketMatterScannerUpdate() {
    }

    public PacketMatterScannerUpdate(ItemStack scanner, short slot) {
        this.selected = MatterScanner.getSelectedAsPattern(scanner);
        if (scanner.func_77942_o()) {
            this.page = scanner.func_77978_p().func_74771_c("page");
        }
        this.slot = slot;
    }

    public void fromBytes(ByteBuf buf) {
        this.selected = new ItemPattern(buf);
        this.page = buf.readShort();
        this.slot = buf.readShort();
    }

    public void toBytes(ByteBuf buf) {
        this.selected.writeToBuffer(buf);
        buf.writeShort((int)this.page);
        buf.writeShort((int)this.slot);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketMatterScannerUpdate> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, PacketMatterScannerUpdate message, MessageContext ctx) {
            ItemStack scanner;
            if (message.slot < player.field_71071_by.func_70302_i_() && MatterHelper.isMatterScanner(scanner = player.field_71071_by.func_70301_a((int)message.slot))) {
                MatterScanner.setSelected(scanner, message.selected);
                if (scanner.func_77942_o()) {
                    scanner.func_77978_p().func_74777_a("page", message.page);
                }
            }
            return null;
        }
    }
}

