/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.network.packet.AbstractBiPacketHandler;
import matteroverdrive.network.packet.TileEntityUpdatePacket;
import matteroverdrive.tile.MOTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class PacketSendMachineNBT
extends TileEntityUpdatePacket {
    NBTTagCompound data;
    int cattegories;
    boolean forceUpdate;

    public PacketSendMachineNBT() {
    }

    public PacketSendMachineNBT(EnumSet<MachineNBTCategory> categories, MOTileEntity tileEntity, boolean forceUpdate, boolean toDisk) {
        super(tileEntity);
        this.data = new NBTTagCompound();
        this.forceUpdate = forceUpdate;
        tileEntity.writeCustomNBT(this.data, categories, toDisk);
        this.cattegories = MachineNBTCategory.encode(categories);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
        this.cattegories = buf.readInt();
        this.forceUpdate = buf.readBoolean();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
        buf.writeInt(this.cattegories);
        buf.writeBoolean(this.forceUpdate);
    }

    public static class BiHandler
    extends AbstractBiPacketHandler<PacketSendMachineNBT> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, PacketSendMachineNBT message, MessageContext ctx) {
            TileEntity tileEntity = message.getTileEntity(player.field_70170_p);
            if (tileEntity instanceof MOTileEntity) {
                ((MOTileEntity)tileEntity).readCustomNBT(message.data, MachineNBTCategory.decode(message.cattegories));
            }
            return null;
        }

        @Override
        public IMessage handleServerMessage(EntityPlayer player, PacketSendMachineNBT message, MessageContext ctx) {
            TileEntity tileEntity = message.getTileEntity(player.field_70170_p);
            if (tileEntity instanceof MOTileEntity) {
                ((MOTileEntity)tileEntity).readCustomNBT(message.data, MachineNBTCategory.decode(message.cattegories));
                if (message.forceUpdate) {
                    if (tileEntity instanceof MOTileEntityMachine) {
                        ((MOTileEntityMachine)tileEntity).forceSync();
                    } else {
                        player.field_70170_p.func_147471_g(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
                    }
                }
            }
            return null;
        }
    }
}

