/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server.starmap;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.starmap.GalacticPosition;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.starmap.PacketUpdateTravelEvents;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import matteroverdrive.starmap.GalaxyServer;
import matteroverdrive.starmap.data.TravelEvent;
import net.minecraft.entity.player.EntityPlayer;

public class PacketStarMapAttack
extends PacketAbstract {
    GalacticPosition from;
    GalacticPosition to;
    int shipID;

    public PacketStarMapAttack() {
    }

    public PacketStarMapAttack(GalacticPosition from, GalacticPosition to, int shipID) {
        this.from = from;
        this.to = to;
        this.shipID = shipID;
    }

    public void fromBytes(ByteBuf buf) {
        this.from = new GalacticPosition(buf);
        this.to = new GalacticPosition(buf);
        this.shipID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        this.from.writeToBuffer(buf);
        this.to.writeToBuffer(buf);
        buf.writeInt(this.shipID);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketStarMapAttack> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, PacketStarMapAttack message, MessageContext ctx) {
            TravelEvent travelEvent = GalaxyServer.getInstance().createTravelEvent(message.from, message.to, message.shipID);
            if (travelEvent != null) {
                MatterOverdrive.packetPipeline.sendToDimention((IMessage)new PacketUpdateTravelEvents(GalaxyServer.getInstance().getTheGalaxy()), player.field_70170_p);
            }
            return null;
        }
    }
}

