/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server.starmap;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import matteroverdrive.api.starmap.GalacticPosition;
import matteroverdrive.network.packet.TileEntityUpdatePacket;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import matteroverdrive.tile.TileEntityMachineStarMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketStarMapClientCommands
extends TileEntityUpdatePacket {
    int zoomLevel;
    GalacticPosition position;
    GalacticPosition destination;

    public PacketStarMapClientCommands() {
    }

    public PacketStarMapClientCommands(TileEntityMachineStarMap starMap, int zoomLevel, GalacticPosition position, GalacticPosition destination) {
        super(starMap);
        this.zoomLevel = zoomLevel;
        this.position = position;
        this.destination = destination;
    }

    public PacketStarMapClientCommands(TileEntityMachineStarMap starMap) {
        super(starMap);
        this.zoomLevel = starMap.getZoomLevel();
        this.position = starMap.getGalaxyPosition();
        this.destination = starMap.getDestination();
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.zoomLevel = buf.readByte();
        this.position = new GalacticPosition(buf);
        this.destination = new GalacticPosition(buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.zoomLevel);
        this.position.writeToBuffer(buf);
        this.destination.writeToBuffer(buf);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketStarMapClientCommands> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, PacketStarMapClientCommands message, MessageContext ctx) {
            TileEntity tileEntity = message.getTileEntity(player.field_70170_p);
            if (tileEntity instanceof TileEntityMachineStarMap) {
                ((TileEntityMachineStarMap)tileEntity).setZoomLevel(message.zoomLevel);
                ((TileEntityMachineStarMap)tileEntity).setGalaxticPosition(message.position);
                ((TileEntityMachineStarMap)tileEntity).setDestination(message.destination);
                ((TileEntityMachineStarMap)tileEntity).forceSync();
            }
            return null;
        }
    }
}

