/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.proxy;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.client.RenderHandler;
import matteroverdrive.client.render.HoloIcons;
import matteroverdrive.client.resources.data.WeaponMetadataSection;
import matteroverdrive.client.resources.data.WeaponMetadataSectionSerializer;
import matteroverdrive.compat.MatterOverdriveCompat;
import matteroverdrive.gui.GuiAndroidHud;
import matteroverdrive.gui.GuiQuestHud;
import matteroverdrive.handler.GoogleAnalyticsClient;
import matteroverdrive.handler.KeyHandler;
import matteroverdrive.handler.MouseHandler;
import matteroverdrive.handler.TooltipHandler;
import matteroverdrive.handler.weapon.ClientWeaponHandler;
import matteroverdrive.handler.weapon.CommonWeaponHandler;
import matteroverdrive.init.MatterOverdriveGuides;
import matteroverdrive.init.MatterOverdriveIcons;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.proxy.CommonProxy;
import matteroverdrive.starmap.GalaxyClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.data.IMetadataSectionSerializer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    private static ClientProxy clientProxy;
    public static RenderHandler renderHandler;
    public static KeyHandler keyHandler;
    public static MouseHandler mouseHandler;
    public static GuiAndroidHud androidHud;
    public static HoloIcons holoIcons;
    private ClientWeaponHandler weaponHandler = new ClientWeaponHandler();
    public static GuiQuestHud questHud;

    public ClientProxy() {
        this.googleAnalyticsCommon = new GoogleAnalyticsClient();
    }

    @Override
    public void registerProxies() {
        super.registerProxies();
        renderHandler = new RenderHandler((World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().func_110434_K());
        androidHud = new GuiAndroidHud(Minecraft.func_71410_x());
        keyHandler = new KeyHandler();
        mouseHandler = new MouseHandler();
        holoIcons = new HoloIcons();
        this.weaponHandler = new ClientWeaponHandler();
        questHud = new GuiQuestHud();
        Minecraft.func_71410_x().func_110438_M().field_110621_c.func_110504_a((IMetadataSectionSerializer)new WeaponMetadataSectionSerializer(), WeaponMetadataSection.class);
        this.registerSubscribtions();
        renderHandler.createBlockRenderers();
        renderHandler.createTileEntityRenderers(MatterOverdrive.configHandler);
        renderHandler.createItemRenderers();
        renderHandler.createEntityRenderers();
        renderHandler.createBioticStatRenderers();
        renderHandler.createStarmapRenderers();
        renderHandler.createModels();
        renderHandler.registerBlockRenderers();
        renderHandler.registerTileEntitySpecialRenderers();
        renderHandler.registerItemRenderers();
        renderHandler.registerEntityRenderers();
        renderHandler.registerBioticStatRenderers();
        renderHandler.registerBionicPartRenderers();
        renderHandler.registerStarmapRenderers();
        renderHandler.registerWeaponModuleModels();
        MatterOverdrive.configHandler.subscribe(androidHud);
    }

    private void registerSubscribtions() {
        FMLCommonHandler.instance().bus().register((Object)keyHandler);
        FMLCommonHandler.instance().bus().register((Object)mouseHandler);
        MinecraftForge.EVENT_BUS.register((Object)GalaxyClient.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)new MatterOverdriveIcons());
        MinecraftForge.EVENT_BUS.register((Object)renderHandler);
        MinecraftForge.EVENT_BUS.register((Object)new TooltipHandler());
        MinecraftForge.EVENT_BUS.register((Object)androidHud);
        MinecraftForge.EVENT_BUS.register((Object)mouseHandler);
        MinecraftForge.EVENT_BUS.register((Object)questHud);
        FMLCommonHandler.instance().bus().register((Object)renderHandler);
        FMLCommonHandler.instance().bus().register((Object)GalaxyClient.getInstance());
        FMLCommonHandler.instance().bus().register((Object)androidHud);
        MinecraftForge.EVENT_BUS.register((Object)this.weaponHandler);
    }

    @Override
    public void registerCompatModules() {
        super.registerCompatModules();
        MatterOverdriveCompat.registerClientModules();
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        this.weaponHandler.registerWeapon(MatterOverdriveItems.phaserRifle);
        this.weaponHandler.registerWeapon(MatterOverdriveItems.phaser);
        this.weaponHandler.registerWeapon(MatterOverdriveItems.omniTool);
        this.weaponHandler.registerWeapon(MatterOverdriveItems.plasmaShotgun);
        this.weaponHandler.registerWeapon(MatterOverdriveItems.ionSniper);
        MatterOverdriveGuides.registerGuideElements(event);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        MatterOverdriveGuides.registerGuides(event);
    }

    public ClientWeaponHandler getClientWeaponHandler() {
        return this.weaponHandler;
    }

    @Override
    public CommonWeaponHandler getWeaponHandler() {
        return this.weaponHandler;
    }

    public static ClientProxy instance() {
        if (clientProxy == null) {
            clientProxy = (ClientProxy)MatterOverdrive.proxy;
        }
        return clientProxy;
    }
}

