/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.starmap.data;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import matteroverdrive.starmap.GalaxyGenerator;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.starmap.gen.ISpaceBodyGen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Star
extends SpaceBody {
    private Quadrant quadrant;
    private HashMap<Integer, Planet> planetHashMap;
    private float x;
    private float y;
    private float z;
    private float size;
    private float mass;
    private byte type;
    private int temperature;
    private int color;
    private int seed;
    private boolean generated;
    private boolean isDirty;

    public Star() {
        this.init();
    }

    public Star(String name, int id) {
        super(name, id);
        this.init();
    }

    public void generateMissing(NBTTagCompound tagCompound, GalaxyGenerator galaxyGenerator) {
        if (galaxyGenerator != null) {
            for (ISpaceBodyGen<Star> starGen : galaxyGenerator.getStarGen().getGens()) {
                galaxyGenerator.getStarRandom().setSeed(this.seed);
                if (!starGen.generateMissing(tagCompound, this, galaxyGenerator.getStarRandom())) continue;
                break;
            }
            for (Planet planet : this.getPlanets()) {
                planet.generateMissing(tagCompound, galaxyGenerator);
            }
        }
    }

    public void update(World world) {
        for (Planet planet : this.getPlanets()) {
            planet.update(world);
        }
    }

    public void onSave(File file, World world) {
        this.isDirty = false;
        for (Planet planet : this.getPlanets()) {
            planet.onSave(file, world);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74776_a("X", this.x);
        tagCompound.func_74776_a("Y", this.y);
        tagCompound.func_74776_a("Z", this.z);
        tagCompound.func_74776_a("Size", this.size);
        tagCompound.func_74776_a("Mass", this.mass);
        tagCompound.func_74774_a("Type", this.type);
        tagCompound.func_74768_a("Temperature", this.temperature);
        tagCompound.func_74768_a("Color", this.color);
        tagCompound.func_74768_a("Seed", this.seed);
        tagCompound.func_74757_a("Generated", this.generated);
        NBTTagList planetList = new NBTTagList();
        for (Planet planet : this.getPlanets()) {
            NBTTagCompound quadrantNBT = new NBTTagCompound();
            planet.writeToNBT(quadrantNBT);
            planetList.func_74742_a((NBTBase)quadrantNBT);
        }
        tagCompound.func_74782_a("Planets", (NBTBase)planetList);
    }

    @Override
    public void writeToBuffer(ByteBuf byteBuf) {
        super.writeToBuffer(byteBuf);
        byteBuf.writeFloat(this.x);
        byteBuf.writeFloat(this.y);
        byteBuf.writeFloat(this.z);
        byteBuf.writeFloat(this.size);
        byteBuf.writeFloat(this.mass);
        byteBuf.writeByte((int)this.type);
        byteBuf.writeInt(this.temperature);
        byteBuf.writeInt(this.color);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound, GalaxyGenerator generator) {
        super.readFromNBT(tagCompound, generator);
        this.x = tagCompound.func_74760_g("X");
        this.y = tagCompound.func_74760_g("Y");
        this.z = tagCompound.func_74760_g("Z");
        this.size = tagCompound.func_74760_g("Size");
        this.mass = tagCompound.func_74760_g("Mass");
        this.type = tagCompound.func_74771_c("Type");
        this.temperature = tagCompound.func_74762_e("Temperature");
        this.color = tagCompound.func_74762_e("Color");
        this.seed = tagCompound.func_74762_e("Seed");
        this.generated = tagCompound.func_74767_n("Generated");
        NBTTagList planetList = tagCompound.func_150295_c("Planets", 10);
        for (int i = 0; i < planetList.func_74745_c(); ++i) {
            Planet planet = new Planet();
            planet.readFromNBT(planetList.func_150305_b(i), generator);
            this.addPlanet(planet);
            planet.setStar(this);
        }
        this.generateMissing(tagCompound, generator);
    }

    @Override
    public void readFromBuffer(ByteBuf byteBuf) {
        super.readFromBuffer(byteBuf);
        this.x = byteBuf.readFloat();
        this.y = byteBuf.readFloat();
        this.z = byteBuf.readFloat();
        this.size = byteBuf.readFloat();
        this.mass = byteBuf.readFloat();
        this.type = byteBuf.readByte();
        this.temperature = byteBuf.readInt();
        this.color = byteBuf.readInt();
    }

    @Override
    public SpaceBody getParent() {
        return this.quadrant;
    }

    public Planet planet(int at) {
        return this.planetHashMap.get(at);
    }

    public boolean hasPlanet(int id) {
        return this.planetHashMap.containsKey(id);
    }

    private void init() {
        this.planetHashMap = new HashMap();
    }

    public Collection<Planet> getPlanets() {
        return this.planetHashMap.values();
    }

    public Map<Integer, Planet> getPlanetMap() {
        return this.planetHashMap;
    }

    public void addPlanet(Planet planet) {
        this.getPlanetMap().put(planet.getId(), planet);
    }

    public void setPosition(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3 getPosition() {
        return this.getPosition(1.0);
    }

    public Vec3 getPosition(double multipy) {
        return Vec3.func_72443_a((double)((double)this.x * multipy), (double)((double)this.y * multipy), (double)((double)this.z * multipy));
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public void setQuadrant(Quadrant quadrant) {
        this.quadrant = quadrant;
    }

    public Quadrant getQuadrant() {
        return this.quadrant;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public float getSize() {
        return this.size;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public byte getType() {
        return this.type;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void clearPlanets() {
        this.planetHashMap.clear();
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void setGenerated(boolean generated) {
        this.generated = generated;
    }

    public void setMass(float mass) {
        this.mass = mass;
    }

    public float getMass() {
        return this.mass;
    }

    public int isClaimed(EntityPlayer player) {
        int ownType = 0;
        for (Planet planet : this.getPlanets()) {
            if (!planet.hasOwner()) continue;
            if (planet.getOwnerUUID().equals(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH())) && planet.isHomeworld()) {
                if (ownType < 3) {
                    ownType = 3;
                } else if (ownType < 2) {
                    ownType = 2;
                }
            }
            if (ownType >= 1) continue;
            ownType = 1;
        }
        return ownType;
    }

    public boolean isClaimed() {
        for (Planet planet : this.getPlanets()) {
            if (!planet.hasOwner()) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        for (Planet planet : this.getPlanets()) {
            if (!planet.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void markDirty() {
        this.isDirty = true;
    }
}

