/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cpw.mods.fml.common.registry.GameRegistry;
import matteroverdrive.api.IMOTileEntity;
import matteroverdrive.data.BlockPos;
import matteroverdrive.util.MOLog;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityBoundingBox
extends TileEntity
implements IMOTileEntity {
    private int tick = 0;
    private BlockPos ownerPos;
    private Block ownerBlock;

    public void func_145845_h() {
        ++this.tick;
        if (this.tick == 80) {
            this.tick = 0;
            if (!this.ownerPresent()) {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public boolean canUpdate() {
        return this.field_145850_b != null;
    }

    private boolean ownerPresent() {
        return this.field_145850_b.func_147439_a(this.ownerPos.x, this.ownerPos.y, this.ownerPos.z) == this.ownerBlock;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.ownerPos = new BlockPos(tag);
        String ownerModid = tag.func_74779_i("owner_block_modid");
        String ownerName = tag.func_74779_i("owner_block_name");
        Block block = GameRegistry.findBlock((String)ownerModid, (String)ownerName);
        if (block == null) {
            MOLog.error("Missing owner block " + ownerModid + ":" + ownerName, new Object[0]);
        } else {
            this.ownerBlock = block;
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.ownerPos != null) {
            this.ownerPos.writeToNBT(tag);
        }
        if (this.ownerBlock != null) {
            GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Block)this.ownerBlock);
            tag.func_74778_a("owner_block_modid", id.modId);
            tag.func_74778_a("owner_block_name", id.name);
        }
    }

    public BlockPos getOwnerPos() {
        return this.ownerPos;
    }

    public void setOwnerPos(BlockPos ownerPos) {
        this.ownerPos = ownerPos;
    }

    public Block getOwnerBlock() {
        return this.ownerBlock;
    }

    public void setOwnerBlock(Block ownerBlock) {
        this.ownerBlock = ownerBlock;
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Override
    public void onNeighborBlockChange() {
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
    }
}

