/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.machines.IUpgradeHandler;
import matteroverdrive.data.BlockPos;
import matteroverdrive.entity.player.AndroidPlayer;
import matteroverdrive.tile.IMultiBlockTileEntity;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineChargingStation
extends MOTileEntityMachineEnergy
implements IMultiBlockTileEntity {
    public static final int ENERGY_CAPACITY = 512000;
    public static final int ENERGY_TRANSFER = 512;
    public static int BASE_MAX_RANGE = 8;
    private static UpgradeHandler upgradeHandler = new UpgradeHandler();

    public TileEntityMachineChargingStation() {
        super(2);
        this.energyStorage.setCapacity(512000);
        this.energyStorage.setMaxExtract(512);
        this.energyStorage.setMaxReceive(512);
        this.playerSlotsHotbar = true;
        this.playerSlotsMain = true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.manageAndroidCharging();
    }

    private void manageAndroidCharging() {
        if (!this.field_145850_b.field_72995_K && this.getEnergyStored(ForgeDirection.UNKNOWN) > 0) {
            int range = this.getRage();
            AxisAlignedBB radius = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - range), (double)(this.field_145848_d - range), (double)(this.field_145849_e - range), (double)(this.field_145851_c + range), (double)(this.field_145848_d + range), (double)(this.field_145849_e + range));
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, radius);
            for (EntityPlayer player : players) {
                if (!AndroidPlayer.get(player).isAndroid()) continue;
                int required = this.getRequiredEnergy(player, range);
                int max = Math.min(this.getEnergyStored(ForgeDirection.UNKNOWN), this.getMaxCharging());
                int toExtract = Math.min(required, max);
                this.extractEnergy(ForgeDirection.UNKNOWN, AndroidPlayer.get(player).receiveEnergy(toExtract, false), false);
            }
        }
    }

    public int getRage() {
        return (int)((double)BASE_MAX_RANGE * this.getUpgradeMultiply(UpgradeTypes.Range));
    }

    public int getMaxCharging() {
        return (int)(512.0 / this.getUpgradeMultiply(UpgradeTypes.PowerUsage));
    }

    private int getRequiredEnergy(EntityPlayer player, int maxRange) {
        return (int)(512.0 * (1.0 - MathHelper.func_151237_a((double)(Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v).func_72444_a(Vec3.func_72443_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e)).func_72433_c() / (double)maxRange), (double)0.0, (double)1.0)));
    }

    @Override
    public String getSound() {
        return null;
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    public boolean getServerActive() {
        return false;
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    @Override
    protected void onActiveChange() {
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return type.equals((Object)UpgradeTypes.Range) || type.equals((Object)UpgradeTypes.PowerStorage) || type.equals((Object)UpgradeTypes.PowerUsage);
    }

    @Override
    protected void onAwake(Side side) {
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 8192.0;
    }

    @Override
    public List<BlockPos> getBoundingBlocks() {
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        coords.add(new BlockPos(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e));
        coords.add(new BlockPos(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e));
        return coords;
    }

    @Override
    public IUpgradeHandler getUpgradeHandler() {
        return upgradeHandler;
    }

    public static class UpgradeHandler
    implements IUpgradeHandler {
        @Override
        public double affectUpgrade(UpgradeTypes type, double multiply) {
            if (type.equals((Object)UpgradeTypes.Range)) {
                return Math.min(8.0, multiply);
            }
            return multiply;
        }
    }
}

