/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.quest.Quest;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.RemoveOnlySlot;
import matteroverdrive.data.inventory.SlotContract;
import matteroverdrive.data.quest.WeightedRandomQuest;
import matteroverdrive.init.MatterOverdriveQuests;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.MachineNBTCategory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;

public class TileEntityMachineContractMarket
extends MOTileEntityMachine {
    public static final int QUEST_GENERATE_DELAY_MIN = 36000;
    public static final int QUEST_GENERATE_DELAY_PER_SLOT = 6000;
    public static final int CONTRACT_SLOTS = 18;
    private long lastGenerationTime;

    public TileEntityMachineContractMarket() {
        super(0);
        this.playerSlotsMain = true;
        this.playerSlotsHotbar = true;
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        super.RegisterSlots(inventory);
        inventory.AddSlot(new RemoveOnlySlot(true));
        for (int i = 0; i < 18; ++i) {
            inventory.AddSlot(new SlotContract(false));
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.manageContractGeneration();
        }
    }

    protected void manageContractGeneration() {
        if (this.getRedstoneActive() && this.getTimeUntilNextQuest() <= 0) {
            this.generateContract();
        }
    }

    private void generateContract() {
        Quest quest = ((WeightedRandomQuest)WeightedRandom.func_76271_a((Random)random, MatterOverdriveQuests.contractGeneration)).getQuest();
        QuestStack questStack = MatterOverdrive.questFactory.generateQuestStack(random, quest);
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemStack;
            if (this.inventory.getSlot(i).getItem() == null || (itemStack = this.inventory.getSlot(i).getItem()).func_77978_p() == null) continue;
            QuestStack qs = QuestStack.loadFromNBT(itemStack.func_77978_p());
            if (!questStack.getQuest().areQuestStacksEqual(questStack, qs)) continue;
            return;
        }
        this.inventory.addItem(questStack.getContract());
        this.addGenerationDelay();
        this.forceSync();
    }

    public void addGenerationDelay() {
        int freeSlots = this.getFreeSlots();
        this.lastGenerationTime = this.field_145850_b.func_82737_E() + 36000L + (long)((this.inventory.func_70302_i_() - freeSlots) * 6000);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.lastGenerationTime = nbt.func_74763_f("LastGenerationTime");
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeCustomNBT(nbt, categories, toDisk);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            nbt.func_74772_a("LastGenerationTime", this.lastGenerationTime);
        }
    }

    public int getFreeSlots() {
        int freeSlots = 0;
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (this.inventory.getSlot(i).getItem() != null) continue;
            ++freeSlots;
        }
        return freeSlots;
    }

    public int getTimeUntilNextQuest() {
        return Math.max(0, (int)(this.lastGenerationTime - this.field_145850_b.func_82737_E()));
    }

    @Override
    public String getSound() {
        return null;
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    public boolean getServerActive() {
        return false;
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    @Override
    protected void onActiveChange() {
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    @Override
    protected void onAwake(Side side) {
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
        this.addGenerationDelay();
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }
}

