/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.api.gravity.AnomalySuppressor;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.blocks.BlockGravitationalAnomaly;
import matteroverdrive.client.render.RenderParticlesHandler;
import matteroverdrive.fx.GravitationalStabilizerBeamParticle;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.tile.IMOTickable;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import matteroverdrive.tile.TileEntityGravitationalAnomaly;
import matteroverdrive.util.MOBlockHelper;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.util.vector.Vector3f;

public class TileEntityMachineGravitationalStabilizer
extends MOTileEntityMachineEnergy
implements IMOTickable {
    MovingObjectPosition hit;

    public TileEntityMachineGravitationalStabilizer() {
        super(4);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            this.spawnParticles(this.field_145850_b);
            this.hit = this.seacrhForAnomalies(this.field_145850_b);
        }
    }

    @Override
    protected void onAwake(Side side) {
    }

    MovingObjectPosition seacrhForAnomalies(World world) {
        ForgeDirection front = ForgeDirection.getOrientation((int)world.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        for (int i = 1; i < 64; ++i) {
            Block block = world.func_147439_a(this.field_145851_c + front.offsetX * i, this.field_145848_d + front.offsetY * i, this.field_145849_e + front.offsetZ * i);
            if (!(block instanceof BlockGravitationalAnomaly) && block.func_149688_o() != null && !block.func_149688_o().func_76218_k()) continue;
            return new MovingObjectPosition(this.field_145851_c + front.offsetX * i, this.field_145848_d + front.offsetY * i, this.field_145849_e + front.offsetZ * i, front.getOpposite().ordinal(), Vec3.func_72443_a((double)((double)(this.field_145851_c + front.offsetX * i) - (double)Math.abs(front.offsetX) * 0.5), (double)((double)(this.field_145848_d + front.offsetY * i) - (double)Math.abs(front.offsetY) * 0.5), (double)((double)(this.field_145849_e + front.offsetZ * i) - (double)Math.abs(front.offsetZ) * 0.5)));
        }
        return null;
    }

    void manageAnomalies(World world) {
        this.hit = this.seacrhForAnomalies(world);
        if (this.hit != null && world.func_147438_o(this.hit.field_72311_b, this.hit.field_72312_c, this.hit.field_72309_d) instanceof TileEntityGravitationalAnomaly) {
            ((TileEntityGravitationalAnomaly)world.func_147438_o(this.hit.field_72311_b, this.hit.field_72312_c, this.hit.field_72309_d)).suppress(new AnomalySuppressor(this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, 0.7f));
        }
    }

    @SideOnly(value=Side.CLIENT)
    void spawnParticles(World world) {
        if (this.hit != null && world.func_147438_o(this.hit.field_72311_b, this.hit.field_72312_c, this.hit.field_72309_d) instanceof TileEntityGravitationalAnomaly && random.nextFloat() < 0.2f) {
            float r = (float)this.getBeamColorR();
            float g = (float)this.getBeamColorG();
            float b = (float)this.getBeamColorB();
            if (r != 0.0f || g != 0.0f || b != 0.0f) {
                ForgeDirection up = ForgeDirection.getOrientation((int)MOBlockHelper.getAboveSide(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)));
                GravitationalStabilizerBeamParticle particle = new GravitationalStabilizerBeamParticle(this.field_145850_b, new Vector3f((float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 0.5f, (float)this.field_145849_e + 0.5f), new Vector3f((float)this.hit.field_72311_b + 0.5f, (float)this.hit.field_72312_c + 0.5f, (float)this.hit.field_72309_d + 0.5f), new Vector3f((float)up.offsetX, (float)up.offsetY, (float)up.offsetZ), 1.0f, 0.3f, 80);
                particle.setColor(r, g, b, 1.0f);
                ClientProxy.renderHandler.getRenderParticlesHandler().addEffect(particle, RenderParticlesHandler.Blending.Additive);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 8172.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        Block type = this.func_145838_q();
        if (type != null) {
            AxisAlignedBB bb = type.func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.hit != null) {
                return bb.func_72314_b((double)(this.hit.field_72311_b - this.field_145851_c), (double)(this.hit.field_72312_c - this.field_145848_d), (double)(this.hit.field_72309_d - this.field_145849_e));
            }
            return bb;
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    @Override
    public String getSound() {
        return "force_field";
    }

    @Override
    public boolean hasSound() {
        return true;
    }

    @Override
    public boolean getServerActive() {
        return this.hit != null;
    }

    @Override
    public float soundVolume() {
        return (float)Math.max(Math.max(this.getBeamColorR(), this.getBeamColorG()), this.getBeamColorB()) * 0.5f;
    }

    @Override
    protected void onActiveChange() {
    }

    public double getBeamColorR() {
        return MOMathHelper.noise(0.0, this.field_145848_d, (double)this.field_145850_b.func_72820_D() * 0.01);
    }

    public double getBeamColorG() {
        return MOMathHelper.noise(this.field_145851_c, 0.0, (double)this.field_145850_b.func_72820_D() * 0.01);
    }

    public double getBeamColorB() {
        return MOMathHelper.noise(0.0, 0.0, (double)this.field_145849_e + (double)this.field_145850_b.func_72820_D() * 0.01);
    }

    public MovingObjectPosition getHit() {
        return this.hit;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public void onServerTick(TickEvent.Phase phase, World world) {
        if (this.field_145850_b == null) {
            return;
        }
        if (phase.equals((Object)TickEvent.Phase.START) && this.getRedstoneActive()) {
            this.manageAnomalies(this.field_145850_b);
        }
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }
}

