/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.network.IMatterNetworkBroadcaster;
import matteroverdrive.api.network.IMatterNetworkClient;
import matteroverdrive.api.network.IMatterNetworkDispatcher;
import matteroverdrive.api.network.IMatterNetworkHandler;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.blocks.BlockReplicator;
import matteroverdrive.compat.modules.waila.IWailaBodyProvider;
import matteroverdrive.data.BlockPos;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.ItemPattern;
import matteroverdrive.data.inventory.DatabaseSlot;
import matteroverdrive.data.inventory.RemoveOnlySlot;
import matteroverdrive.data.inventory.ShieldingSlot;
import matteroverdrive.fx.ReplicatorParticle;
import matteroverdrive.handler.SoundHandler;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.components.ComponentMatterNetworkConfigs;
import matteroverdrive.matter_network.MatterNetworkPacket;
import matteroverdrive.matter_network.MatterNetworkPacketQueue;
import matteroverdrive.matter_network.MatterNetworkTaskQueue;
import matteroverdrive.matter_network.components.MatterNetworkComponentReplicator;
import matteroverdrive.matter_network.tasks.MatterNetworkTaskReplicatePattern;
import matteroverdrive.network.packet.client.PacketReplicationComplete;
import matteroverdrive.tile.MOTileEntityMachineMatter;
import matteroverdrive.util.MOBlockHelper;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.MatterNetworkHelper;
import matteroverdrive.util.TimeTracker;
import matteroverdrive.util.math.MOMathHelper;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.util.vector.Vector3f;

public class TileEntityMachineReplicator
extends MOTileEntityMachineMatter
implements IMatterNetworkClient,
IMatterNetworkHandler,
IMatterNetworkDispatcher<MatterNetworkTaskReplicatePattern>,
IMatterNetworkBroadcaster,
IWailaBodyProvider {
    public static int MATTER_STORAGE = 1024;
    public static int ENERGY_STORAGE = 512000;
    public static final int MATTER_TRANSFER = 128;
    public static final int PATTERN_SEARCH_DELAY = 60;
    public static final int REPLICATION_ANIMATION_TIME = 60;
    public int OUTPUT_SLOT_ID = 0;
    public int SECOND_OUTPUT_SLOT_ID = 1;
    public int DATABASE_SLOT_ID = 2;
    public int SHIELDING_SLOT_ID = 3;
    public static int REPLICATE_SPEED_PER_MATTER = 120;
    public static int REPLICATE_ENERGY_PER_MATTER = 16000;
    public static final int RADIATION_DAMAGE_DELAY = 5;
    public static final int RADIATION_RANGE = 8;
    public static final double FAIL_CHANCE = 0.005;
    @SideOnly(value=Side.CLIENT)
    private boolean isPlayingReplicateAnimation;
    @SideOnly(value=Side.CLIENT)
    private int replicateAnimationCounter;
    public int replicateTime;
    private float replicateProgress;
    private MatterNetworkComponentReplicator networkComponent;
    private ComponentMatterNetworkConfigs componentMatterNetworkConfigs;
    private final MatterNetworkTaskQueue<MatterNetworkTaskReplicatePattern> taskQueueProcessing;
    private final TimeTracker timeTracker;
    private ItemPattern internalPatternStorage;

    public TileEntityMachineReplicator() {
        super(4);
        this.energyStorage.setCapacity(ENERGY_STORAGE);
        this.energyStorage.setMaxExtract(ENERGY_STORAGE);
        this.energyStorage.setMaxReceive(ENERGY_STORAGE);
        this.matterStorage.setCapacity(MATTER_STORAGE);
        this.matterStorage.setMaxReceive(128);
        this.matterStorage.setMaxExtract(128);
        this.taskQueueProcessing = new MatterNetworkTaskQueue(this, 1);
        this.timeTracker = new TimeTracker();
        this.playerSlotsMain = true;
        this.playerSlotsHotbar = true;
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        this.OUTPUT_SLOT_ID = inventory.AddSlot(new RemoveOnlySlot(false).setSendToClient(true));
        this.SECOND_OUTPUT_SLOT_ID = inventory.AddSlot(new RemoveOnlySlot(false));
        this.DATABASE_SLOT_ID = inventory.AddSlot(new DatabaseSlot(true));
        this.SHIELDING_SLOT_ID = inventory.AddSlot(new ShieldingSlot(true));
        super.RegisterSlots(inventory);
    }

    @Override
    protected void registerComponents() {
        super.registerComponents();
        this.componentMatterNetworkConfigs = new ComponentMatterNetworkConfigs(this);
        this.networkComponent = new MatterNetworkComponentReplicator(this);
        this.addComponent(this.componentMatterNetworkConfigs);
        this.addComponent(this.networkComponent);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.manageReplicate();
        if (this.field_145850_b.field_72995_K) {
            this.manageSpawnParticles();
        }
    }

    protected void manageReplicate() {
        if (this.isActive()) {
            ItemStack newItem = this.internalPatternStorage.toItemStack(false);
            int time = this.getSpeed(newItem);
            if (!this.field_145850_b.field_72995_K) {
                if (((MatterNetworkTaskReplicatePattern)this.taskQueueProcessing.peek()).isValid(this.field_145850_b)) {
                    if (this.energyStorage.getEnergyStored() >= this.getEnergyDrainPerTick()) {
                        ((MatterNetworkTaskReplicatePattern)this.taskQueueProcessing.peek()).setState(MatterNetworkTaskState.PROCESSING);
                        ++this.replicateTime;
                        this.extractEnergy(ForgeDirection.DOWN, this.getEnergyDrainPerTick(), false);
                        if (this.replicateTime >= time) {
                            this.replicateTime = 0;
                            this.replicateItem(this.internalPatternStorage, newItem);
                            MatterOverdrive.packetPipeline.sendToDimention((IMessage)new PacketReplicationComplete(this), this.field_145850_b);
                            SoundHandler.PlaySoundAt(this.field_145850_b, "replicate_success", this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.25f * this.getBlockType(BlockReplicator.class).replication_volume, 1.0f, 0.2f, 0.8f);
                        }
                        if (this.timeTracker.hasDelayPassed(this.field_145850_b, 5)) {
                            this.manageRadiation();
                        }
                        this.replicateProgress = (float)this.replicateTime / (float)time;
                    }
                } else {
                    this.taskQueueProcessing.dequeue();
                }
            } else if (this.getBlockType(BlockReplicator.class).hasVentParticles) {
                this.SpawnVentParticles(0.05f, ForgeDirection.getOrientation((int)MOBlockHelper.getLeftSide(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e))), 1);
                this.SpawnVentParticles(0.05f, ForgeDirection.getOrientation((int)MOBlockHelper.getRightSide(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e))), 1);
            }
        } else {
            this.replicateTime = 0;
            this.replicateProgress = 0.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void beginSpawnParticles() {
        this.replicateAnimationCounter = 60;
    }

    @SideOnly(value=Side.CLIENT)
    public void manageSpawnParticles() {
        if (this.replicateAnimationCounter > 0) {
            this.isPlayingReplicateAnimation = true;
            this.SpawnReplicateParticles(60 - this.replicateAnimationCounter);
            --this.replicateAnimationCounter;
        } else if (this.isPlayingReplicateAnimation) {
            this.isPlayingReplicateAnimation = false;
            this.forceSync();
        }
    }

    private void replicateItem(ItemPattern itemPattern, ItemStack newItem) {
        if (this.isActive()) {
            int matterAmount = MatterHelper.getMatterAmountFromItem(newItem);
            float chance = random.nextFloat();
            if ((double)chance < this.getFailChance(itemPattern)) {
                if (this.failReplicate(MatterHelper.getMatterAmountFromItem(newItem))) {
                    int matter = this.matterStorage.getMatterStored();
                    this.setMatterStored(matter - matterAmount);
                    return;
                }
            } else if (this.putInOutput(newItem)) {
                MatterOverdrive.proxy.getGoogleAnalytics().sendEventHit("Machines", "Replicate", newItem.func_77977_a(), null);
                int matter = this.matterStorage.getMatterStored();
                this.setMatterStored(matter - matterAmount);
                MatterNetworkTaskReplicatePattern task = (MatterNetworkTaskReplicatePattern)this.taskQueueProcessing.peek();
                task.getPattern().setCount(task.getPattern().getCount() - 1);
                if (task.getPattern().getCount() <= 0) {
                    task.setState(MatterNetworkTaskState.FINISHED);
                    this.taskQueueProcessing.dequeue();
                }
            }
        }
    }

    private boolean putInOutput(ItemStack item) {
        int newStackSize;
        if (this.func_70301_a(this.OUTPUT_SLOT_ID) == null) {
            this.func_70299_a(this.OUTPUT_SLOT_ID, item);
            return true;
        }
        if (this.func_70301_a(this.OUTPUT_SLOT_ID).func_77985_e() && this.func_70301_a(this.OUTPUT_SLOT_ID).func_77960_j() == item.func_77960_j() && this.func_70301_a(this.OUTPUT_SLOT_ID).func_77973_b() == item.func_77973_b() && (newStackSize = this.func_70301_a((int)this.OUTPUT_SLOT_ID).field_77994_a + 1) <= this.func_70301_a(this.OUTPUT_SLOT_ID).func_77976_d()) {
            this.func_70301_a((int)this.OUTPUT_SLOT_ID).field_77994_a = newStackSize;
            return true;
        }
        return false;
    }

    private boolean failReplicate(int amount) {
        ItemStack stack = this.func_70301_a(this.SECOND_OUTPUT_SLOT_ID);
        if (stack == null) {
            stack = new ItemStack((Item)MatterOverdriveItems.matter_dust);
            MatterOverdriveItems.matter_dust.setMatter(stack, amount);
            this.func_70299_a(this.SECOND_OUTPUT_SLOT_ID, stack);
            return true;
        }
        if (this.canReplicateIntoSecoundOutput(amount)) {
            ++stack.field_77994_a;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void SpawnReplicateParticles(int startTime) {
        double time = (double)startTime / 60.0;
        double gravity = MOMathHelper.easeIn(time, 0.02, 0.2, 1.0);
        int age = (int)Math.round(MOMathHelper.easeIn(time, 2.0, 10.0, 1.0));
        int count = (int)Math.round(MOMathHelper.easeIn(time, 1.0, 20.0, 1.0));
        for (int i = 0; i < count; ++i) {
            float speed = 0.05f;
            Vector3f pos = MOMathHelper.randomSpherePoint((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5), this.field_145850_b.field_73012_v);
            Vector3f dir = new Vector3f(random.nextFloat() * 2.0f - 1.0f, (random.nextFloat() * 2.0f - 1.0f) * 0.05f, random.nextFloat() * 2.0f - 1.0f);
            dir.scale(speed);
            ReplicatorParticle replicatorParticle = new ReplicatorParticle(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), dir.getX(), dir.getY(), dir.getZ());
            replicatorParticle.setCenter((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
            replicatorParticle.setParticleAge(age);
            replicatorParticle.setPointGravityScale(gravity);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)replicatorParticle);
        }
    }

    public boolean canCompleteTask() {
        MatterNetworkTaskReplicatePattern task = (MatterNetworkTaskReplicatePattern)this.taskQueueProcessing.peek();
        return task != null && this.internalPatternStorage != null && task.getPattern().equals(this.getInternalPatternStorage());
    }

    @Override
    public boolean getServerActive() {
        if (this.getRedstoneActive() && this.taskQueueProcessing.size() > 0 && this.getInternalPatternStorage() != null && this.canCompleteTask()) {
            ItemStack item = this.getInternalPatternStorage().toItemStack(false);
            int matter = MatterHelper.getMatterAmountFromItem(item);
            return this.getMatterStored() >= matter && this.canReplicateIntoOutput(item) && this.canReplicateIntoSecoundOutput(matter);
        }
        return false;
    }

    public void manageRadiation() {
        int shielding = this.getShielding();
        if (shielding >= 5) {
            return;
        }
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 8), (double)(this.field_145848_d - 8), (double)(this.field_145849_e - 8), (double)(this.field_145851_c + 8), (double)(this.field_145848_d + 8), (double)(this.field_145849_e + 8));
        List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, bb);
        for (Object e : entities) {
            if (!(e instanceof EntityLivingBase)) continue;
            EntityLivingBase l = (EntityLivingBase)e;
            double distance = l.func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) / 8.0;
            distance = MathHelper.func_151237_a((double)distance, (double)0.0, (double)1.0);
            distance = 1.0 - distance;
            PotionEffect[] effects = new PotionEffect[]{new PotionEffect(9, (int)Math.round(Math.pow(5.0, distance *= (double)(5 - shielding))), 0), new PotionEffect(18, (int)Math.round(Math.pow(10.0, distance)), 0), new PotionEffect(17, (int)Math.round(Math.pow(12.0, distance)), 0), new PotionEffect(19, (int)Math.round(Math.pow(5.0, distance)), 0)};
            for (PotionEffect effect : effects) {
                if (effect.func_76459_b() <= 0) continue;
                l.func_70690_d(effect);
            }
        }
    }

    private boolean canReplicateIntoOutput(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (this.func_70301_a(this.OUTPUT_SLOT_ID) == null) {
            return true;
        }
        return itemStack.func_77969_a(this.func_70301_a(this.OUTPUT_SLOT_ID)) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)this.func_70301_a(this.OUTPUT_SLOT_ID)) && this.func_70301_a((int)this.OUTPUT_SLOT_ID).field_77994_a < this.func_70301_a(this.OUTPUT_SLOT_ID).func_77976_d();
    }

    private boolean canReplicateIntoSecoundOutput(int matter) {
        ItemStack stack = this.func_70301_a(this.SECOND_OUTPUT_SLOT_ID);
        if (stack == null) {
            return true;
        }
        return stack.func_77973_b() == MatterOverdriveItems.matter_dust && stack.func_77960_j() == matter && stack.field_77994_a < stack.func_77976_d();
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return type == UpgradeTypes.PowerStorage || type == UpgradeTypes.Speed || type == UpgradeTypes.Fail || type == UpgradeTypes.PowerUsage || type == UpgradeTypes.MatterStorage;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.replicateTime = nbt.func_74765_d("ReplicateTime");
            this.taskQueueProcessing.readFromNBT(nbt);
            if (nbt.func_74764_b("InternalPattern")) {
                this.internalPatternStorage = new ItemPattern(nbt.func_74775_l("InternalPattern"));
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeCustomNBT(nbt, categories, toDisk);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            nbt.func_74777_a("ReplicateTime", (short)this.replicateTime);
            this.taskQueueProcessing.writeToNBT(nbt);
            if (this.internalPatternStorage != null) {
                NBTTagCompound patternNBT = new NBTTagCompound();
                this.internalPatternStorage.writeToNBT(patternNBT);
                nbt.func_74782_a("InternalPattern", (NBTBase)patternNBT);
            }
        }
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{this.OUTPUT_SLOT_ID, this.SECOND_OUTPUT_SLOT_ID};
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return true;
    }

    @Override
    public ItemStack func_70298_a(int slot, int size) {
        ItemStack s = super.func_70298_a(slot, size);
        this.forceSync();
        return s;
    }

    @Override
    public boolean canPreform(MatterNetworkPacket packet) {
        return this.networkComponent.canPreform(packet);
    }

    @Override
    public void queuePacket(MatterNetworkPacket packet, ForgeDirection from) {
        this.networkComponent.queuePacket(packet, from);
    }

    public MatterNetworkPacketQueue getPacketQueue(int queueID) {
        return this.networkComponent.getPacketQueue(queueID);
    }

    @Override
    public int getPacketQueueCount() {
        return this.networkComponent.getPacketQueueCount();
    }

    @Override
    public BlockPos getPosition() {
        return new BlockPos(this);
    }

    @Override
    public boolean canConnectFromSide(ForgeDirection side) {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return MOBlockHelper.getOppositeSide(meta) == side.ordinal();
    }

    @Override
    public int onNetworkTick(World world, TickEvent.Phase phase) {
        return this.networkComponent.onNetworkTick(world, phase);
    }

    @Override
    public MatterNetworkTaskQueue<MatterNetworkTaskReplicatePattern> getTaskQueue(int queueID) {
        return this.taskQueueProcessing;
    }

    @Override
    public int getTaskQueueCount() {
        return 1;
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Override
    protected void onAwake(Side side) {
        if (side.isServer()) {
            MatterNetworkHelper.broadcastConnection(this.field_145850_b, this);
        }
    }

    @Override
    protected void onActiveChange() {
    }

    @Override
    @Optional.Method(modid="Waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        MatterNetworkTaskReplicatePattern task;
        List<String> list = super.getWailaBody(itemStack, currenttip, accessor, config);
        if (accessor.getTileEntity() instanceof TileEntityMachineReplicator && (task = (MatterNetworkTaskReplicatePattern)((TileEntityMachineReplicator)accessor.getTileEntity()).getTaskQueue(0).peek()) != null) {
            ItemStack pattern = task.getPattern().toItemStack(false);
            list.add(EnumChatFormatting.YELLOW + String.format("Replicating %s", pattern.func_82833_r()));
        }
        return list;
    }

    public ItemPattern getInternalPatternStorage() {
        return this.internalPatternStorage;
    }

    public void setInternalPatternStorage(ItemPattern internalPatternStorage) {
        this.internalPatternStorage = internalPatternStorage;
    }

    private int getShielding() {
        if (this.func_70301_a(this.SHIELDING_SLOT_ID) != null && this.func_70301_a(this.SHIELDING_SLOT_ID).func_77973_b() == MatterOverdriveItems.tritanium_plate) {
            return this.func_70301_a((int)this.SHIELDING_SLOT_ID).field_77994_a;
        }
        return 0;
    }

    @Override
    public String getSound() {
        return "machine";
    }

    @Override
    public boolean hasSound() {
        return true;
    }

    @Override
    public float soundVolume() {
        return 1.0f;
    }

    public int getSpeed(ItemStack itemStack) {
        double matter = Math.log1p(MatterHelper.getMatterAmountFromItem(itemStack));
        matter *= matter;
        return (int)Math.round(((double)REPLICATE_SPEED_PER_MATTER * matter - 60.0) * this.getUpgradeMultiply(UpgradeTypes.Speed)) + 60;
    }

    public double getFailChance(ItemPattern itemPattern) {
        double progressChance = 1.0f - itemPattern.getProgressF();
        double upgradeMultiply = this.getUpgradeMultiply(UpgradeTypes.Fail);
        return 0.005 * upgradeMultiply + progressChance * 0.5 + progressChance * 0.5 * upgradeMultiply;
    }

    public int getEnergyDrainPerTick() {
        int maxEnergy = this.getEnergyDrainMax();
        return maxEnergy / this.getSpeed(this.internalPatternStorage.toItemStack(false));
    }

    public int getEnergyDrainMax() {
        int matter = MatterHelper.getMatterAmountFromItem(this.internalPatternStorage.toItemStack(false));
        double upgradeMultiply = this.getUpgradeMultiply(UpgradeTypes.PowerUsage);
        return (int)Math.round((double)(matter * REPLICATE_ENERGY_PER_MATTER) * upgradeMultiply);
    }

    public boolean canCompleteTask(MatterNetworkTaskReplicatePattern taskReplicatePattern) {
        return taskReplicatePattern != null && this.internalPatternStorage != null && taskReplicatePattern.getPattern().equals(this.getInternalPatternStorage()) && taskReplicatePattern.isValid(this.field_145850_b);
    }

    @Override
    public NBTTagCompound getFilter() {
        return this.componentMatterNetworkConfigs.getFilter();
    }

    @Override
    public float getProgress() {
        return this.replicateProgress;
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public int getTaskReplicateCount() {
        if (this.taskQueueProcessing.peek() != null) {
            return ((MatterNetworkTaskReplicatePattern)this.taskQueueProcessing.peek()).getPattern().getCount();
        }
        return 0;
    }
}

