/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cpw.mods.fml.relauncher.Side;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import matteroverdrive.util.MOEnergyHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineSolarPanel
extends MOTileEntityMachineEnergy {
    public static final int CHARGE_AMOUNT = 16;
    public static final int ENERGY_STORAGE = 64000;
    public static final int MAX_ENERGY_EXTRACT = 512;
    private byte chargeAmount;

    public TileEntityMachineSolarPanel() {
        super(2);
        this.energyStorage.setCapacity(64000);
        this.energyStorage.setMaxExtract(512);
        this.energyStorage.setMaxReceive(0);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.manageExtract();
            this.manageChagrgeAmount();
        }
        super.func_145845_h();
    }

    @Override
    protected void onAwake(Side side) {
    }

    @Override
    protected void manageCharging() {
        if (!this.field_145850_b.field_72995_K && this.isActive() && this.energyStorage.getEnergyStored() < this.energyStorage.getMaxEnergyStored()) {
            int energy = this.energyStorage.getEnergyStored();
            if ((energy = MathHelper.func_76125_a((int)(energy + this.getChargeAmount()), (int)0, (int)this.energyStorage.getMaxEnergyStored())) != this.energyStorage.getEnergyStored()) {
                this.UpdateClientPower();
            }
            this.energyStorage.setEnergyStored(energy);
        }
    }

    @Override
    public boolean getServerActive() {
        if (!this.field_145850_b.field_73011_w.field_76576_e) {
            int i1 = this.field_145850_b.func_72972_b(EnumSkyBlock.Sky, this.field_145851_c, this.field_145848_d, this.field_145849_e) - this.field_145850_b.field_73008_k;
            float time = this.getTime();
            if (i1 >= 15 && (double)time > 0.5) {
                return true;
            }
        }
        return false;
    }

    public void manageExtract() {
        int energy = this.energyStorage.getEnergyStored();
        if (energy > 0) {
            for (int i = 0; i < 6; ++i) {
                int energyToTransfer = Math.min(energy, 512);
                if (energyToTransfer <= 0) continue;
                energy -= MOEnergyHelper.insertEnergyIntoAdjacentEnergyReceiver(this, i, energyToTransfer, false);
            }
            this.energyStorage.setEnergyStored(energy);
        }
    }

    public void manageChagrgeAmount() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.field_145850_b.field_73011_w.field_76576_e) {
                float f = 0.0f;
                int i1 = this.field_145850_b.func_72972_b(EnumSkyBlock.Sky, this.field_145851_c, this.field_145848_d, this.field_145849_e) - this.field_145850_b.field_73008_k;
                if (i1 >= 15) {
                    f = this.getTime();
                }
                this.chargeAmount = (byte)Math.round(16.0f * f);
            } else {
                this.chargeAmount = 0;
            }
        }
    }

    public float getTime() {
        float f = this.field_145850_b.func_72929_e(1.0f);
        f = f < (float)Math.PI ? (f += (0.0f - f) * 0.2f) : (f += ((float)Math.PI * 2 - f) * 0.2f);
        return (float)Math.cos(f);
    }

    public byte getChargeAmount() {
        return this.chargeAmount;
    }

    public void setChargeAmount(byte chargeAmount) {
        this.chargeAmount = chargeAmount;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from == ForgeDirection.DOWN;
    }

    @Override
    public String getSound() {
        return null;
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    @Override
    protected void onActiveChange() {
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return type == UpgradeTypes.PowerStorage;
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }
}

