/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile.pipes;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class MatterTransfer {
    public static final String LIFE_KEY = "transfer_life";
    public static final String DIRECTION_KEY = "transfer_direction";
    public static final String MATTER_AMOUNT_KEY = "transfer_matter";
    public ForgeDirection dir = ForgeDirection.values()[0];
    public int amount = 0;
    public int life = 0;

    private MatterTransfer() {
    }

    public MatterTransfer(ForgeDirection dir, int amount, int life) {
        this.dir = dir;
        this.amount = amount;
        this.life = life;
    }

    public void writeToNBT(NBTTagCompound tag) {
        if (tag != null) {
            tag.func_74768_a(MATTER_AMOUNT_KEY, this.amount);
            tag.func_74774_a(DIRECTION_KEY, (byte)this.dir.ordinal());
            tag.func_74768_a(LIFE_KEY, this.life);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag != null) {
            byte dirId;
            if (tag.func_150297_b(MATTER_AMOUNT_KEY, 3)) {
                this.amount = tag.func_74762_e(MATTER_AMOUNT_KEY);
            }
            if (tag.func_150297_b(DIRECTION_KEY, 1) && (dirId = tag.func_74771_c(DIRECTION_KEY)) < ForgeDirection.values().length) {
                this.dir = ForgeDirection.values()[dirId];
            }
            if (tag.func_150297_b(LIFE_KEY, 3)) {
                this.life = tag.func_74762_e(LIFE_KEY);
            }
        }
    }

    public static MatterTransfer loadMatterTransferFromNBT(NBTTagCompound comp) {
        if (comp != null) {
            MatterTransfer t = new MatterTransfer();
            t.readFromNBT(comp);
        }
        return null;
    }
}

