/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MOInventoryHelper {
    public static void setInventorySlotContents(ItemStack container, int slot, ItemStack stack) {
        if (stack == null) {
            if (!container.func_77942_o()) {
                container.func_77982_d(new NBTTagCompound());
            }
            container.func_77978_p().func_74782_a("Slot" + slot, (NBTBase)new NBTTagCompound());
        } else {
            NBTTagCompound itemTag = new NBTTagCompound();
            stack.func_77955_b(itemTag);
            if (!container.func_77942_o()) {
                container.func_77982_d(new NBTTagCompound());
            }
            container.func_77978_p().func_74782_a("Slot" + slot, (NBTBase)itemTag);
        }
    }

    public static ItemStack decrStackSize(ItemStack container, int slot, int amount) {
        if (container.func_77978_p().func_74775_l("Slot" + slot) == null || container.func_77978_p().func_74775_l("Slot" + slot).func_82582_d()) {
            return null;
        }
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)container.func_77978_p().func_74775_l("Slot" + slot));
        ItemStack retStack = stack.func_77979_a(amount);
        if (stack.field_77994_a <= 0) {
            container.func_77978_p().func_74782_a("Slot" + slot, (NBTBase)new NBTTagCompound());
        } else {
            NBTTagCompound itemTag = new NBTTagCompound();
            stack.func_77955_b(itemTag);
            container.func_77978_p().func_74782_a("Slot" + slot, (NBTBase)itemTag);
        }
        return retStack;
    }

    public static ItemStack getStackInSlot(ItemStack container, int slot) {
        if (!container.func_77942_o() || container.func_77978_p().func_74775_l("Slot" + slot) == null || container.func_77978_p().func_74775_l("Slot" + slot).func_82582_d()) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)container.func_77978_p().func_74775_l("Slot" + slot));
    }

    public static List<ItemStack> getStacks(ItemStack container) {
        if (!container.func_77942_o()) {
            return null;
        }
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (String s : container.func_77978_p().func_150296_c()) {
            NBTBase nbtbase;
            if (!s.startsWith("Slot") || !((nbtbase = container.func_77978_p().func_74781_a(s)) instanceof NBTTagCompound)) continue;
            itemStacks.add(ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nbtbase)));
        }
        return itemStacks;
    }

    public static ItemStack addItemInContainer(Container container, ItemStack itemStack) {
        for (int i = 0; i < container.field_75151_b.size(); ++i) {
            if (!container.func_75139_a(i).func_75214_a(itemStack)) continue;
            if (container.func_75139_a(i).func_75211_c() == null) {
                container.func_75139_a(i).func_75215_d(itemStack);
                if (itemStack.field_77994_a > itemStack.func_77976_d()) {
                    itemStack.field_77994_a = itemStack.func_77976_d();
                    continue;
                }
                return null;
            }
            if (!ItemStack.func_77989_b((ItemStack)container.func_75139_a(i).func_75211_c(), (ItemStack)itemStack) || container.func_75139_a((int)i).func_75211_c().field_77994_a >= container.func_75139_a(i).func_75211_c().func_77976_d()) continue;
            int newStackSize = Math.min(container.func_75139_a((int)i).func_75211_c().field_77994_a + itemStack.field_77994_a, container.func_75139_a(i).func_75211_c().func_77976_d());
            int leftStackSize = container.func_75139_a((int)i).func_75211_c().field_77994_a + itemStack.field_77994_a - newStackSize;
            container.func_75139_a((int)i).func_75211_c().field_77994_a = newStackSize;
            if (leftStackSize <= 0) {
                return null;
            }
            itemStack.field_77994_a = newStackSize;
        }
        return itemStack;
    }

    public static ItemStack insertItemStackIntoInventory(IInventory inventory, ItemStack itemStack, int side) {
        if (itemStack != null && inventory != null) {
            int var3 = itemStack.field_77994_a;
            if (inventory instanceof ISidedInventory) {
                int var6;
                ISidedInventory var4 = (ISidedInventory)inventory;
                int[] var5 = var4.func_94128_d(side);
                if (var5 == null) {
                    return itemStack;
                }
                for (var6 = 0; var6 < var5.length && itemStack != null; ++var6) {
                    ItemStack var7;
                    if (!var4.func_102007_a(var5[var6], itemStack, side) || !ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)(var7 = inventory.func_70301_a(var5[var6])))) continue;
                    itemStack = MOInventoryHelper.addToOccupiedInventorySlot((IInventory)var4, var5[var6], itemStack, var7);
                }
                for (var6 = 0; var6 < var5.length && itemStack != null; ++var6) {
                    if (inventory.func_70301_a(var5[var6]) != null || !var4.func_102007_a(var5[var6], itemStack, side)) continue;
                    itemStack = MOInventoryHelper.addToEmptyInventorySlot((IInventory)var4, var5[var6], itemStack);
                }
            } else {
                int var9;
                int var8 = inventory.func_70302_i_();
                for (var9 = 0; var9 < var8 && itemStack != null; ++var9) {
                    ItemStack var10 = inventory.func_70301_a(var9);
                    if (!ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)var10)) continue;
                    itemStack = MOInventoryHelper.addToOccupiedInventorySlot(inventory, var9, itemStack, var10);
                }
                for (var9 = 0; var9 < var8 && itemStack != null; ++var9) {
                    if (inventory.func_70301_a(var9) != null) continue;
                    itemStack = MOInventoryHelper.addToEmptyInventorySlot(inventory, var9, itemStack);
                }
            }
            if (itemStack == null || itemStack.field_77994_a != var3) {
                inventory.func_70296_d();
            }
            return itemStack;
        }
        return null;
    }

    public static ItemStack addToOccupiedInventorySlot(IInventory inventory, int slot, ItemStack one, ItemStack two) {
        int maxSize = Math.min(inventory.func_70297_j_(), one.func_77976_d());
        if (one.field_77994_a + two.field_77994_a > maxSize) {
            int remanningSize = maxSize - two.field_77994_a;
            two.field_77994_a = maxSize;
            one.field_77994_a -= remanningSize;
            inventory.func_70299_a(slot, two);
            return one;
        }
        two.field_77994_a += Math.min(one.field_77994_a, maxSize);
        inventory.func_70299_a(slot, two);
        return maxSize >= one.field_77994_a ? null : one.func_77979_a(one.field_77994_a - maxSize);
    }

    public static ItemStack addToEmptyInventorySlot(IInventory inventory, int slot, ItemStack itemStack) {
        if (!inventory.func_94041_b(slot, itemStack)) {
            return itemStack;
        }
        int inventoryStackLimit = inventory.func_70297_j_();
        ItemStack newItemStack = ItemStack.func_77944_b((ItemStack)itemStack);
        newItemStack.field_77994_a = Math.min(itemStack.field_77994_a, inventoryStackLimit);
        inventory.func_70299_a(slot, newItemStack);
        return inventoryStackLimit >= itemStack.field_77994_a ? null : itemStack.func_77979_a(itemStack.field_77994_a - inventoryStackLimit);
    }

    public static boolean mergeItemStack(List<Slot> var0, ItemStack var1, int var2, int var3, boolean var4) {
        return MOInventoryHelper.mergeItemStack(var0, var1, var2, var3, var4, true);
    }

    public static boolean mergeItemStack(List<Slot> slots, ItemStack itemStack, int var2, int var3, boolean var4, boolean var5) {
        int var11;
        ItemStack var10;
        Slot var9;
        int var7;
        int var8;
        boolean var6 = false;
        int n = var8 = !var4 ? 1 : -1;
        if (itemStack.func_77985_e()) {
            for (var7 = !var4 ? var2 : var3 - 1; itemStack.field_77994_a > 0 && (!var4 && var7 < var3 || var4 && var7 >= var2); var7 += var8) {
                var9 = slots.get(var7);
                var10 = var9.func_75211_c();
                if (!var9.func_75214_a(itemStack) || var10 == null || !var10.func_77973_b().equals(itemStack.func_77973_b()) || itemStack.func_77981_g() && itemStack.func_77960_j() != var10.func_77960_j() || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)var10)) continue;
                var11 = var10.field_77994_a + itemStack.field_77994_a;
                int var12 = Math.min(itemStack.func_77976_d(), var9.func_75219_a());
                if (var11 <= var12) {
                    itemStack.field_77994_a = 0;
                    var10.field_77994_a = var11;
                    var9.func_75218_e();
                    var6 = true;
                    continue;
                }
                if (var10.field_77994_a >= var12) continue;
                itemStack.field_77994_a -= var12 - var10.field_77994_a;
                var10.field_77994_a = var12;
                var9.func_75218_e();
                var6 = true;
            }
        }
        if (itemStack.field_77994_a > 0) {
            int n2 = var7 = !var4 ? var2 : var3 - 1;
            while (itemStack.field_77994_a > 0 && (!var4 && var7 < var3 || var4 && var7 >= var2)) {
                var9 = slots.get(var7);
                var10 = var9.func_75211_c();
                if (var9.func_75214_a(itemStack) && var10 == null) {
                    var11 = var5 ? Math.min(itemStack.func_77976_d(), var9.func_75219_a()) : var9.func_75219_a();
                    var10 = itemStack.func_77979_a(Math.min(itemStack.field_77994_a, var11));
                    var9.func_75215_d(var10);
                    var9.func_75218_e();
                    var6 = true;
                }
                var7 += var8;
            }
        }
        return var6;
    }
}

