/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import java.util.Random;
import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.api.matter.IMatterPatternStorage;
import matteroverdrive.data.ItemPattern;
import matteroverdrive.util.MatterHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class MatterDatabaseHelper {
    public static final int MAX_ITEM_PROGRESS = 100;
    public static final String PROGRESS_TAG_NAME = "scan_progress";
    public static final String ITEMS_TAG_NAME = "items";
    public static final String CAPACITY_TAG_NAME = "Capacity";

    public static void initTagCompound(ItemStack scanner) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        scanner.func_77982_d(tagCompound);
        MatterDatabaseHelper.initItemListTagCompound(scanner);
    }

    public static void initItemListTagCompound(ItemStack scanner) {
        NBTTagList items = new NBTTagList();
        scanner.func_77983_a(ITEMS_TAG_NAME, (NBTBase)items);
    }

    public static int getPatternCapacity(ItemStack storage) {
        if (storage.func_77978_p() != null) {
            return storage.func_77978_p().func_74765_d(CAPACITY_TAG_NAME);
        }
        return 0;
    }

    public static boolean hasFreeSpace(ItemStack storage) {
        ItemPattern[] patterns;
        return storage != null && MatterHelper.isMatterPatternStorage(storage) && (patterns = MatterDatabaseHelper.getPatternsFromStorage(storage)).length < MatterDatabaseHelper.getPatternCapacity(storage);
    }

    public static ItemStack getFirstFreePatternStorage(IMatterDatabase database) {
        ItemStack[] patternStorages = database.getPatternStorageList();
        for (int i = 0; i < patternStorages.length; ++i) {
            if (patternStorages[i] == null || !MatterDatabaseHelper.hasFreeSpace(patternStorages[i])) continue;
            return patternStorages[i];
        }
        return null;
    }

    public static boolean HasItem(ItemStack storage, ItemStack item) {
        ItemPattern[] patterns = MatterDatabaseHelper.getPatternsFromStorage(storage);
        for (int i = 0; i < patterns.length; ++i) {
            if (!MatterDatabaseHelper.areEqual(item, patterns[i].toItemStack(false))) continue;
            return true;
        }
        return false;
    }

    public static void addProgressToPatternStorage(ItemStack patternStorage, ItemStack item, int progress, boolean existingOnly) {
        if (!patternStorage.func_77942_o()) {
            MatterDatabaseHelper.initItemListTagCompound(patternStorage);
        }
        NBTTagList patternsTagList = patternStorage.func_77978_p().func_150295_c(ITEMS_TAG_NAME, 10);
        for (int i = 0; i < patternsTagList.func_74745_c(); ++i) {
            ItemPattern pattern = new ItemPattern(patternsTagList.func_150305_b(i));
            if (!MatterDatabaseHelper.areEqual(pattern.toItemStack(false), item)) continue;
            byte oldProgress = patternsTagList.func_150305_b(i).func_74771_c(PROGRESS_TAG_NAME);
            patternsTagList.func_150305_b(i).func_74774_a(PROGRESS_TAG_NAME, (byte)MathHelper.func_76125_a((int)(oldProgress + progress), (int)0, (int)100));
            return;
        }
        if (!existingOnly) {
            ItemPattern pattern = new ItemPattern(item, progress);
            NBTTagCompound patternTag = new NBTTagCompound();
            pattern.writeToNBT(patternTag);
            patternsTagList.func_74742_a((NBTBase)patternTag);
        }
    }

    public static int getItemStackProgress(ItemStack storage, ItemStack item) {
        ItemPattern itemPattern = MatterDatabaseHelper.getPatternFromStorage(storage, item);
        if (itemPattern != null) {
            return itemPattern.getProgress();
        }
        return -1;
    }

    public static ItemPattern getPatternFromStorage(ItemStack patternStorage, ItemStack item) {
        ItemPattern[] patterns = MatterDatabaseHelper.getPatternsFromStorage(patternStorage);
        for (int i = 0; i < patterns.length; ++i) {
            if (!MatterDatabaseHelper.areEqual(item, patterns[i].toItemStack(false))) continue;
            return patterns[i];
        }
        return null;
    }

    public static ItemPattern getPatternWithItemID(ItemStack patternStorage, int id) {
        ItemPattern[] patterns = MatterDatabaseHelper.getPatternsFromStorage(patternStorage);
        for (int i = 0; i < patterns.length; ++i) {
            if (patterns[i].getItemID() != id) continue;
            return patterns[i];
        }
        return null;
    }

    private static ItemPattern getPatternAt(ItemStack patternStorage, int index) {
        ItemPattern[] itemPattern = MatterDatabaseHelper.getPatternsFromStorage(patternStorage);
        return itemPattern[index];
    }

    public static boolean areEqual(ItemStack one, ItemStack two) {
        if (one != null && two != null && one.func_77973_b() == two.func_77973_b()) {
            if (one.func_77981_g() && two.func_77981_g()) {
                if (one.func_77960_j() == two.func_77960_j()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static boolean areEqual(NBTTagCompound one, NBTTagCompound two) {
        if (one == null || two == null) {
            return false;
        }
        return MatterDatabaseHelper.areEqual(ItemStack.func_77949_a((NBTTagCompound)one), ItemStack.func_77949_a((NBTTagCompound)two));
    }

    public static ItemPattern[] getPatternsFromStorage(ItemStack patternStorage) {
        if (patternStorage.func_77973_b() instanceof IMatterPatternStorage) {
            return ((IMatterPatternStorage)patternStorage.func_77973_b()).getPatterns(patternStorage);
        }
        return null;
    }

    public static ItemStack GetItemStackFromWorld(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b != null) {
            int meta = world.func_72805_g(x, y, z);
            if (b == Blocks.field_150465_bP) {
                TileEntity te = world.func_147438_o(x, y, z);
                meta = ((TileEntitySkull)te).func_145904_a();
                return new ItemStack(b.func_149650_a(meta, new Random(), 0), 1, meta);
            }
            return new ItemStack(b, 1, b.func_149692_a(meta));
        }
        return new ItemStack(b);
    }

    public static EnumChatFormatting getPatternInfoColor(int progress) {
        EnumChatFormatting color = EnumChatFormatting.GRAY;
        color = progress > 0 && progress <= 20 ? EnumChatFormatting.RED : (progress > 20 && progress <= 40 ? EnumChatFormatting.GOLD : (progress > 40 && progress <= 60 ? EnumChatFormatting.YELLOW : (progress > 40 && progress <= 80 ? EnumChatFormatting.AQUA : (progress > 80 && progress <= 100 ? EnumChatFormatting.GREEN : EnumChatFormatting.GREEN))));
        return color;
    }
}

