/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.quest.IQuest;
import matteroverdrive.api.quest.QuestStack;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;

public class QuestFactory {
    public QuestStack generateQuestStack(Random random, IQuest quest) {
        QuestStack questStack = new QuestStack(quest);
        quest.initQuestStack(random, questStack);
        return questStack;
    }

    @SideOnly(value=Side.CLIENT)
    public String getFormattedQuestObjective(EntityPlayer entityPlayer, QuestStack questStack, int objectiveInex) {
        boolean isCompleted = questStack.isObjectiveCompleted(entityPlayer, objectiveInex);
        if (isCompleted) {
            return EnumChatFormatting.GREEN + "\u25a0" + " " + questStack.getObjective(entityPlayer, objectiveInex);
        }
        return EnumChatFormatting.DARK_GREEN + "\u25a1" + " " + questStack.getObjective(entityPlayer, objectiveInex);
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getFormattedQuestObjective(EntityPlayer entityPlayer, QuestStack questStack, int objectiveInex, int length) {
        List objectiveLines = Minecraft.func_71410_x().field_71466_p.func_78271_c(questStack.getObjective(entityPlayer, objectiveInex), length);
        boolean isObjectiveComplete = questStack.isObjectiveCompleted((EntityPlayer)Minecraft.func_71410_x().field_71439_g, objectiveInex);
        for (int o = 0; o < objectiveLines.size(); ++o) {
            String line = "";
            if (isObjectiveComplete) {
                line = line + EnumChatFormatting.GREEN;
                if (o == 0) {
                    line = line + "\u25a0 ";
                }
            } else {
                line = line + EnumChatFormatting.DARK_GREEN;
                if (o == 0) {
                    line = line + "\u25a1 ";
                }
            }
            line = line + (String)objectiveLines.get(o);
            objectiveLines.set(o, line);
        }
        return objectiveLines;
    }

    public QuestStack generateQuestStack(String questName) {
        IQuest quest = MatterOverdrive.quests.getQuestByName(questName);
        if (quest != null) {
            QuestStack questStack = new QuestStack(quest);
            quest.initQuestStack(MatterOverdrive.quests.random, questStack);
            return questStack;
        }
        return null;
    }
}

