/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util.animation;

import java.util.ArrayList;
import java.util.List;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.util.MathHelper;

public class MOAnimationTimeline {
    boolean autoLength;
    boolean isPlaying;
    List<Slice> slices = new ArrayList<Slice>();
    private float maxTime;
    private boolean repeat;
    private float time;
    private float defaultValue;

    public MOAnimationTimeline(float maxTime, boolean repeat, boolean autoPlay, float defaultValue) {
        this.maxTime = maxTime;
        this.repeat = repeat;
        this.isPlaying = autoPlay;
        this.defaultValue = defaultValue;
    }

    public void addSlice(Slice slice) {
        this.slices.add(slice);
    }

    public void getActiveSlices(int time, List<Slice> list) {
        for (Slice slice : this.slices) {
            if (!((float)time <= slice.from + slice.length) || !((float)time >= slice.from)) continue;
            list.add(slice);
        }
    }

    public List<Slice> getActiveSlices(int time) {
        ArrayList<Slice> slices = new ArrayList<Slice>();
        this.getActiveSlices(time, slices);
        return slices;
    }

    public float getValueAt(float time) {
        float value = this.defaultValue;
        for (Slice slice : this.slices) {
            if (!(time <= slice.from + slice.length) || !(time >= slice.from)) continue;
            float localTime = slice.getLocalTime(time);
            value = slice.valueFrom + localTime * (slice.valueTo - slice.valueFrom);
        }
        return value;
    }

    public void recalculateTime() {
        if (this.autoLength) {
            float maxTime = 0.0f;
            for (Slice slice : this.slices) {
                if (!(slice.from + slice.length > this.time)) continue;
                maxTime = slice.from + slice.length;
            }
            this.maxTime = maxTime;
        }
    }

    public float getCurrentValue() {
        return this.getValueAt(this.time);
    }

    public void play() {
        this.recalculateTime();
        this.isPlaying = true;
        if (this.time >= this.maxTime) {
            this.time = 0.0f;
        }
    }

    public void replay() {
        this.time = 0.0f;
        this.play();
    }

    public void stop() {
        this.recalculateTime();
        this.isPlaying = false;
        this.time = 0.0f;
    }

    public void pause() {
        this.isPlaying = false;
    }

    public void tick() {
        this.tick(1.0f);
    }

    public void tick(float tick) {
        if (this.isPlaying) {
            if (this.time < this.maxTime) {
                this.time = MathHelper.func_76131_a((float)(this.time + tick), (float)0.0f, (float)this.maxTime);
            } else if (this.repeat) {
                this.time = 0.0f;
            } else {
                this.pause();
            }
        }
    }

    public void sort() {
        float lastFinish = 0.0f;
        for (Slice slice : this.slices) {
            slice.from = lastFinish;
            lastFinish += slice.length;
        }
    }

    public void setTime(float time) {
        this.time = time;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void setAutoLength(boolean autoLength) {
        this.autoLength = true;
    }

    public boolean isAutoLength() {
        return this.autoLength;
    }

    public float getTime() {
        return this.time;
    }

    public float getMaxTime() {
        return this.maxTime;
    }

    public Slice getSlice(int index) {
        return this.slices.get(index);
    }

    public static abstract class Easing {
        public abstract float calculate(float var1, float var2, float var3, float var4);

        public static class QuadEaseInOut
        extends Easing {
            @Override
            public float calculate(float t, float b, float c, float d) {
                float f;
                t /= d / 2.0f;
                if (f < 1.0f) {
                    return c / 2.0f * t * t + b;
                }
                return -c / 2.0f * ((t -= 1.0f) * (t - 2.0f) - 1.0f) + b;
            }
        }

        public static class QuadEaseOut
        extends Easing {
            @Override
            public float calculate(float t, float b, float c, float d) {
                return -c * (t /= d) * (t - 2.0f) + b;
            }
        }

        public static class QuadEaseIn
        extends Easing {
            @Override
            public float calculate(float t, float b, float c, float d) {
                return c * (t /= d) * t + b;
            }
        }
    }

    public static class Slice {
        private float valueFrom;
        private float valueTo;
        private float from;
        private float length;
        private Easing easing;

        public Easing getEasing() {
            return this.easing;
        }

        public void setEasing(Easing easing) {
            this.easing = easing;
        }

        public float getValueFrom() {
            return this.valueFrom;
        }

        public void setValueFrom(float valueFrom) {
            this.valueFrom = valueFrom;
        }

        public float getValueTo() {
            return this.valueTo;
        }

        public void setValueTo(float valueTo) {
            this.valueTo = valueTo;
        }

        public float getFrom() {
            return this.from;
        }

        public void setFrom(float from) {
            this.from = from;
        }

        public float getLength() {
            return this.length;
        }

        public void setLength(float length) {
            this.length = length;
        }

        public Slice(float valueFrom, float valueTo, float from, float length, Easing easing) {
            this.valueFrom = valueFrom;
            this.valueTo = valueTo;
            this.from = from;
            this.length = length;
            this.easing = easing;
        }

        public float getLocalTime(float time) {
            if (this.easing != null) {
                return MathHelper.func_76131_a((float)this.easing.calculate(time - this.from, 0.0f, 1.0f, this.length), (float)0.0f, (float)1.0f);
            }
            return MOMathHelper.Lerp(0.0f, 1.0f, (time - this.from) / this.length);
        }
    }
}

