/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util.math;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class MOMathHelper {
    public static final double PI2 = Math.PI * 2;
    public static double degreesToRadians = Math.PI / 180;
    static final int[] p = new int[512];
    static final int[] permutation = new int[]{151, 160, 137, 91, 90, 15, 131, 13, 201, 95, 96, 53, 194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99, 37, 240, 21, 10, 23, 190, 6, 148, 247, 120, 234, 75, 0, 26, 197, 62, 94, 252, 219, 203, 117, 35, 11, 32, 57, 177, 33, 88, 237, 149, 56, 87, 174, 20, 125, 136, 171, 168, 68, 175, 74, 165, 71, 134, 139, 48, 27, 166, 77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133, 230, 220, 105, 92, 41, 55, 46, 245, 40, 244, 102, 143, 54, 65, 25, 63, 161, 1, 216, 80, 73, 209, 76, 132, 187, 208, 89, 18, 169, 200, 196, 135, 130, 116, 188, 159, 86, 164, 100, 109, 198, 173, 186, 3, 64, 52, 217, 226, 250, 124, 123, 5, 202, 38, 147, 118, 126, 255, 82, 85, 212, 207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42, 223, 183, 170, 213, 119, 248, 152, 2, 44, 154, 163, 70, 221, 153, 101, 155, 167, 43, 172, 9, 129, 22, 39, 253, 19, 98, 108, 110, 79, 113, 224, 232, 178, 185, 112, 104, 218, 246, 97, 228, 251, 34, 242, 193, 238, 210, 144, 12, 191, 179, 162, 241, 81, 51, 145, 235, 249, 14, 239, 107, 49, 192, 214, 31, 181, 199, 106, 157, 184, 84, 204, 176, 115, 121, 50, 45, 127, 4, 150, 254, 138, 236, 205, 93, 222, 114, 67, 29, 24, 72, 243, 141, 128, 195, 78, 66, 215, 61, 156, 180};

    public static Vector3f randomSpherePoint(double x0, double y0, double z0, Vec3 radius, Random rand) {
        double u = rand.nextDouble();
        double v = rand.nextDouble();
        double theta = Math.PI * 2 * u;
        double phi = Math.acos(2.0 * v - 1.0);
        double x = x0 + radius.field_72450_a * Math.sin(phi) * Math.cos(theta);
        double y = y0 + radius.field_72448_b * Math.sin(phi) * Math.sin(theta);
        double z = z0 + radius.field_72449_c * Math.cos(phi);
        return new Vector3f((float)x, (float)y, (float)z);
    }

    public static Vector3f randomCirclePoint(float radius, Random rand) {
        double u = rand.nextDouble();
        double theta = Math.PI * 2 * u;
        double x = (double)radius * Math.sin(theta);
        double z = (double)radius * Math.cos(theta);
        return new Vector3f((float)x, 0.0f, (float)z);
    }

    public static boolean getBoolean(int number, int pos) {
        return (number >> pos & 1) == 1;
    }

    public static double nextGaussian(Random random, double mean, double variance) {
        return mean + random.nextGaussian() * variance;
    }

    @SideOnly(value=Side.CLIENT)
    public static Vec3 mouseToWorldRay(int mouseX, int mouseY, int width, int height) {
        double aspectRatio = (double)width / (double)height;
        double fov = ((double)Minecraft.func_71410_x().field_71474_y.field_74334_X / 2.0 + 11.0) * (Math.PI / 180);
        EntityLivingBase renderViewEntity = Minecraft.func_71410_x().field_71451_h;
        double a = -((double)mouseX / (double)width - 0.5) * 2.0;
        double b = -((double)mouseY / (double)height - 0.5) * 2.0;
        double tanf = Math.tan(fov);
        float yawn = renderViewEntity.field_70177_z;
        float pitch = renderViewEntity.field_70125_A;
        Matrix4f rot = new Matrix4f();
        rot.rotate(yawn * ((float)Math.PI / 180), new Vector3f(0.0f, -1.0f, 0.0f));
        rot.rotate(pitch * ((float)Math.PI / 180), new Vector3f(1.0f, 0.0f, 0.0f));
        Vector4f foward = new Vector4f(0.0f, 0.0f, 1.0f, 0.0f);
        Vector4f up = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f);
        Vector4f left = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f);
        Matrix4f.transform((Matrix4f)rot, (Vector4f)foward, (Vector4f)foward);
        Matrix4f.transform((Matrix4f)rot, (Vector4f)up, (Vector4f)up);
        Matrix4f.transform((Matrix4f)rot, (Vector4f)left, (Vector4f)left);
        return Vec3.func_72443_a((double)foward.x, (double)foward.y, (double)foward.z).func_72441_c((double)left.x * tanf * aspectRatio * a, (double)left.y * tanf * aspectRatio * a, (double)left.z * tanf * aspectRatio * a).func_72441_c((double)up.x * tanf * b, (double)up.y * tanf * b, (double)up.z * tanf * b).func_72432_b();
    }

    public static int setBoolean(int number, int pos, boolean value) {
        if (value) {
            return number | 1 << pos;
        }
        return number & ~(1 << pos);
    }

    public static double easeIn(double t, double b, double c, double d) {
        return c * (t /= d) * t * t * t + b;
    }

    public static int toInt(short leftShort, short rightShort) {
        short leftInt = leftShort;
        short rightInt = rightShort;
        return leftInt | rightInt << 16;
    }

    public static short[] getShorts(int number) {
        return new short[]{(short)(number & 0xFFFFFF), (short)(number >> 16)};
    }

    public static Vector2f Intersects(Vector2f a1, Vector2f a2, Vector2f b1, Vector2f b2) {
        Vector2f b = Vector2f.sub((Vector2f)a2, (Vector2f)a1, null);
        Vector2f d = Vector2f.sub((Vector2f)b2, (Vector2f)b1, null);
        float bDotDPerp = b.x * d.y - b.y * d.x;
        if (bDotDPerp == 0.0f) {
            return null;
        }
        Vector2f c = Vector2f.sub((Vector2f)b1, (Vector2f)a1, null);
        float t = (c.x * d.y - c.y * d.x) / bDotDPerp;
        if (t < 0.0f || t > 1.0f) {
            return null;
        }
        float u = (c.x * b.y - c.y * b.x) / bDotDPerp;
        if (u < 0.0f || u > 1.0f) {
            return null;
        }
        b.scale(t);
        return Vector2f.add((Vector2f)a1, (Vector2f)b, null);
    }

    public static float distance(Vector2f one, Vector2f two) {
        return MathHelper.func_76129_c((float)((one.x - two.x) * (one.x - two.x) + (one.y - two.y) * (one.y - two.y)));
    }

    public static double distance(int x, int y, int z, int x1, int y1, int z1) {
        return Math.sqrt((x - x1) * (x - x1) + (y - y1) * (y - y1) + (z - z1) * (z - z1));
    }

    public static int distanceSqured(int x, int y, int z, int x1, int y1, int z1) {
        return (x - x1) * (x - x1) + (y - y1) * (y - y1) + (z - z1) * (z - z1);
    }

    public static boolean animationInRange(int time, int begin, int length) {
        return time >= begin && time < begin + length;
    }

    public static float Lerp(float form, float to, float time) {
        float newTime = MathHelper.func_76131_a((float)time, (float)0.0f, (float)1.0f);
        return (1.0f - newTime) * form + newTime * to;
    }

    public static double noise(double x, double y, double z) {
        int X = (int)Math.floor(x) & 0xFF;
        int Y = (int)Math.floor(y) & 0xFF;
        int Z = (int)Math.floor(z) & 0xFF;
        x -= Math.floor(x);
        y -= Math.floor(y);
        z -= Math.floor(z);
        double u = MOMathHelper.fade(x);
        double v = MOMathHelper.fade(y);
        double w = MOMathHelper.fade(z);
        int A = p[X] + Y;
        int AA = p[A] + Z;
        int AB = p[A + 1] + Z;
        int B = p[X + 1] + Y;
        int BA = p[B] + Z;
        int BB = p[B + 1] + Z;
        return MOMathHelper.lerp(w, MOMathHelper.lerp(v, MOMathHelper.lerp(u, MOMathHelper.grad(p[AA], x, y, z), MOMathHelper.grad(p[BA], x - 1.0, y, z)), MOMathHelper.lerp(u, MOMathHelper.grad(p[AB], x, y - 1.0, z), MOMathHelper.grad(p[BB], x - 1.0, y - 1.0, z))), MOMathHelper.lerp(v, MOMathHelper.lerp(u, MOMathHelper.grad(p[AA + 1], x, y, z - 1.0), MOMathHelper.grad(p[BA + 1], x - 1.0, y, z - 1.0)), MOMathHelper.lerp(u, MOMathHelper.grad(p[AB + 1], x, y - 1.0, z - 1.0), MOMathHelper.grad(p[BB + 1], x - 1.0, y - 1.0, z - 1.0))));
    }

    static double fade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }

    static double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    static double grad(int hash, double x, double y, double z) {
        double u;
        int h = hash & 0xF;
        double d = u = h < 8 ? x : y;
        double v = h < 4 ? y : (h == 12 || h == 14 ? x : z);
        return ((h & 1) == 0 ? u : -u) + ((h & 2) == 0 ? v : -v);
    }

    public static void shuffleArray(Random rnd, int[] ar) {
        for (int i = ar.length - 1; i > 0; --i) {
            int index = rnd.nextInt(i + 1);
            int a = ar[index];
            ar[index] = ar[i];
            ar[i] = a;
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            MOMathHelper.p[256 + i] = MOMathHelper.p[i] = permutation[i];
        }
    }
}

