/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world;

import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.entity.monster.EntityMeleeRougeAndroidMob;
import matteroverdrive.entity.monster.EntityRangedRogueAndroidMob;
import matteroverdrive.init.MatterOverdriveBlocks;
import matteroverdrive.util.MOInventoryHelper;
import matteroverdrive.util.WeaponFactory;
import matteroverdrive.world.MOWorldGenBuilding;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class MOAndroidHouseBuilding
extends MOWorldGenBuilding {
    public MOAndroidHouseBuilding(String name) {
        super(name, new ResourceLocation("mo:textures/world/android_house.png"), 21, 21);
        this.setyOffset(-2);
        this.addMapping(65532, MatterOverdriveBlocks.decorative_beams, MatterOverdriveBlocks.decorative_carbon_fiber_plate, MatterOverdriveBlocks.decorative_white_plate);
        this.addMapping(6435328, Blocks.field_150346_d);
        this.addMapping(16753152, MatterOverdriveBlocks.decorative_floor_tiles);
        this.addMapping(0xFFF600, MatterOverdriveBlocks.decorative_holo_matrix);
        this.addMapping(8436054, new Block[]{Blocks.field_150349_c});
        this.addMapping(5479107, MatterOverdriveBlocks.decorative_tritanium_plate);
        this.addMapping(11651285, MatterOverdriveBlocks.decorative_floor_noise, MatterOverdriveBlocks.decorative_floor_tiles_green, MatterOverdriveBlocks.decorative_floot_tile_white);
        this.addMapping(6251881, MatterOverdriveBlocks.decorative_vent_dark);
        this.addMapping(0xF1F1F1, Blocks.field_150350_a);
        this.addMapping(14942463, MatterOverdriveBlocks.starMap);
        this.addMapping(1593517, MatterOverdriveBlocks.decorative_clean);
        this.addMapping(9786307, MatterOverdriveBlocks.forceGlass);
        this.addMapping(3528416, MatterOverdriveBlocks.replicator);
        this.addMapping(3530897, MatterOverdriveBlocks.network_switch);
        this.addMapping(13161533, MatterOverdriveBlocks.tritaniumCrate);
        this.addMapping(2769009, MatterOverdriveBlocks.androidStation, MatterOverdriveBlocks.weapon_station);
        this.addMapping(10567263, MatterOverdriveBlocks.network_pipe);
        this.addMapping(10578494, MatterOverdriveBlocks.chargingStation);
        this.addMapping(4284787, MatterOverdriveBlocks.decorative_tritanium_plate_stripe);
        this.addMapping(1603350, MatterOverdriveBlocks.pattern_monitor);
        this.addMapping(11303966, MatterOverdriveBlocks.decorative_vent_bright);
        this.addMapping(32511, MatterOverdriveBlocks.decorative_stripes);
    }

    @Override
    protected void onGeneration(Random random, World world, int x, int y, int z) {
        for (int i = 0; i < random.nextInt(3) + 3; ++i) {
            this.spawnAndroid(world, random, x + 7 + i, y + 4, z + 10);
        }
        this.spawnLegendary(world, random, x + 12, y + 4, z + 10);
    }

    @Override
    protected boolean shouldGenerate(Random random, World world, int x, int y, int z) {
        return world.field_73011_w.field_76574_g == 0;
    }

    @Override
    public void onGenerationWorkerCreated(MOWorldGenBuilding.WorldGenBuildingWorker worldGenBuildingWorker) {
    }

    @Override
    public void onBlockPlace(World world, Block block, int x, int y, int z, Random random, int color) {
        TileEntity inventory;
        if ((color & 0xFFFFFF) == 13161533 && (inventory = world.func_147438_o(x, y, z)) instanceof IInventory) {
            WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])ChestGenHooks.getInfo((String)"android_house").getItems(random), (IInventory)((IInventory)inventory), (int)(random.nextInt(10) + 10));
            if (random.nextInt(200) < 10) {
                MOInventoryHelper.insertItemStackIntoInventory((IInventory)inventory, MatterOverdrive.weaponFactory.getRandomDecoratedEnergyWeapon(new WeaponFactory.WeaponGenerationContext(3, null, true)), 0);
            }
        }
    }

    public void spawnAndroid(World world, Random random, int x, int y, int z) {
        if (random.nextInt(100) < 60) {
            EntityRangedRogueAndroidMob androidMob = new EntityRangedRogueAndroidMob(world);
            androidMob.func_70107_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            world.func_72838_d((Entity)androidMob);
            androidMob.func_110161_a(null);
            androidMob.func_110163_bv();
        } else {
            EntityMeleeRougeAndroidMob androidMob = new EntityMeleeRougeAndroidMob(world);
            androidMob.func_70107_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            world.func_72838_d((Entity)androidMob);
            androidMob.func_110161_a(null);
            androidMob.func_110163_bv();
        }
    }

    public void spawnLegendary(World world, Random random, int x, int y, int z) {
        EntityRangedRogueAndroidMob legendaryMob = new EntityRangedRogueAndroidMob(world, 3, true);
        legendaryMob.func_70107_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        world.func_72838_d((Entity)legendaryMob);
        legendaryMob.func_110161_a(null);
        legendaryMob.func_110163_bv();
    }

    @Override
    public int getMetaFromColor(int color, Random random) {
        int alpha = 255 - this.getAlphaFromColor(color);
        int side = (int)((double)alpha / 255.0 * 10.0);
        return side;
    }
}

