/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MOImageGen {
    public static HashMap<Block, Integer> worldGenerationBlockColors = new HashMap();
    private HashMap<Integer, BlockMapping> blockMap;
    protected ResourceLocation texture;
    private List<int[][]> layers;
    private int textureWidth;
    private int textureHeight;
    private int layerCount;
    protected int placeNotify;
    protected final int layerWidth;
    protected final int layerHeight;
    protected final Random localRandom = new Random();

    public MOImageGen(ResourceLocation texture, int layerWidth, int layerHeight) {
        this.blockMap = new HashMap();
        this.layerWidth = layerWidth;
        this.layerHeight = layerHeight;
        this.setTexture(texture);
    }

    public void placeBlock(World world, int color, int x, int y, int z, int layer, Random random, int placeNotify) {
        Block block = this.getBlockFromColor(color, random);
        int meta = this.getMetaFromColor(color, random);
        if (block != null) {
            world.func_147465_d(x, y, z, block, meta, placeNotify);
            this.onBlockPlace(world, block, x, y, z, random, color);
        }
    }

    public abstract void onBlockPlace(World var1, Block var2, int var3, int var4, int var5, Random var6, int var7);

    public Block getBlockFromColor(int color, Random random) {
        BlockMapping blockMapping = this.blockMap.get(color & 0xFFFFFF);
        if (blockMapping != null) {
            return blockMapping.getBlock(random);
        }
        return null;
    }

    public int getMetaFromColor(int color, Random random) {
        return 0;
    }

    public void generateFromImage(World world, Random random, int startX, int startY, int startZ, int layer, int placeNotify) {
        if (this.layers != null && this.layers.size() > 0) {
            for (BlockMapping blockMapping : this.blockMap.values()) {
                blockMapping.reset(this.localRandom);
            }
            this.generateFromImage(world, random, startX, Math.min(startY, world.func_72800_K() - this.layerCount), startZ, this.layers, layer, placeNotify);
        }
    }

    public void generateFromImage(World world, Random random, int startX, int startY, int startZ, List<int[][]> layers, int layer, int placeNotify) {
        for (int x = 0; x < this.layerWidth; ++x) {
            for (int z = 0; z < this.layerHeight; ++z) {
                this.placeBlock(world, layers.get(layer)[x][z], startX + x, startY + layer, startZ + z, layer, random, placeNotify);
            }
        }
    }

    public static void generateFromImage(World world, int startX, int startY, int startZ, int layerWidth, int layerHeight, List<int[][]> layers, Map<Integer, Block> blockMap) {
        for (int layer = 0; layer < layers.size(); ++layer) {
            for (int x = 0; x < layerWidth; ++x) {
                for (int z = 0; z < layerHeight; ++z) {
                    int color = layers.get(layer)[x][z];
                    Color c = new Color(color, true);
                    int alpha = c.getAlpha();
                    Block block = blockMap.get(color & 0xFFFFFF);
                    int meta = 255 - alpha;
                    if (block == null) continue;
                    world.func_147465_d(startX + x, startY + layer, startZ + z, block, meta, 2);
                }
            }
        }
    }

    public boolean isOnSolidGround(World world, int x, int y, int z, int leaway) {
        return this.isPointOnSolidGround(world, x, y, z, leaway) && this.isPointOnSolidGround(world, x + this.layerWidth, y, z, leaway) && this.isPointOnSolidGround(world, x + this.layerWidth, y, z + this.layerHeight, leaway) && this.isPointOnSolidGround(world, x, y, z + this.layerHeight, leaway);
    }

    public boolean isPointOnSolidGround(World world, int x, int y, int z, int leaway) {
        for (int i = 0; i < leaway; ++i) {
            if (!this.isBlockSolid(world, x, y - i, z)) continue;
            return true;
        }
        return false;
    }

    public boolean canFit(World world, int x, int y, int z) {
        return !this.isBlockSolid(world, x, y + this.layerCount, z) && !this.isBlockSolid(world, x + this.layerWidth, y + this.layerCount, z) && !this.isBlockSolid(world, x + this.layerWidth, y + this.layerCount, z + this.layerHeight) && !this.isBlockSolid(world, x, y + this.layerCount, z + this.layerHeight);
    }

    public boolean isBlockSolid(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150364_r || block == Blocks.field_150363_s && block == Blocks.field_150361_u || block == Blocks.field_150362_t) {
            return false;
        }
        return block.func_149747_d((IBlockAccess)world, x, y, z, ForgeDirection.UP.ordinal());
    }

    private boolean inAirFloatRange(World world, int x, int y, int z, int maxAirRange) {
        for (int i = 0; i < maxAirRange; ++i) {
            if (!this.isBlockSolid(world, x, y - i, z) || this.isBlockSolid(world, x, y - i + 1, z)) continue;
            return true;
        }
        return false;
    }

    protected boolean colorsMatch(int color0, int color1) {
        return (color0 & 0xFFFFFF) == (color1 & 0xFFFFFF);
    }

    public void manageTextureLoading() {
        if (this.layers == null || this.layers.size() == 0) {
            this.loadTexture(this.getTexture());
        }
    }

    private void loadTexture(ResourceLocation textureLocation) throws RuntimeException {
        try {
            String path = "/assets/" + textureLocation.func_110624_b() + "/" + textureLocation.func_110623_a();
            InputStream imageStream = this.getClass().getResourceAsStream(path);
            BufferedImage image = ImageIO.read(imageStream);
            this.textureWidth = image.getWidth();
            this.textureHeight = image.getHeight();
            this.layerCount = image.getWidth() / this.layerWidth * (image.getHeight() / this.layerHeight);
            for (int i = 0; i < this.layerCount; ++i) {
                this.layers.add(new int[this.layerWidth][this.layerHeight]);
            }
            MOImageGen.convertTo2DWithoutUsingGetRGB(image, this.layerWidth, this.layerHeight, this.textureWidth, this.layers);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<int[][]> loadTexture(File textureLocation, int layerWidth, int layerHeight) {
        try {
            BufferedImage image = ImageIO.read(textureLocation);
            int textureWidth = image.getWidth();
            int textureHeight = image.getHeight();
            int layerCount = image.getWidth() / layerWidth * (image.getHeight() / layerHeight);
            ArrayList<int[][]> layers = new ArrayList<int[][]>();
            for (int i = 0; i < layerCount; ++i) {
                layers.add(new int[layerWidth][layerHeight]);
            }
            MOImageGen.convertTo2DWithoutUsingGetRGB(image, layerWidth, layerHeight, textureWidth, layers);
            return layers;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void convertTo2DWithoutUsingGetRGB(BufferedImage image, int layerWidth, int layerHeight, int textureWidth, List<int[][]> layers) {
        boolean hasAlphaChannel;
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        boolean bl = hasAlphaChannel = image.getAlphaRaster() != null;
        if (hasAlphaChannel) {
            int pixelLength = 4;
            int row = 0;
            int col = 0;
            for (int pixel = 0; pixel < pixels.length; pixel += 4) {
                int argb = 0;
                argb += (pixels[pixel] & 0xFF) << 24;
                argb += pixels[pixel + 1] & 0xFF;
                argb += (pixels[pixel + 2] & 0xFF) << 8;
                int layerIndex = Math.floorDiv(col, layerWidth) + textureWidth / layerWidth * Math.floorDiv(row, layerHeight);
                layers.get((int)layerIndex)[col % layerWidth][row % layerHeight] = argb += (pixels[pixel + 3] & 0xFF) << 16;
                if (++col != textureWidth) continue;
                col = 0;
                ++row;
            }
        } else {
            int pixelLength = 3;
            int row = 0;
            int col = 0;
            for (int pixel = 0; pixel < pixels.length; pixel += 3) {
                int argb = 0;
                argb -= 0x1000000;
                argb += pixels[pixel] & 0xFF;
                argb += (pixels[pixel + 1] & 0xFF) << 8;
                int layerIndex = Math.floorDiv(col, layerWidth) + textureWidth / layerWidth * Math.floorDiv(row, layerHeight);
                layers.get((int)layerIndex)[col % layerWidth][row % layerHeight] = argb += (pixels[pixel + 2] & 0xFF) << 16;
                if (++col != textureWidth) continue;
                col = 0;
                ++row;
            }
        }
    }

    private static void transpose(int[][] m) {
        for (int i = 0; i < m.length; ++i) {
            for (int j = i; j < m[0].length; ++j) {
                int x = m[i][j];
                m[i][j] = m[j][i];
                m[j][i] = x;
            }
        }
    }

    public static void swapRows(int[][] m) {
        int i = 0;
        for (int k = m.length - 1; i < k; ++i, --k) {
            int[] x = m[i];
            m[i] = m[k];
            m[k] = x;
        }
    }

    public static void rotateByNinetyToLeft(int[][] m) {
        MOImageGen.transpose(m);
        MOImageGen.swapRows(m);
    }

    public static void rotateByNinetyToRight(int[][] m) {
        MOImageGen.swapRows(m);
        MOImageGen.transpose(m);
    }

    public void rotateByNinetyToLeft() {
        this.layers.forEach(MOImageGen::rotateByNinetyToLeft);
    }

    public int getRedFromColor(int color) {
        return color >> 16 & 0xFF;
    }

    public int getGreenFromColor(int color) {
        return color >> 8 & 0xFF;
    }

    public int getBlueFromColor(int color) {
        return color >> 0 & 0xFF;
    }

    public int getAlphaFromColor(int color) {
        return color >> 24 & 0xFF;
    }

    public int getColorAt(int x, int y, int layer) {
        if (x < this.textureWidth && y < this.textureHeight) {
            return this.layers.get(layer)[this.textureHeight][this.textureWidth];
        }
        return 0;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public int getLayerCount() {
        return this.layerCount;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void addMapping(int color, Block ... blocks) {
        this.addMapping(color, new BlockMapping(blocks));
    }

    public void addMapping(int color, boolean noise, Block ... blocks) {
        this.addMapping(color, new BlockMapping(noise, blocks));
    }

    public void addMapping(int color, BlockMapping blockMapping) {
        this.blockMap.put(color, blockMapping);
    }

    public BlockMapping getMapping(int color) {
        return this.blockMap.get(color);
    }

    public void setTexture(ResourceLocation textureLocation) {
        this.texture = textureLocation;
        if (this.layers == null) {
            this.layers = new ArrayList<int[][]>();
        } else {
            this.layers.clear();
        }
    }

    public static class BlockMapping {
        private Block[] blocks;
        private boolean noise;
        private int lastSelected;

        public BlockMapping(boolean noise, Block ... blocks) {
            this.blocks = blocks;
            this.noise = noise;
        }

        public BlockMapping(Block ... blocks) {
            this.blocks = blocks;
        }

        public void reset(Random random) {
            if (!this.noise) {
                this.lastSelected = random.nextInt(this.blocks.length);
            }
        }

        public Block getBlock(Random random) {
            if (this.noise) {
                return this.blocks[random.nextInt(this.blocks.length)];
            }
            return this.blocks[this.lastSelected];
        }

        public Block[] getBlocks() {
            return this.blocks;
        }

        public boolean isNoise() {
            return this.noise;
        }
    }
}

