/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world;

import java.util.Random;
import matteroverdrive.init.MatterOverdriveBlocks;
import matteroverdrive.world.MOWorldGenBuilding;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class MOSandPit
extends MOWorldGenBuilding {
    private int airLeeway;

    public MOSandPit(String name, int airLeeway) {
        super(name, new ResourceLocation("mo:textures/world/sand_pit.png"), 24, 24);
        this.setMaxDistanceToAir(airLeeway);
        this.setyOffset(-9);
        this.validSpawnBlocks = new Block[]{Blocks.field_150354_m};
        this.airLeeway = airLeeway;
        this.name = name;
        this.addMapping(14801717, Blocks.field_150322_A);
        this.addMapping(0xF1F1F1, Blocks.field_150350_a);
        this.addMapping(0xFFFF00, new Block[]{Blocks.field_150354_m});
        this.addMapping(13055457, Blocks.field_150426_aN);
        this.addMapping(3515105, Blocks.field_150355_j);
        this.addMapping(3513057, MatterOverdriveBlocks.decorative_tritanium_plate);
        this.addMapping(16745472, MatterOverdriveBlocks.decorative_coils);
        this.addMapping(7029760, Blocks.field_150422_aJ);
    }

    public boolean isFlat(World world, int x, int y, int z) {
        int y10 = world.func_72976_f(x + this.layerWidth, z);
        int y11 = world.func_72976_f(x + this.layerWidth, z + this.layerHeight);
        int y01 = world.func_72976_f(x, z + this.layerHeight);
        if (Math.abs(y - y10) <= this.airLeeway && Math.abs(y - y11) <= this.airLeeway && Math.abs(y - y01) <= this.airLeeway) {
            return this.blockBelowMatches(this.airLeeway, world, (Block)Blocks.field_150354_m, x, y, z) && this.blockBelowMatches(this.airLeeway, world, (Block)Blocks.field_150354_m, x + this.layerWidth, y, z) && this.blockBelowMatches(this.airLeeway, world, (Block)Blocks.field_150354_m, x, y, z + this.layerHeight) && this.blockBelowMatches(this.airLeeway, world, (Block)Blocks.field_150354_m, x + this.layerWidth, y, z + this.layerHeight);
        }
        return false;
    }

    private boolean blockBelowMatches(int airLeeway, World world, Block block, int x, int y, int z) {
        for (int i = 0; i < airLeeway; ++i) {
            if (world.func_147439_a(x, y - i, z) != block) continue;
            return true;
        }
        return false;
    }

    private boolean isPointOnSurface(World world, int x, int y, int z) {
        return world.func_147439_a(x, y + 1, z) == Blocks.field_150350_a;
    }

    @Override
    public void placeBlock(World world, int color, int x, int y, int z, int layer, Random random, int placeNotify) {
        if ((color & 0xFFFFFF) == 13055457) {
            Block block = this.getBlockFromColor(color, random);
            int meta = this.getMetaFromColor(color, random);
            if (block != null) {
                world.func_147465_d(x, y, z, block, meta, 3);
                this.onBlockPlace(world, block, x, y, z, random, color);
            }
        } else {
            super.placeBlock(world, color, x, y, z, layer, random, placeNotify);
        }
    }

    @Override
    public void onBlockPlace(World world, Block block, int x, int y, int z, Random random, int color) {
    }

    @Override
    protected void onGeneration(Random random, World world, int x, int y, int z) {
    }

    @Override
    protected boolean shouldGenerate(Random random, World world, int x, int y, int z) {
        return world.func_72807_a(x, y) == BiomeGenBase.field_76769_d;
    }

    @Override
    public void onGenerationWorkerCreated(MOWorldGenBuilding.WorldGenBuildingWorker worldGenBuildingWorker) {
    }
}

