/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import matteroverdrive.data.world.GenPositionWorldData;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.init.MatterOverdriveBlocks;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.world.MOAndroidHouseBuilding;
import matteroverdrive.world.MOSandPit;
import matteroverdrive.world.MOWorldGenBuilding;
import matteroverdrive.world.MOWorldGenCargoShip;
import matteroverdrive.world.MOWorldGenCrashedSpaceShip;
import matteroverdrive.world.MOWorldGenUnderwaterBase;
import matteroverdrive.world.WeightedRandomMOWorldGenBuilding;
import matteroverdrive.world.WorldGenGravitationalAnomaly;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.config.Property;

public class MOWorldGen
implements IWorldGenerator,
IConfigSubscriber {
    Random oreRandom = new Random();
    Random anomaliesRandom = new Random();
    Random buildingsRandom = new Random();
    public static WorldGenMinable dilithiumGen;
    public static WorldGenMinable tritaniumGen;
    public static MOAndroidHouseBuilding androidHouse;
    public static WorldGenGravitationalAnomaly anomalyGen;
    public static MOSandPit sandPit;
    public static MOWorldGenCrashedSpaceShip crashedSpaceShip;
    public static float BUILDING_SPAWN_CHANCE;
    public static final int TRITANIUM_VEINS_PER_CHUNK = 10;
    public static final int TRITANIUM_VEIN_SIZE = 6;
    public static final int DILITHIUM_VEINS_PER_CHUNK = 6;
    public static final int DILITHIUM_VEIN_SIZE = 5;
    public List<WeightedRandomMOWorldGenBuilding> buildings = new ArrayList<WeightedRandomMOWorldGenBuilding>();
    public Queue<MOWorldGenBuilding.WorldGenBuildingWorker> worldGenBuildingQueue = new ArrayDeque<MOWorldGenBuilding.WorldGenBuildingWorker>();
    HashSet<Integer> oreDimentionsBlacklist;
    boolean generateTritanium;
    boolean generateDilithium;
    boolean generateAnomalies;
    boolean generateBuildings;

    public MOWorldGen(ConfigurationHandler configurationHandler) {
        tritaniumGen = new WorldGenMinable((Block)MatterOverdriveBlocks.tritaniumOre, 6);
        dilithiumGen = new WorldGenMinable((Block)MatterOverdriveBlocks.dilithium_ore, 5);
        this.buildings.add(new WeightedRandomMOWorldGenBuilding(new MOAndroidHouseBuilding("android_house"), 20));
        this.buildings.add(new WeightedRandomMOWorldGenBuilding(new MOSandPit("sand_pit_house", 3), 100));
        this.buildings.add(new WeightedRandomMOWorldGenBuilding(new MOWorldGenCrashedSpaceShip("crashed_ship"), 60));
        this.buildings.add(new WeightedRandomMOWorldGenBuilding(new MOWorldGenUnderwaterBase("underwater_base"), 20));
        this.buildings.add(new WeightedRandomMOWorldGenBuilding(new MOWorldGenCargoShip("cargo_ship"), 5));
        anomalyGen = new WorldGenGravitationalAnomaly("gravitational_anomaly", 0.005f, 2048, 10240);
        this.oreDimentionsBlacklist = new HashSet();
        configurationHandler.subscribe(anomalyGen);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                this.generateOverworld(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 2: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            default: {
                this.generateOther(world, random, chunkX * 16, chunkZ * 16);
            }
        }
        long worldSeed = world.func_72905_C();
        Random moRandom = new Random(worldSeed);
        long xSeed = moRandom.nextLong() >> 3;
        long zSeed = moRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
        this.oreRandom.setSeed(chunkSeed);
        this.anomaliesRandom.setSeed(chunkSeed);
        this.buildingsRandom.setSeed(chunkSeed);
        this.generateGravitationalAnomalies(world, this.anomaliesRandom, chunkX * 16, chunkZ * 16, world.field_73011_w.field_76574_g);
        this.generateOres(world, this.oreRandom, chunkX * 16, chunkZ * 16, world.field_73011_w.field_76574_g);
        this.startGenerateBuildings(world, this.buildingsRandom, chunkX, chunkZ, chunkGenerator, chunkProvider);
    }

    public void generateOverworld(World world, Random random, int chunkX, int chunkZ) {
    }

    public void generateNether(World world, Random random, int chunkX, int chunkZ) {
    }

    public void generateEnd(World world, Random random, int chunkX, int chunkZ) {
    }

    public void generateOther(World world, Random random, int chunkX, int chunkZ) {
    }

    public void generateOres(World world, Random random, int chunkX, int chunkZ, int dimentionID) {
        if (!this.oreDimentionsBlacklist.contains(dimentionID)) {
            int y;
            int z;
            int x;
            int i;
            if (this.generateDilithium) {
                for (i = 0; i < 6; ++i) {
                    x = chunkX + random.nextInt(16);
                    z = chunkZ + random.nextInt(16);
                    y = random.nextInt(28) + 4;
                    if (!dilithiumGen.func_76484_a(world, random, x, y, z)) continue;
                }
            }
            if (this.generateTritanium) {
                for (i = 0; i < 10; ++i) {
                    x = chunkX + random.nextInt(16);
                    z = chunkZ + random.nextInt(16);
                    y = random.nextInt(60) + 4;
                    if (!tritaniumGen.func_76484_a(world, random, x, y, z)) continue;
                }
            }
        }
    }

    private void generateGravitationalAnomalies(World world, Random random, int chunkX, int chunkZ, int dimention) {
        if (this.generateAnomalies) {
            int x = chunkX + random.nextInt(16);
            int z = chunkZ + random.nextInt(16);
            int y = random.nextInt(60) + 4;
            if (anomalyGen.func_76484_a(world, random, x, y, z)) {
                // empty if block
            }
        }
    }

    private boolean shouldGenerate(Block block, ConfigurationHandler config) {
        Property p = config.config.get("world gen", "spawn." + block.func_149739_a(), true);
        p.setLanguageKey(block.func_149739_a() + ".name");
        return p.getBoolean(true);
    }

    private void startGenerateBuildings(World world, Random random, int chunkX, int chunkZ, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int ZCoord;
        int YCoord;
        int XCoord;
        WeightedRandomMOWorldGenBuilding building;
        if (this.generateBuildings && random.nextDouble() < (double)BUILDING_SPAWN_CHANCE && (building = this.getRandomBuilding(world, XCoord = chunkX * 16 + random.nextInt(16), YCoord = world.func_72976_f(XCoord, ZCoord = chunkZ * 16 + random.nextInt(16)) - 2, ZCoord, random)) != null) {
            this.startBuildingGeneration(building.worldGenBuilding, XCoord, YCoord, ZCoord, random, world, chunkGenerator, chunkProvider, false);
        }
    }

    public MOWorldGenBuilding.WorldGenBuildingWorker startBuildingGeneration(MOWorldGenBuilding building, int x, int y, int z, Random random, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider, boolean forceGeneration) {
        if (building != null && (forceGeneration || building.shouldGenerate(random, world, x, y, z) && building.isLocationValid(world, x, y, z))) {
            MOWorldGenBuilding.WorldGenBuildingWorker worker = building.createWorker(random, x, y, z, world, chunkGenerator, chunkProvider);
            this.worldGenBuildingQueue.add(worker);
            return worker;
        }
        return null;
    }

    public void manageBuildingGeneration(TickEvent.WorldTickEvent worldTickEvent) {
        MOWorldGenBuilding.WorldGenBuildingWorker worker = this.worldGenBuildingQueue.peek();
        if (worker != null && worker.generate()) {
            this.worldGenBuildingQueue.remove();
            return;
        }
    }

    public WeightedRandomMOWorldGenBuilding getRandomBuilding(World world, int x, int y, int z, Random random) {
        return this.getBuilding(random, world, x, y, z, this.buildings, random.nextInt(this.getTotalBuildingsWeight(random, world, x, y, z, this.buildings)));
    }

    public int getTotalBuildingsWeight(Random random, World world, int x, int y, int z, Collection p_76272_0_) {
        int i = 0;
        for (WeightedRandomMOWorldGenBuilding building : p_76272_0_) {
            i += building.getWeight(random, world, x, y, z);
        }
        return i;
    }

    public WeightedRandomMOWorldGenBuilding getBuilding(Random random, World world, int x, int y, int z, Collection par1Collection, int weight) {
        WeightedRandomMOWorldGenBuilding building;
        int j = weight;
        Iterator iterator = par1Collection.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while ((j -= (building = (WeightedRandomMOWorldGenBuilding)((Object)iterator.next())).getWeight(random, world, x, y, z)) >= 0);
        return building;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        Property shouldGenerateOres = config.config.get("world gen", "spawn ores", true);
        shouldGenerateOres.comment = "Should Matter Overdrive Ore Blocks be Generated ?";
        this.generateTritanium = this.shouldGenerate(MatterOverdriveBlocks.tritaniumOre, config) && shouldGenerateOres.getBoolean(true);
        this.generateDilithium = this.shouldGenerate(MatterOverdriveBlocks.dilithium_ore, config) && shouldGenerateOres.getBoolean(true);
        Property shouldGenerateOthers = config.config.get("world gen", "spawn other", true);
        shouldGenerateOthers.comment = "Should other Matter Overdrive World Blocks be Generated?";
        this.generateAnomalies = this.shouldGenerate(MatterOverdriveBlocks.gravitational_anomaly, config) && shouldGenerateOthers.getBoolean(true);
        this.oreDimentionsBlacklist.clear();
        Property oreDimentionBlacklistProp = config.config.get("world gen", "ore_gen_blacklist", new int[]{-1, 2});
        oreDimentionBlacklistProp.comment = "A blacklist of all the Dimensions ores shouldn't spawn in";
        oreDimentionBlacklistProp.setLanguageKey("config.ore_gen_blacklist.name");
        int[] oreDimentionBlacklist = oreDimentionBlacklistProp.getIntList();
        for (int i = 0; i < oreDimentionBlacklist.length; ++i) {
            this.oreDimentionsBlacklist.add(oreDimentionBlacklist[i]);
        }
        this.generateBuildings = config.getBool("generate buildings", "world gen", true, "Should Matter Overdrive Buildings Generate aka ImageGen");
    }

    public static GenPositionWorldData getWorldPositionData(World world) {
        GenPositionWorldData data = (GenPositionWorldData)world.func_72943_a(GenPositionWorldData.class, "MOWorldGenPositions");
        if (data == null) {
            data = new GenPositionWorldData("MOWorldGenPositions");
            world.func_72823_a("MOWorldGenPositions", (WorldSavedData)data);
        }
        return data;
    }

    static {
        BUILDING_SPAWN_CHANCE = 0.01f;
    }
}

