/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedInputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.core.OreExcavation;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class UpdateNotification {
    public static Future<String> checkThread;
    private static final String MOD_NAME = "OreExcavation";
    private static final String GIT_BRANCH = "";
    private static final String CUR_HASH = "";
    private static final String DEB_HASH = "CI_MOD_HASH";
    private static final String URL_UPDATE = "https://goo.gl/q9VC9j";
    private static final String URL_DOWNLOAD = "http://minecraft.curseforge.com/projects/ore-excavation";
    private boolean hasChecked = false;
    private final Logger logger = OreExcavation.logger;
    private final boolean hidden = ExcavationSettings.hideUpdates;

    public static void startUpdateCheck() {
        if ("".equalsIgnoreCase(DEB_HASH)) {
            return;
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        checkThread = executor.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return UpdateNotification.getNotification(UpdateNotification.URL_UPDATE, true);
            }
        });
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        block11: {
            if ("".equalsIgnoreCase(DEB_HASH)) {
                event.player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "THIS COPY OF " + MOD_NAME.toUpperCase() + " IS NOT FOR PUBLIC USE!"));
                return;
            }
            if (this.hasChecked || checkThread == null || !checkThread.isDone()) {
                return;
            }
            this.hasChecked = true;
            if (this.hidden) {
                return;
            }
            try {
                boolean hasUpdate;
                String[] data = checkThread.get().split("\\n");
                ArrayList<String> changelog = new ArrayList<String>();
                boolean hasLog = false;
                for (String s : data) {
                    if (s.equalsIgnoreCase("git_branch:")) {
                        if (hasLog) break;
                        hasLog = true;
                        changelog.add(s);
                        continue;
                    }
                    if (s.toLowerCase().startsWith("git_branch:")) {
                        if (!hasLog) continue;
                        break;
                    }
                    if (!hasLog) continue;
                    changelog.add(s);
                }
                if (!hasLog || data.length < 2) {
                    event.player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "An error has occured while checking " + MOD_NAME + " version!"));
                    this.logger.log(Level.ERROR, "An error has occured while checking OreExcavation version! (hasLog: " + hasLog + ", data: " + data.length + ")");
                    return;
                }
                data = changelog.toArray(new String[0]);
                String hash = data[1].trim();
                boolean bl = hasUpdate = !"".equalsIgnoreCase(hash);
                if (!hasUpdate) break block11;
                event.player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Update for " + MOD_NAME + " available!"));
                ChatComponentText dlUrl = new ChatComponentText("Download: http://minecraft.curseforge.com/projects/ore-excavation");
                dlUrl.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, URL_DOWNLOAD));
                event.player.func_145747_a((IChatComponent)dlUrl);
                for (int i = 2; i < data.length; ++i) {
                    if (i > 5) {
                        event.player.func_145747_a((IChatComponent)new ChatComponentText("and " + (data.length - 5) + " more..."));
                        break;
                    }
                    event.player.func_145747_a((IChatComponent)new ChatComponentText("- " + data[i].trim()));
                }
            }
            catch (Exception e) {
                event.player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "An error has occured while checking " + MOD_NAME + " version!"));
                this.logger.log(Level.ERROR, "An error has occured while checking OreExcavation version!", (Throwable)e);
                return;
            }
        }
    }

    public static String getNotification(String link, boolean doRedirect) throws Exception {
        int chars_read;
        URL url = new URL(link);
        HttpURLConnection.setFollowRedirects(false);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setDoOutput(false);
        con.setReadTimeout(20000);
        con.setRequestProperty("Connection", "keep-alive");
        con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:16.0) Gecko/20100101 Firefox/16.0");
        con.setRequestMethod("GET");
        con.setConnectTimeout(5000);
        BufferedInputStream in = new BufferedInputStream(con.getInputStream());
        int responseCode = con.getResponseCode();
        HttpURLConnection.setFollowRedirects(true);
        if (responseCode != 200 && responseCode != 301) {
            System.out.println("Update request returned response code: " + responseCode + " " + con.getResponseMessage());
        } else if (responseCode == 301) {
            if (doRedirect) {
                return UpdateNotification.getNotification(con.getHeaderField("location"), false);
            }
            throw new Exception();
        }
        StringBuffer buffer = new StringBuffer();
        while ((chars_read = in.read()) != -1) {
            char g = (char)chars_read;
            buffer.append(g);
        }
        return buffer.toString();
    }
}

