/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.handlers;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import oreexcavation.client.ExcavationKeys;
import oreexcavation.client.GuiEditShapes;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.core.OreExcavation;
import oreexcavation.groups.BlockBlacklist;
import oreexcavation.groups.ItemBlacklist;
import oreexcavation.handlers.ConfigHandler;
import oreexcavation.handlers.MiningAgent;
import oreexcavation.handlers.MiningScheduler;
import oreexcavation.network.PacketExcavation;
import oreexcavation.shapes.ExcavateShape;
import oreexcavation.shapes.ShapeRegistry;
import oreexcavation.utils.BlockPos;
import oreexcavation.utils.ToolEffectiveCheck;
import org.lwjgl.input.Keyboard;

public class EventHandler {
    public static MiningAgent captureAgent;
    public static boolean skipNext;
    public static boolean isExcavating;
    private static int cTick;

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("oreexcavation")) {
            ConfigHandler.config.save();
            ConfigHandler.initConfigs();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyPressed(InputEvent event) {
        if (ExcavationKeys.shapeKey.func_151468_f()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (Keyboard.isKeyDown((int)29)) {
                mc.func_147108_a((GuiScreen)new GuiEditShapes());
            } else {
                ShapeRegistry.INSTANCE.toggleShape();
                ExcavateShape shape = ShapeRegistry.INSTANCE.getActiveShape();
                if (shape == null) {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((IChatComponent)new ChatComponentText("Excavate Shape: NONE"));
                } else {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((IChatComponent)new ChatComponentText("Excavate Shape: " + shape.getName()));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.world.field_72995_K || event.entity.field_70128_L || event.isCanceled()) {
            return;
        }
        if (captureAgent != null) {
            if (event.entity instanceof EntityItem) {
                EntityItem eItem = (EntityItem)event.entity;
                ItemStack stack = eItem.func_92059_d();
                captureAgent.addItemDrop(stack);
                event.setCanceled(true);
            } else if (event.entity instanceof EntityXPOrb) {
                EntityXPOrb orb = (EntityXPOrb)event.entity;
                captureAgent.addExperience(orb.func_70526_d());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        MiningAgent agent;
        if (event.world.field_72995_K || event.isCanceled()) {
            return;
        }
        if (captureAgent != null && !captureAgent.hasMinedPosition(new BlockPos(event.x, event.y, event.z))) {
            return;
        }
        if (!(event.getPlayer() instanceof EntityPlayerMP) || event.getPlayer() instanceof FakePlayer) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getPlayer();
        if (player.func_70694_bm() == null && !ExcavationSettings.openHand) {
            return;
        }
        if (this.isToolBlacklisted(player.func_70694_bm()) != ExcavationSettings.invertTBlacklist) {
            return;
        }
        if (this.isBlockBlacklisted(event.block, event.blockMetadata) != ExcavationSettings.invertBBlacklist) {
            return;
        }
        if (event.block.isAir((IBlockAccess)event.world, event.x, event.y, event.z)) {
            return;
        }
        if ((ExcavationSettings.ignoreTools || ToolEffectiveCheck.canHarvestBlock(event.world, event.block, event.blockMetadata, new BlockPos(event.x, event.y, event.z), (EntityPlayer)player)) && (agent = MiningScheduler.INSTANCE.getActiveAgent(player.func_110124_au())) == null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("x", event.x);
            tag.func_74768_a("y", event.y);
            tag.func_74768_a("z", event.z);
            tag.func_74778_a("block", Block.field_149771_c.func_148750_c((Object)event.block));
            tag.func_74768_a("meta", event.blockMetadata);
            OreExcavation.instance.network.sendTo((IMessage)new PacketExcavation(tag), player);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (skipNext) {
            skipNext = false;
            return;
        }
        MiningScheduler.INSTANCE.tickAgents(MinecraftServer.func_71276_C());
        captureAgent = null;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if ((cTick = (cTick + 1) % 10) != 0 || Minecraft.func_71410_x().field_71439_g == null || !isExcavating || !ExcavationSettings.mustHold) {
            return;
        }
        boolean canContinue = true;
        if (ExcavationSettings.mineMode < 0) {
            canContinue = false;
        } else if (ExcavationSettings.mineMode == 0) {
            if (!ExcavationKeys.excavateKey.func_151470_d()) {
                canContinue = false;
            }
        } else if (ExcavationSettings.mineMode != 2 && !Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
            canContinue = false;
        }
        if (!canContinue) {
            isExcavating = false;
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74757_a("cancel", true);
            OreExcavation.instance.network.sendToServer((IMessage)new PacketExcavation(tags));
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.field_72995_K || MinecraftServer.func_71276_C().func_71278_l()) {
            return;
        }
        MiningScheduler.INSTANCE.resetAll();
        captureAgent = null;
    }

    public boolean isBlockBlacklisted(Block block, int metadata) {
        if (block == null || block == Blocks.field_150350_a) {
            return false;
        }
        return BlockBlacklist.INSTANCE.isBanned(block, metadata);
    }

    public boolean isToolBlacklisted(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        return ItemBlacklist.INSTANCE.isBanned(stack);
    }

    static {
        skipNext = false;
        isExcavating = false;
        cTick = 0;
    }
}

