/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.handlers;

import com.google.common.base.Stopwatch;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.events.EventExcavate;
import oreexcavation.handlers.EventHandler;
import oreexcavation.handlers.MiningAgent;
import oreexcavation.shapes.ExcavateShape;
import oreexcavation.undo.ExcavateHistory;
import oreexcavation.undo.RestoreResult;
import oreexcavation.utils.BlockPos;

public class MiningScheduler {
    public static final MiningScheduler INSTANCE = new MiningScheduler();
    private HashMap<UUID, MiningAgent> agents = new HashMap();
    private HashMap<String, ExcavateHistory> undoing = new HashMap();
    private HashMap<UUID, List<ExcavateHistory>> undoHistory = new HashMap();
    private Stopwatch timer = Stopwatch.createStarted();

    private MiningScheduler() {
    }

    public MiningAgent getActiveAgent(UUID uuid) {
        return this.agents.get(uuid);
    }

    public void stopMining(EntityPlayerMP player) {
        MiningAgent a = this.agents.get(player.func_110124_au());
        MinecraftForge.EVENT_BUS.post((Event)new EventExcavate.Post(a));
        if (a != null) {
            a.dropEverything();
        }
        this.agents.remove(player.func_110124_au());
    }

    public MiningAgent startMining(EntityPlayerMP player, BlockPos pos, Block block, int meta, ExcavateShape shape) {
        MiningAgent existing = this.agents.get(player.func_110124_au());
        if (existing != null) {
            existing.appendBlock(pos);
        } else {
            existing = new MiningAgent(player, pos, block, meta);
            if (shape != null) {
                existing.setShape(shape, ExcavateShape.getFacing((EntityPlayer)player));
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new EventExcavate.Pre(existing))) {
                return null;
            }
            this.agents.put(player.func_110124_au(), existing);
            existing.init();
        }
        return existing;
    }

    public RestoreResult attemptUndo(EntityPlayer player) {
        RestoreResult result = RestoreResult.NO_UNDO_HISTORY;
        ArrayList list = this.undoHistory.get(player.func_110124_au());
        ArrayList arrayList = list = list != null ? list : new ArrayList();
        if (list.size() <= 0) {
            return RestoreResult.NO_UNDO_HISTORY;
        }
        result = ((ExcavateHistory)list.get(list.size() - 1)).canRestore(MinecraftServer.func_71276_C(), player);
        if (result == RestoreResult.SUCCESS) {
            this.undoing.put(player.func_70005_c_(), (ExcavateHistory)list.remove(list.size() - 1));
        }
        return result;
    }

    public void appendHistory(UUID uuid, ExcavateHistory history) {
        ArrayList<ExcavateHistory> list = this.undoHistory.get(uuid);
        list = list != null ? list : new ArrayList<ExcavateHistory>();
        list.add(history);
        while (list.size() > ExcavationSettings.maxUndos) {
            list.remove(0);
        }
        this.undoHistory.put(uuid, list);
    }

    public void tickAgents(MinecraftServer server) {
        boolean complete;
        this.timer.reset();
        this.timer.start();
        Iterator<Map.Entry<UUID, MiningAgent>> iterAgents = this.agents.entrySet().iterator();
        while (iterAgents.hasNext()) {
            MiningAgent a;
            if (ExcavationSettings.tpsGuard && this.timer.elapsed(TimeUnit.MILLISECONDS) > 40L) {
                EventHandler.skipNext = true;
                break;
            }
            Map.Entry<UUID, MiningAgent> entry = iterAgents.next();
            EventHandler.captureAgent = a = entry.getValue();
            complete = a.tickMiner();
            EventHandler.captureAgent = null;
            if (!complete) continue;
            MinecraftForge.EVENT_BUS.post((Event)new EventExcavate.Post(a));
            a.dropEverything();
            this.appendHistory(entry.getKey(), a.getHistory());
            iterAgents.remove();
        }
        Iterator<Map.Entry<String, ExcavateHistory>> iterUndo = this.undoing.entrySet().iterator();
        while (iterUndo.hasNext()) {
            if (ExcavationSettings.tpsGuard && this.timer.elapsed(TimeUnit.MILLISECONDS) > 40L) {
                EventHandler.skipNext = true;
                break;
            }
            Map.Entry<String, ExcavateHistory> entry = iterUndo.next();
            complete = entry.getValue().tickRestore(server, (EntityPlayer)server.func_71203_ab().func_152612_a(entry.getKey()));
            if (!complete) continue;
            iterUndo.remove();
        }
        this.timer.stop();
    }

    public void resetAll() {
        this.agents.clear();
        this.undoing.clear();
        this.undoHistory.clear();
    }
}

