/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import oreexcavation.client.ExcavationKeys;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.handlers.EventHandler;
import oreexcavation.handlers.MiningScheduler;
import oreexcavation.shapes.ExcavateShape;
import oreexcavation.shapes.ShapeRegistry;
import oreexcavation.utils.BlockPos;

public class PacketExcavation
implements IMessage {
    private NBTTagCompound tags = new NBTTagCompound();

    public PacketExcavation() {
    }

    public PacketExcavation(NBTTagCompound tags) {
        this.tags = tags;
    }

    public void fromBytes(ByteBuf buf) {
        this.tags = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tags);
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientHandler
    implements IMessageHandler<PacketExcavation, PacketExcavation> {
        public PacketExcavation onMessage(PacketExcavation message, MessageContext ctx) {
            if (ExcavationSettings.mineMode < 0) {
                return null;
            }
            if (ExcavationSettings.mineMode == 0 ? ExcavationKeys.excavateKey.func_151463_i() == 0 || !ExcavationKeys.excavateKey.func_151470_d() : ExcavationSettings.mineMode != 2 && !Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
                return null;
            }
            EventHandler.isExcavating = true;
            ExcavateShape shape = ShapeRegistry.INSTANCE.getActiveShape();
            if (shape != null) {
                message.tags.func_74768_a("shape", shape.getShapeMask());
                message.tags.func_74768_a("depth", shape.getMaxDepth());
                message.tags.func_74768_a("origin", shape.getReticle());
            }
            return new PacketExcavation(message.tags);
        }
    }

    public static class ServerHandler
    implements IMessageHandler<PacketExcavation, PacketExcavation> {
        public PacketExcavation onMessage(PacketExcavation message, MessageContext ctx) {
            ExcavateShape shape;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (player == null) {
                return null;
            }
            if (message.tags.func_74767_n("cancel")) {
                MiningScheduler.INSTANCE.stopMining(player);
                return null;
            }
            int x = message.tags.func_74762_e("x");
            int y = message.tags.func_74762_e("y");
            int z = message.tags.func_74762_e("z");
            Block block = (Block)Block.field_149771_c.func_82594_a(message.tags.func_74779_i("block"));
            int meta = message.tags.func_74762_e("meta");
            if (block == null || block == Blocks.field_150350_a) {
                return null;
            }
            if (message.tags.func_74764_b("shape")) {
                if (!ExcavationSettings.allowShapes) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Shape mining has been disabled"));
                    return null;
                }
                shape = new ExcavateShape();
                shape.setMask(message.tags.func_74762_e("shape"));
                if (message.tags.func_74764_b("depth")) {
                    shape.setMaxDepth(message.tags.func_74762_e("depth"));
                }
                if (message.tags.func_74764_b("origin")) {
                    int origin = message.tags.func_74762_e("origin");
                    shape.setReticle(origin % 5, origin / 5);
                }
            } else {
                shape = null;
            }
            MiningScheduler.INSTANCE.startMining(player, new BlockPos(x, y, z), block, meta, shape);
            return null;
        }
    }
}

