/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.utils;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BigItemStack {
    public int stackSize = 0;
    public String oreDict = "";
    ItemStack baseStack = new ItemStack(Blocks.field_150348_b);

    public BigItemStack(ItemStack stack) {
        this.baseStack = stack.func_77946_l();
        this.stackSize = this.baseStack.field_77994_a;
        this.baseStack.field_77994_a = 1;
    }

    public BigItemStack(Block block) {
        this(block, 1);
    }

    public BigItemStack(Block block, int amount) {
        this(block, amount, 0);
    }

    public BigItemStack(Block block, int amount, int damage) {
        this(Item.func_150898_a((Block)block), amount, damage);
    }

    public BigItemStack(Item item) {
        this(item, 1);
    }

    public BigItemStack(Item item, int amount) {
        this(item, amount, 0);
    }

    public BigItemStack(Item item, int amount, int damage) {
        this.baseStack = new ItemStack(item, 1, damage);
        this.stackSize = amount;
    }

    public ItemStack getBaseStack() {
        return this.baseStack;
    }

    public NBTTagCompound GetTagCompound() {
        return this.baseStack.func_77978_p();
    }

    public void SetTagCompound(NBTTagCompound tags) {
        this.baseStack.func_77982_d(tags);
    }

    public boolean HasTagCompound() {
        return this.baseStack.func_77942_o();
    }

    public ArrayList<ItemStack> getCombinedStacks() {
        int size;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int tmp1 = Math.max(1, this.stackSize); tmp1 > 0; tmp1 -= size) {
            size = Math.min(tmp1, this.baseStack.func_77976_d());
            ItemStack stack = this.baseStack.func_77946_l();
            stack.field_77994_a = size;
            list.add(stack);
        }
        return list;
    }

    public BigItemStack copy() {
        BigItemStack stack = new BigItemStack(this.baseStack.func_77946_l());
        stack.stackSize = this.stackSize;
        stack.oreDict = this.oreDict;
        return stack;
    }

    public boolean equals(Object stack) {
        if (stack instanceof ItemStack) {
            return this.baseStack.func_77969_a((ItemStack)stack) && ItemStack.func_77970_a((ItemStack)this.baseStack, (ItemStack)((ItemStack)stack));
        }
        return super.equals(stack);
    }

    public static BigItemStack loadItemStackFromNBT(NBTTagCompound tags) {
        int count = tags.func_74762_e("Count");
        String dict = tags.func_74779_i("OreDict");
        ItemStack miniStack = ItemStack.func_77949_a((NBTTagCompound)tags);
        BigItemStack bigStack = new BigItemStack(miniStack);
        bigStack.stackSize = count;
        bigStack.oreDict = dict;
        return bigStack;
    }

    public void readFromNBT(NBTTagCompound tags) {
        this.stackSize = tags.func_74762_e("Count");
        this.oreDict = tags.func_74779_i("OreDict");
        this.baseStack.func_77963_c(tags);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tags) {
        this.baseStack.func_77955_b(tags);
        tags.func_74768_a("Count", this.stackSize);
        tags.func_74778_a("OreDict", this.oreDict);
        return tags;
    }
}

