/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.blocks.machines;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.blocks.machines.AdvancedFuelLoader;
import com.mjr.extraplanets.blocks.machines.AdvancedOxygenCompressor;
import com.mjr.extraplanets.blocks.machines.AdvancedRefinery;
import com.mjr.extraplanets.blocks.machines.BlockSolar;
import com.mjr.extraplanets.blocks.machines.UltimateFuelLoader;
import com.mjr.extraplanets.blocks.machines.UltimateOxygenCompressor;
import com.mjr.extraplanets.blocks.machines.UltimateRefinery;
import com.mjr.extraplanets.blocks.machines.VehicleCharger;
import com.mjr.extraplanets.itemBlocks.machines.ItemBlockAdvancedOxygenCompressor;
import com.mjr.extraplanets.itemBlocks.machines.ItemBlockSolar;
import com.mjr.extraplanets.itemBlocks.machines.ItemBlockUltimateOxygenCompressor;
import com.mjr.extraplanets.tile.machines.TileEntityAdvancedFuelLoader;
import com.mjr.extraplanets.tile.machines.TileEntityAdvancedOxygenCompressor;
import com.mjr.extraplanets.tile.machines.TileEntityAdvancedOxygenDecompressor;
import com.mjr.extraplanets.tile.machines.TileEntityAdvancedRefinery;
import com.mjr.extraplanets.tile.machines.TileEntitySolar;
import com.mjr.extraplanets.tile.machines.TileEntityUltimateFuelLoader;
import com.mjr.extraplanets.tile.machines.TileEntityUltimateOxygenCompressor;
import com.mjr.extraplanets.tile.machines.TileEntityUltimateOxygenDecompressor;
import com.mjr.extraplanets.tile.machines.TileEntityUltimateRefinery;
import com.mjr.extraplanets.tile.machines.TileEntityVehicleChanger;
import cpw.mods.fml.common.registry.GameRegistry;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;

public class ExtraPlanets_Machines {
    public static Block advancedRefinery;
    public static Block ultimateRefinery;
    public static Block advancedFuelLoader;
    public static Block ultimateFuelLoader;
    public static Block advancedOxygenCompressor;
    public static Block ultimateOxygenCompressor;
    public static Block solarPanel;
    public static Block chargingBlock;

    public static void init() {
        ExtraPlanets_Machines.initializeMachinesBlocks();
        ExtraPlanets_Machines.registerMachines();
        ExtraPlanets_Machines.registerMachineTileEntitys();
    }

    private static void initializeMachinesBlocks() {
        if (Config.advancedRefinery) {
            advancedRefinery = new AdvancedRefinery("advancedRefinery");
        }
        if (Config.ultimateRefinery) {
            ultimateRefinery = new UltimateRefinery("ultimateRefinery");
        }
        if (Config.advancedFuelLoader) {
            advancedFuelLoader = new AdvancedFuelLoader("advancedFuelLoader");
        }
        if (Config.ultimateFuelLoader) {
            ultimateFuelLoader = new UltimateFuelLoader("ultimateFuelLoader");
        }
        advancedOxygenCompressor = new AdvancedOxygenCompressor(false, "advancedOxygenCompressor");
        ultimateOxygenCompressor = new UltimateOxygenCompressor(false, "ultimateOxygenCompressor");
        if (Config.solarPanels) {
            solarPanel = new BlockSolar("solar");
        }
        if (Config.chargingBlock) {
            chargingBlock = new VehicleCharger("chargingBlock");
        }
    }

    private static void registerMachines() {
        if (Config.advancedRefinery) {
            GameRegistry.registerBlock((Block)advancedRefinery, (String)"advancedRefinery");
        }
        if (Config.ultimateRefinery) {
            GameRegistry.registerBlock((Block)ultimateRefinery, (String)"ultimateRefinery");
        }
        if (Config.advancedFuelLoader) {
            GameRegistry.registerBlock((Block)advancedFuelLoader, (String)"advancedFuelLoader");
        }
        if (Config.ultimateFuelLoader) {
            GameRegistry.registerBlock((Block)ultimateFuelLoader, (String)"ultimateFuelLoader");
        }
        if (Config.advancedOxygenCompressor) {
            GameRegistry.registerBlock((Block)advancedOxygenCompressor, ItemBlockAdvancedOxygenCompressor.class, (String)"advancedOxygenCompressor");
        }
        if (Config.ultimateOxygenCompressor) {
            GameRegistry.registerBlock((Block)ultimateOxygenCompressor, ItemBlockUltimateOxygenCompressor.class, (String)"ultimateOxygenCompressor");
        }
        if (Config.solarPanels) {
            GCCoreUtil.registerGalacticraftBlock((String)"solarPanelHybrid", (Block)solarPanel, (int)0);
            GCCoreUtil.registerGalacticraftBlock((String)"solarPanelUltimate", (Block)solarPanel, (int)4);
            GameRegistry.registerBlock((Block)solarPanel, ItemBlockSolar.class, (String)solarPanel.func_149739_a());
        }
        if (Config.chargingBlock) {
            GameRegistry.registerBlock((Block)chargingBlock, (String)"chargingBlock");
        }
    }

    private static void registerMachineTileEntitys() {
        if (Config.advancedRefinery) {
            GameRegistry.registerTileEntity(TileEntityAdvancedRefinery.class, (String)"ExtraPlanetsAdvancedRefinery");
        }
        if (Config.ultimateRefinery) {
            GameRegistry.registerTileEntity(TileEntityUltimateRefinery.class, (String)"ExtraPlanetsUltimateRefinery");
        }
        if (Config.advancedFuelLoader) {
            GameRegistry.registerTileEntity(TileEntityAdvancedFuelLoader.class, (String)"ExtraPlanetsAdvancedFuelLoader");
        }
        if (Config.ultimateFuelLoader) {
            GameRegistry.registerTileEntity(TileEntityUltimateFuelLoader.class, (String)"ExtraPlanetsUltimateFuelLoader");
        }
        if (Config.advancedOxygenCompressor) {
            GameRegistry.registerTileEntity(TileEntityAdvancedOxygenCompressor.class, (String)"ExtraPlanetsAdvancedOxygenCompressor");
            GameRegistry.registerTileEntity(TileEntityAdvancedOxygenDecompressor.class, (String)"ExtraPlanetsAdvancedOxygenDecompressor");
        }
        if (Config.ultimateOxygenCompressor) {
            GameRegistry.registerTileEntity(TileEntityUltimateOxygenCompressor.class, (String)"ExtraPlanetsUltimateOxygenCompressor");
            GameRegistry.registerTileEntity(TileEntityUltimateOxygenDecompressor.class, (String)"ExtraPlanetsUltimateOxygenDecompressor");
        }
        if (Config.solarPanels) {
            GameRegistry.registerTileEntity(TileEntitySolar.class, (String)"ExtraPlanetsSolar Panel");
        }
        if (Config.chargingBlock) {
            GameRegistry.registerTileEntity(TileEntityVehicleChanger.class, (String)"ExtraPlanetsVehicleChanger");
        }
    }
}

